/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.sqlj.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.sqlj.compiler.Res;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.SystemLog;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;
import sqlj.framework.ClassResolver;
import sqlj.framework.ide.DefaultClassResolver;
import sqlj.framework.ide.TranslationCharInput;
import sqlj.framework.ide.TranslationInput;
import sqlj.framework.ide.TranslationLog;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.ide.TranslationOutput;
import sqlj.framework.ide.TranslationUnit;
import sqlj.framework.ide.Translator;
import sqlj.util.Disposable;
import sqlj.util.io.OracleOutputStreamWriter;

class SqljInternal
implements TranslationOptionsQuery {
    static final String sqljExt = ".sqlj";
    static final String javaExt = ".java";
    static final String serExt = ".ser";
    private IdeEnv ide;
    private TranslatorClassResolver resolver;
    private URL projectURL;
    private Storage[] dependentJavaFiles;

    void $init$() {
        this.dependentJavaFiles = null;
    }

    SqljInternal(IdeEnv ideEnv) {
        this.$init$();
        this.ide = ideEnv;
    }

    void cleanup() {
        Disposable.disposer.dispose();
        this.dependentJavaFiles = null;
    }

    void addDependentJavaFiles(Storage[] storageArray) {
        this.dependentJavaFiles = storageArray;
    }

    ArrayList translate(ArrayList arrayList, ArrayList arrayList2, Log log, Properties properties) {
        ArrayList<Boolean> arrayList3;
        block8: {
            TranslationLogInternal translationLogInternal = new TranslationLogInternal(log);
            int n = log.nerrors();
            arrayList3 = null;
            try {
                this.resolver = new TranslatorClassResolver(null);
                this.resolver.setProjectURL(this.projectURL);
                translationLogInternal.setStore((Storage)arrayList.get(0));
                Translator translator = new Translator(properties, this.asTranslationOptionsQuery(), (TranslationLog)translationLogInternal);
                TranslationUnitInternal[] translationUnitInternalArray = new TranslationUnitInternal[arrayList.size()];
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    TranslationLogInternal translationLogInternal2 = new TranslationLogInternal(log, (Storage)arrayList.get(n2));
                    translationUnitInternalArray[n2] = new TranslationUnitInternal(this, new TranslatorInputStream((Storage)arrayList.get(n2), properties, translationLogInternal2), new TranslatorWriter((Storage)arrayList2.get(n2), (String)properties.get("encoding"), translationLogInternal2), translationLogInternal2);
                    translator.addUnit((TranslationUnit)translationUnitInternalArray[n2]);
                    ++n2;
                }
                if (this.dependentJavaFiles != null) {
                    int n3 = 0;
                    while (n3 < this.dependentJavaFiles.length) {
                        if (this.dependentJavaFiles[n3] != null) {
                            translator.addUnit((TranslationUnit)new TranslationUnitInternal(this, new TranslatorInputStream(this.dependentJavaFiles[n3], properties, translationLogInternal), new TranslatorWriter(null, (String)properties.get("encoding"), translationLogInternal), translationLogInternal));
                        }
                        ++n3;
                    }
                }
                translator.translate();
                arrayList3 = new ArrayList<Boolean>();
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    arrayList3.add(translationUnitInternalArray[n4].succeeded());
                    ++n4;
                }
            }
            catch (TranslationCancelledException translationCancelledException) {
            }
            catch (Exception exception) {
                if (log.nerrors() - n > 0) break block8;
                String string = exception.toString();
                translationLogInternal.logError(Res.getString(1), -1, -1, -1, -1);
                if (string == null) break block8;
                translationLogInternal.logError(string, -1, -1, -1, -1);
            }
        }
        this.resolver = null;
        this.addDependentJavaFiles(null);
        return arrayList3;
    }

    void setProjectURL(URL uRL) {
        this.projectURL = uRL;
    }

    protected URL getProjectURL() {
        return this.projectURL;
    }

    private TranslationOptionsQuery asTranslationOptionsQuery() {
        return this;
    }

    private void checkCancel() {
        if (this.ide == null) {
            return;
        }
        boolean bl = false;
        try {
            if (!this.ide.authorizeParsing(null, null)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            throw new TranslationCancelledException(null);
        }
    }

    public static void main(String[] stringArray) {
        SqljInternal sqljInternal = new SqljInternal(null);
        SystemLog systemLog = new SystemLog();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                String string2 = string.substring(0, string.length() - 5) + "~generated.java";
                ArrayList<FileStorage> arrayList = new ArrayList<FileStorage>();
                arrayList.add(new FileStorage(new File(string)));
                ArrayList<FileStorage> arrayList2 = new ArrayList<FileStorage>();
                arrayList2.add(new FileStorage(new File(string2)));
                sqljInternal.translate(arrayList, arrayList2, (Log)systemLog, null);
            }
            ++n;
        }
    }

    public String getPassword(String string, String string2) {
        this.checkCancel();
        String string3 = null;
        if (this.ide != null) {
            try {
                System.out.println("need to get the password");
                if (string3 != null && string3.length() == 0) {
                    string3 = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string3;
    }

    public String getURL(String string) {
        return null;
    }

    static URL ra$projectURL(SqljInternal sqljInternal) {
        return sqljInternal.projectURL;
    }

    static TranslatorClassResolver ra$resolver(SqljInternal sqljInternal) {
        return sqljInternal.resolver;
    }

    private class TranslatorInputStream
    extends InputStream
    implements TranslationCharInput {
        private Storage store;
        private byte[] buf;
        private int offset;
        private String encoding;
        private TranslationLogInternal log;

        TranslatorInputStream(Storage storage, Properties properties, TranslationLogInternal translationLogInternal) {
            this.store = storage;
            this.log = translationLogInternal;
            this.encoding = (String)properties.get("encoding");
            try {
                storage.open();
                this.buf = storage.read();
            }
            catch (IOException iOException) {
                this.buf = null;
            }
            this.offset = 0;
        }

        public InputStream getInStream() {
            return this.asInputStream();
        }

        public String getName() {
            return this.store.getName();
        }

        public String getPath() {
            return this.store.getPath();
        }

        public Reader getReader() {
            try {
                String string = this.encoding != null ? new String(this.buf, this.encoding) : new String(this.buf);
                StringReader stringReader = new StringReader(string);
                return stringReader;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.log.logError("unsupported encoding: " + this.encoding, -1, -1, -1, -1);
                return null;
            }
        }

        public int read() throws IOException {
            this.verifyOpen();
            if (this.offset >= this.buf.length) {
                return -1;
            }
            return this.buf[this.offset++];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.verifyOpen();
            if (this.offset + n2 > this.buf.length) {
                n2 = this.buf.length - this.offset;
            }
            if (this.offset >= this.buf.length) {
                return -1;
            }
            if (byArray != null) {
                System.arraycopy(this.buf, this.offset, byArray, n, n2);
            }
            this.offset += n2;
            return n2;
        }

        public void close() throws IOException {
            this.verifyOpen();
            this.buf = null;
            this.offset = 0;
        }

        public long skip(long l) throws IOException {
            this.verifyOpen();
            if ((long)this.offset + l > (long)this.buf.length) {
                l = this.buf.length - this.offset;
            }
            this.offset = (int)((long)this.offset + l);
            return l;
        }

        public int available() throws IOException {
            this.verifyOpen();
            int n = this.buf.length - this.offset;
            return n;
        }

        private InputStream asInputStream() {
            return this;
        }

        private void verifyOpen() throws IOException {
            if (this.buf == null) {
                throw new IOException(Res.format(2, this.store.toString()));
            }
        }
    }

    private class TranslatorWriter
    implements TranslationOutput {
        private Storage store;
        private final FileOutputStream fos;
        private final OracleOutputStreamWriter osw;
        private String pkg;

        TranslatorWriter(Storage storage, String string, TranslationLogInternal translationLogInternal) throws FileNotFoundException, UnsupportedEncodingException {
            if (storage != null) {
                this.fos = new FileOutputStream(storage.getPath());
                this.osw = string != null ? new OracleOutputStreamWriter((OutputStream)this.fos, string) : new OracleOutputStreamWriter((OutputStream)this.fos);
            } else {
                this.fos = null;
                this.osw = null;
            }
            this.store = storage;
        }

        void done(TranslationLogInternal translationLogInternal) {
            try {
                if (this.osw != null) {
                    this.osw.flush();
                    this.osw.close();
                }
            }
            catch (IOException iOException) {
                translationLogInternal.logError("can't write " + this.store.getPath(), -1, -1, -1, -1);
            }
            this.pkg = null;
            this.store = null;
        }

        void abort() {
            this.pkg = null;
            this.store = null;
        }

        void setPackage(String string) {
            if (string != null) {
                this.pkg = string.replace('.', File.separatorChar);
            }
        }

        public Writer getWriter() {
            if (this.osw != null) {
                return this.osw;
            }
            return new 1();
        }

        public Writer createWriter(String string) throws IOException {
            return new FileWriter(this.getParentDir() + string);
        }

        public OutputStream createOutputStream(String string) throws IOException {
            String string2;
            File file;
            Node node;
            if (string.toLowerCase().endsWith(SqljInternal.serExt) && (node = NodeFactory.find((URL)SqljInternal.ra$projectURL(SqljInternal.this))) instanceof Project) {
                URL uRL = JavaProject.getInstance((Project)((Project)node)).getOutputDirectory();
                if (this.pkg != null) {
                    uRL = URLFactory.newDirURL((URL)uRL, (String)this.pkg);
                }
                if (URLFileSystem.exists((URL)uRL) || URLFileSystem.mkdirs((URL)uRL)) {
                    URL uRL2 = URLFactory.newURL((URL)uRL, (String)string);
                    return new FileOutputStream(uRL2.getPath());
                }
            }
            if (!(file = new File(string2 = this.getParentDir())).exists()) {
                file.mkdirs();
            }
            String string3 = string2 + string;
            return new FileOutputStream(string3);
        }

        private String getParentDir() {
            String string;
            if (this.store == null || (string = new File(this.store.getPath()).getParent()) == null) {
                return "";
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            return string;
        }

        final class 1
        extends Writer {
            public void write(char[] cArray, int n, int n2) throws IOException {
            }

            public void flush() throws IOException {
            }

            public void close() throws IOException {
            }
        }
    }

    private class TranslationLogInternal
    implements TranslationLog {
        private Log log;
        private Storage store;

        TranslationLogInternal(Log log) {
            this.log = log;
        }

        TranslationLogInternal(Log log, Storage storage) {
            this.log = log;
            this.store = storage;
        }

        void setStore(Storage storage) {
            this.store = storage;
        }

        public void logError(String string, int n, int n2, int n3, int n4) {
            this.log.printError(this.store, this.mapPos(n, n2), new ErrorInfo(0, string, ""));
        }

        public void logWarning(String string, int n, int n2, int n3, int n4) {
            this.log.printWarning(this.store, this.mapPos(n, n2), new ErrorInfo(0, string, ""));
        }

        public void logInfo(String string, int n, int n2, int n3, int n4) {
            this.log.println(string);
        }

        private int mapPos(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return 0;
            }
            return Scanner.lineColumnToPosition((int)n, (int)n2);
        }
    }

    private class TranslationUnitInternal
    implements TranslationUnit {
        private TranslatorInputStream ji;
        private TranslatorWriter jo;
        private TranslationLogInternal jl;
        private boolean success;

        TranslationUnitInternal(SqljInternal sqljInternal2, TranslatorInputStream translatorInputStream, TranslatorWriter translatorWriter, TranslationLogInternal translationLogInternal) {
            this.ji = translatorInputStream;
            this.jo = translatorWriter;
            this.jl = translationLogInternal;
            this.success = false;
        }

        boolean succeeded() {
            return this.success;
        }

        public TranslationInput getInput() {
            return this.ji;
        }

        public TranslationOutput getOutput() {
            return this.jo;
        }

        public TranslationLog getErrorLog() {
            return this.jl;
        }

        public ClassResolver getClassResolver() {
            return SqljInternal.ra$resolver(SqljInternal.this);
        }

        public void setPackageName(String string) {
            this.jo.setPackage(string);
        }

        public void translationComplete(boolean bl) throws IOException {
            boolean bl2 = this.success = bl;
            if (this.success) {
                this.jo.done(this.jl);
            } else {
                this.jo.abort();
            }
            this.ji = null;
            this.jo = null;
            this.jl = null;
        }
    }

    private class TranslatorClassResolver
    extends DefaultClassResolver {
        private JavaManager mgr;

        void setProjectURL(URL uRL) {
            Node node = NodeFactory.find((URL)uRL);
            this.mgr = node instanceof Project ? JavaManager.getJavaManager((Project)((Project)node)) : null;
        }

        protected Class loadClass(String string) throws ClassNotFoundException {
            if (this.mgr == null) {
                throw new ClassNotFoundException(string);
            }
            Class<?> clazz = this.mgr.getClassLoader().loadClass(string);
            return clazz;
        }

        private TranslatorClassResolver() {
        }

        TranslatorClassResolver(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TranslationCancelledException
    extends RuntimeException {
        private TranslationCancelledException() {
        }

        TranslationCancelledException(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

