/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.sqlj.config;

import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdevimpl.sqlj.compiler.Sqlj;
import oracle.jdevimpl.sqlj.config.Res;

public class SqljConfiguration
extends HashStructureAdapter {
    private static final String DEFAULT_CODEGEN = "oracle";
    private static final String[] DEFAULT_CODEGENS = new String[]{"oracle", "oraclejdbc", "jdbc", "iso", "ansi"};
    public static final String NO_CONTEXT;
    public static final String NO_CONNECTION;
    protected static final String WARN_ALL = "warnAll";
    protected static final String WARN_VERBOSE = "warnVerbose";
    protected static final String WARN_NULL = "warnNull";
    protected static final String WARN_PORTABLE = "warnPortable";
    protected static final String WARN_PRECISION = "warnPrecision";
    protected static final String WARN_STRICT = "warnStrict";
    protected static final String CHECK_SEMANTICS = "checkSemantics";
    protected static final String USE_CACHE = "useCache";
    protected static final String CODEGEN = "codegen";
    protected static final String ADDITIONAL_PARAMETERS = "additionalParameters";
    protected static final String CONTEXT_CONNECTION_MAP = "contextConnectionMap";
    protected static final String CONTEXT_NAME = "contextName";

    static {
        NO_CONNECTION = NO_CONTEXT = Res.getString(25);
    }

    private SqljConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static SqljConfiguration getInstance(PropertyStorage propertyStorage) {
        return new SqljConfiguration(SqljConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)Sqlj.SQLJ_CONFIG_DATA_KEY));
    }

    public boolean isWarnAll() {
        return this._hash.getBoolean(WARN_ALL, false);
    }

    public void setWarnAll(boolean bl) {
        this._hash.putBoolean(WARN_ALL, bl);
    }

    public boolean isWarnVerbose() {
        return this._hash.getBoolean(WARN_VERBOSE, false);
    }

    public void setWarnVerbose(boolean bl) {
        this._hash.putBoolean(WARN_VERBOSE, bl);
    }

    public boolean isWarnNull() {
        return this._hash.getBoolean(WARN_NULL, false);
    }

    public void setWarnNull(boolean bl) {
        this._hash.putBoolean(WARN_NULL, bl);
    }

    public boolean isWarnPortable() {
        return this._hash.getBoolean(WARN_PORTABLE, false);
    }

    public void setWarnPortable(boolean bl) {
        this._hash.putBoolean(WARN_PORTABLE, bl);
    }

    public boolean isWarnPrecision() {
        return this._hash.getBoolean(WARN_PRECISION, false);
    }

    public void setWarnPrecision(boolean bl) {
        this._hash.putBoolean(WARN_PRECISION, bl);
    }

    public boolean isWarnStrict() {
        return this._hash.getBoolean(WARN_STRICT, false);
    }

    public void setWarnStrict(boolean bl) {
        this._hash.putBoolean(WARN_STRICT, bl);
    }

    public boolean isCheckSemantics() {
        return this._hash.getBoolean(CHECK_SEMANTICS, false);
    }

    public void setCheckSemantics(boolean bl) {
        this._hash.putBoolean(CHECK_SEMANTICS, bl);
    }

    public boolean isUseCache() {
        return this._hash.getBoolean(USE_CACHE, false);
    }

    public void setUseCache(boolean bl) {
        this._hash.putBoolean(USE_CACHE, bl);
    }

    public String[] getCodegens() {
        return (String[])DEFAULT_CODEGENS.clone();
    }

    public String getCodegen() {
        return this._hash.getString(CODEGEN, DEFAULT_CODEGEN);
    }

    public void setCodegen(String string) {
        this._hash.putString(CODEGEN, string);
    }

    public String getAdditionalParameters() {
        return this._hash.getString(ADDITIONAL_PARAMETERS, "");
    }

    public void setAdditionalParameters(String string) {
        this._hash.putString(ADDITIONAL_PARAMETERS, string);
    }

    public HashStructure getContextConnectionMap() {
        return this._hash.getOrCreateHashStructure(CONTEXT_CONNECTION_MAP);
    }

    public String getContextName() {
        return this._hash.getString(CONTEXT_NAME, null);
    }

    public void setContextName(String string) {
        this._hash.putString(CONTEXT_NAME, string);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.put(CODEGEN, this.getCodegen());
        if (this.isWarnAll()) {
            properties.put("warn", "all");
        } else {
            StringBuffer stringBuffer = new StringBuffer("none");
            if (this.isWarnVerbose()) {
                stringBuffer.append(",verbose");
            }
            if (this.isWarnNull()) {
                stringBuffer.append(",nulls");
            }
            if (this.isWarnPrecision()) {
                stringBuffer.append(",precision");
            }
            if (this.isWarnPortable()) {
                stringBuffer.append(",portable");
            }
            if (this.isWarnStrict()) {
                stringBuffer.append(",strict");
            }
            properties.put("warn", stringBuffer.toString());
        }
        properties.put("cache", this.isUseCache() ? "1" : "0");
        HashStructure hashStructure = this.getContextConnectionMap();
        if (hashStructure.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            for (String string : hashStructure.keySet()) {
                ConnectionDescriptor connectionDescriptor;
                String string2 = hashStructure.getString(string);
                if (string2 == null || string2.length() <= 0) continue;
                try {
                    connectionDescriptor = connectionManager.getConnectionDescriptor(string2);
                }
                catch (IOException iOException) {
                    connectionDescriptor = null;
                }
                if (connectionDescriptor == null || !connectionDescriptor.getConnectionType().equals("JDBC")) continue;
                String string3 = connectionDescriptor.getJdbcDriver();
                if (string3 != null && string3.length() > 0) {
                    stringBuffer.append(string3).append(",");
                }
                String string4 = string != null && string.length() > 0 ? "@" + string : "";
                String string5 = connectionDescriptor.getUsername();
                if (string5 == null) continue;
                properties.put("user" + string4, string5);
                boolean bl = connectionDescriptor.isDeployPassword();
                String string6 = connectionDescriptor.getPassword();
                if (bl && string6 != null && string6.length() > 0) {
                    properties.put("password" + string4, string6);
                }
                String string7 = connectionDescriptor.getURL();
                properties.put("url" + string4, string7);
                String string8 = "oracle.sqlj.checker.OracleChecker";
                properties.put("online" + string4, "oracle.sqlj.checker.OracleChecker");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            properties.put("driver", stringBuffer.toString());
            this.addAdditionalParameters(properties);
        }
        return properties;
    }

    public void addAdditionalParameters(Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAdditionalParameters(), " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            String string2 = string = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
            if (string == null) continue;
            String string3 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            properties.put(string, string3);
        }
    }
}

