/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.sqlj.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.dt.ConnectionEditor;
import oracle.jdevimpl.sqlj.compiler.Sqlj;
import oracle.jdevimpl.sqlj.config.Res;
import oracle.jdevimpl.sqlj.config.SqljConfiguration;

public final class SqljConfigurationPanel
extends ProjectSettingsTraversablePanel
implements ItemListener {
    VerticalFlowLayout verticalFlowLayout1;
    Border warnBorder;
    Border onBorder;
    JPanel pnlWarn;
    JCheckBox cbCheckSql;
    JPanel pnlOnline;
    JCheckBox cbPortable;
    JCheckBox cbNull;
    JCheckBox cbPrecision;
    JCheckBox cbStrict;
    JLabel lblCodegen;
    JComboBox cbCodegen;
    JLabel lblAdditional;
    JTextField tfAdditional;
    JButton btnNewConn;
    JButton btnEditConn;
    JLabel lblCtxName;
    JLabel lblConnName;
    JComboBox cmbCtxName;
    JComboBox cmbConnName;
    JButton btnRmCtx;
    JButton btnAddCtx;
    GridBagLayout gridBagLayout1;
    GridLayout gridLayout1;
    GridLayout gridLayout2;
    HashStructure ctxConnMap;
    String activeConnection;
    private static final String[] PROPERTY_KEYS = new String[]{"warnStrict", "warnNull", "warnPrecision", "warnPortable", "warnAll", "codegen", "checkSemantics", "contextConnectionMap", "contextName", "additionalParameters"};

    void $init$() {
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.pnlWarn = new JPanel();
        this.cbCheckSql = new JCheckBox();
        this.pnlOnline = new JPanel();
        this.cbPortable = new JCheckBox();
        this.cbNull = new JCheckBox();
        this.cbPrecision = new JCheckBox();
        this.cbStrict = new JCheckBox();
        this.lblCodegen = new JLabel();
        this.cbCodegen = new JComboBox();
        this.lblAdditional = new JLabel();
        this.tfAdditional = new JTextField();
        this.btnNewConn = new JButton();
        this.btnEditConn = new JButton();
        this.lblCtxName = new JLabel();
        this.lblConnName = new JLabel();
        this.cmbCtxName = new JComboBox();
        this.cmbConnName = new JComboBox();
        this.btnRmCtx = new JButton();
        this.btnAddCtx = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridLayout1 = new GridLayout();
        this.gridLayout2 = new GridLayout();
    }

    public SqljConfigurationPanel() {
        this.$init$();
        try {
            this.preInit();
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDataKey() {
        return Sqlj.SQLJ_CONFIG_DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        if (traversableContext != null && SqljConfigurationPanel.isDefaultProject((Namespace)traversableContext)) {
            this.setHelpID("f1_sqljprojproppdpp_html");
        } else {
            this.setHelpID("f1_sqljprojpropp_html");
        }
        SqljConfiguration sqljConfiguration = SqljConfigurationPanel.getSqljConfiguration(traversableContext);
        this.loadFrom(sqljConfiguration);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this._isSemanticSettingBad()) {
            throw new TraversalException(Res.getString(23));
        }
        this.commitTo(SqljConfigurationPanel.getSqljConfiguration(traversableContext));
    }

    private static SqljConfiguration getSqljConfiguration(TraversableContext traversableContext) {
        PropertyStorage propertyStorage = SqljConfigurationPanel.getPropertyData((Namespace)traversableContext);
        return SqljConfiguration.getInstance(propertyStorage);
    }

    private void populateCodegens(SqljConfiguration sqljConfiguration) {
        this.cbCodegen.removeAllItems();
        String[] stringArray = sqljConfiguration.getCodegens();
        int n = 0;
        while (n < stringArray.length) {
            this.cbCodegen.addItem(stringArray[n]);
            ++n;
        }
        this.cbCodegen.setSelectedItem(sqljConfiguration.getCodegen());
    }

    private void loadFrom(SqljConfiguration sqljConfiguration) {
        this.populateCodegens(sqljConfiguration);
        this.tfAdditional.setText(sqljConfiguration.getAdditionalParameters());
        this.cbStrict.setSelected(sqljConfiguration.isWarnStrict());
        this.cbNull.setSelected(sqljConfiguration.isWarnNull());
        this.cbPrecision.setSelected(sqljConfiguration.isWarnPrecision());
        this.cbPortable.setSelected(sqljConfiguration.isWarnPortable());
        this.cbCheckSql.setSelected(sqljConfiguration.isCheckSemantics());
        this._setCheckSqlStates();
        if (sqljConfiguration.isWarnAll()) {
            this.cbStrict.setSelected(true);
            this.cbNull.setSelected(true);
            this.cbPrecision.setSelected(true);
            this.cbPortable.setSelected(true);
        }
        this.ctxConnMap = sqljConfiguration.getContextConnectionMap();
        this._updateCtxNames(sqljConfiguration.getContextName());
    }

    private void commitTo(SqljConfiguration sqljConfiguration) {
        String string = (String)this.cbCodegen.getSelectedItem();
        sqljConfiguration.setCodegen(string);
        sqljConfiguration.setAdditionalParameters(this.tfAdditional.getText());
        sqljConfiguration.setWarnAll(false);
        sqljConfiguration.setWarnStrict(this.cbStrict.isSelected());
        sqljConfiguration.setWarnNull(this.cbNull.isSelected());
        sqljConfiguration.setWarnPrecision(this.cbPrecision.isSelected());
        sqljConfiguration.setWarnPortable(this.cbPortable.isSelected());
        sqljConfiguration.setCheckSemantics(this.cbCheckSql.isSelected());
        String string2 = sqljConfiguration.getContextName();
        String string3 = (String)this.cmbCtxName.getSelectedItem();
        if (sqljConfiguration.getContextName() == null) {
            if (!SqljConfiguration.NO_CONTEXT.equals(string3)) {
                sqljConfiguration.setContextName(string3);
            }
        } else {
            sqljConfiguration.setContextName(string3);
        }
    }

    private void preInit() throws Exception {
        this.warnBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Res.getString(15)), BorderFactory.createEmptyBorder(0, 8, 8, 8));
        this.onBorder = BorderFactory.createEmptyBorder(5, 8, 0, 8);
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.cbCheckSql, (String)Res.getString(2));
        ResourceUtils.resButton((AbstractButton)this.cbPortable, (String)Res.getString(3));
        ResourceUtils.resButton((AbstractButton)this.cbNull, (String)Res.getString(4));
        ResourceUtils.resButton((AbstractButton)this.cbPrecision, (String)Res.getString(5));
        ResourceUtils.resButton((AbstractButton)this.cbStrict, (String)Res.getString(6));
        ResourceUtils.resButton((AbstractButton)this.btnNewConn, (String)Res.getString(9));
        ResourceUtils.resButton((AbstractButton)this.btnEditConn, (String)Res.getString(10));
        ResourceUtils.resLabel((JLabel)this.lblCtxName, (Component)this.cmbCtxName, (String)Res.getString(13));
        ResourceUtils.resLabel((JLabel)this.lblConnName, (Component)this.cmbConnName, (String)Res.getString(14));
        ResourceUtils.resButton((AbstractButton)this.btnRmCtx, (String)Res.getString(12));
        ResourceUtils.resButton((AbstractButton)this.btnAddCtx, (String)Res.getString(11));
        ResourceUtils.resLabel((JLabel)this.lblCodegen, (Component)this.cbCodegen, (String)Res.getString(7));
        ResourceUtils.resLabel((JLabel)this.lblAdditional, (Component)this.tfAdditional, (String)Res.getString(8));
        this.pnlWarn.setBorder(this.warnBorder);
        this.pnlWarn.setLayout(this.gridLayout1);
        this.pnlWarn.add((Component)this.cbStrict, null);
        this.pnlWarn.add((Component)this.cbNull, null);
        this.pnlWarn.add((Component)this.cbPrecision, null);
        this.pnlWarn.add((Component)this.cbPortable, null);
        this.pnlOnline.setBorder(this.onBorder);
        this.pnlOnline.setLayout(this.gridBagLayout1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        this.pnlOnline.add((Component)this.lblCtxName, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlOnline.add((Component)this.cmbCtxName, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.pnlOnline.add((Component)this.btnAddCtx, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        this.pnlOnline.add((Component)this.btnRmCtx, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        this.pnlOnline.add((Component)this.lblConnName, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 8, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.pnlOnline.add((Component)this.cmbConnName, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.pnlOnline.add((Component)this.btnNewConn, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        this.pnlOnline.add((Component)this.btnEditConn, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0);
        this.add(this.pnlWarn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add(this.lblCodegen, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.ipadx = 10;
        this.add(this.cbCodegen, gridBagConstraints);
        ++gridBagConstraints.gridy;
        --gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add(this.cbCheckSql, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add(this.pnlOnline, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add(this.lblAdditional, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.tfAdditional, gridBagConstraints);
        this.cbCheckSql.addItemListener(new 5());
        this.btnAddCtx.addActionListener(new 4());
        this.btnEditConn.addActionListener(new 3());
        this.btnNewConn.addActionListener(new 2());
        this.btnRmCtx.addActionListener(new 1());
        this.cmbConnName.addItemListener(this);
        this.cmbCtxName.addItemListener(this);
    }

    private void postInit() throws Exception {
        this._updateConnNames();
        this._setCheckSqlStates();
    }

    private void _updateCtxNames(String string) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(SqljConfiguration.NO_CONTEXT);
        for (String string2 : this.ctxConnMap.keySet()) {
            if (string2 == null || string2.equals(SqljConfiguration.NO_CONTEXT)) continue;
            defaultComboBoxModel.addElement(string2);
        }
        this.cmbCtxName.setModel(defaultComboBoxModel);
        if (string != null && this.ctxConnMap.getString(string) != null) {
            this.cmbCtxName.setSelectedItem(string);
        }
        this._ctxNameChanged();
        this._updateRmCtxBtn();
    }

    private void _updateConnNames() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(SqljConfiguration.NO_CONNECTION);
        try {
            try {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                String[] stringArray = connectionManager.getConnectionNames();
                int n = 0;
                while (n < stringArray.length) {
                    defaultComboBoxModel.addElement(stringArray[n]);
                    ++n;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            this.cmbConnName.setModel(defaultComboBoxModel);
            this._updateActiveConnName();
        }
    }

    private void _setCheckSqlStates() {
        boolean bl = this.cbCheckSql.isSelected();
        this.lblCtxName.setEnabled(bl);
        this.cmbCtxName.setEnabled(bl);
        this.btnAddCtx.setEnabled(bl);
        this.lblConnName.setEnabled(bl);
        this.cmbConnName.setEnabled(bl);
        this.btnNewConn.setEnabled(bl);
        this._updateEditConnBtn();
        this._updateRmCtxBtn();
    }

    private void _cbCheckSql_itemStateChanged(ItemEvent itemEvent) {
        this._setCheckSqlStates();
    }

    private void _btnAddCtx_actionPerformed(ActionEvent actionEvent) {
        String string = this.getNewCtxName();
        String string2 = Res.getString(19);
        if (string != null && string.length() > 0) {
            boolean bl = Character.isJavaIdentifierStart(string.charAt(0));
            if (bl) {
                char[] cArray = string.toCharArray();
                int n = string.length();
                int n2 = 1;
                while (n2 < n && bl) {
                    if (!Character.isJavaIdentifierPart(cArray[n2])) {
                        bl = false;
                    }
                    ++n2;
                }
            }
            if (bl && this.ctxConnMap.containsKey(string)) {
                bl = false;
                string2 = Res.getString(24);
            }
            if (bl) {
                if (string != null && string.length() > 0) {
                    this.cmbCtxName.addItem(string);
                    this.cmbCtxName.setSelectedItem(string);
                }
                this.putConnName(string, this.activeConnection);
            } else {
                int n = 0;
                String string3 = Res.getString(18);
                JOptionPane.showMessageDialog((Component)((Object)this), string2, string3, n);
            }
            this._updateRmCtxBtn();
        }
    }

    private void putConnName(Object object, Object object2) {
        if (object != null) {
            String string = object.toString();
            if (object2 == null) {
                this.ctxConnMap.remove(string);
            } else {
                this.ctxConnMap.putString(string, object2.toString());
            }
        }
    }

    private void _btnEditConn_actionPerformed(ActionEvent actionEvent) {
        int n = this.cmbConnName.getSelectedIndex();
        if (n > 0) {
            this.activeConnection = (String)this.cmbConnName.getSelectedItem();
            ConnectionEditor connectionEditor = new ConnectionEditor();
            connectionEditor.runConnectionEditor(this.activeConnection, 2, this._getConnectionTypes());
            this._updateConnNames();
            this.cmbConnName.setSelectedItem(this.activeConnection);
        } else {
            String string = Res.getString(20);
            JOptionPane.showMessageDialog((Component)((Object)this), string);
        }
    }

    private void _btnNewConn_actionPerformed(ActionEvent actionEvent) {
        ConnectionEditor connectionEditor = new ConnectionEditor();
        connectionEditor.runConnectionEditor("", 1, this._getConnectionTypes());
        this._updateConnNames();
    }

    private void _btnRmCtx_actionPerformed(ActionEvent actionEvent) {
        int n = this.cmbCtxName.getSelectedIndex();
        Object object = this.cmbCtxName.getSelectedItem();
        if (n > 0) {
            this.cmbCtxName.removeItemAt(n);
        }
        this.ctxConnMap.remove(object != null ? object.toString() : null);
        this._updateRmCtxBtn();
        this._updateActiveConnName();
    }

    private void _updateActiveConnName() {
        int n = ((DefaultComboBoxModel)this.cmbConnName.getModel()).getIndexOf(this.activeConnection);
        if (n > -1) {
            this.cmbConnName.setSelectedIndex(n);
        }
    }

    private void _updateRmCtxBtn() {
        int n = this.cmbCtxName.getSelectedIndex();
        boolean bl = this.cbCheckSql.isSelected() && n > 0;
        this.btnRmCtx.setEnabled(bl);
    }

    private void _updateEditConnBtn() {
        int n = this.cmbConnName.getSelectedIndex();
        boolean bl = this.cbCheckSql.isSelected() && n > 0;
        this.btnEditConn.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.cmbConnName) {
                this._connNameChanged();
            } else if (itemEvent.getSource() == this.cmbCtxName) {
                this._ctxNameChanged();
            }
        }
    }

    private void _ctxNameChanged() {
        Object object = this.cmbCtxName.getSelectedItem();
        if (object != null) {
            String string = this.ctxConnMap.getString(object.toString());
            if (string != null) {
                this.cmbConnName.setSelectedItem(string);
                this.activeConnection = string;
            }
            this._updateRmCtxBtn();
            this._updateEditConnBtn();
        }
    }

    private void _connNameChanged() {
        Object object = this.cmbCtxName.getSelectedItem();
        this.activeConnection = (String)this.cmbConnName.getSelectedItem();
        this.putConnName(object, this.activeConnection);
        this._updateEditConnBtn();
    }

    private String getNewCtxName() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JTextField jTextField = new JTextField();
        String string = Res.getString(21);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)(Res.getString(22) + "  "));
        jTextField.setText("");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jTextField, "Center");
        JEWTDialog jEWTDialog = new JEWTDialog(WindowUtils.parentFrame((Component)((Object)this)), string, 7);
        String string2 = "f1_sqljnewcontext_html";
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_sqljnewcontext_html");
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setInitialFocus((Component)jTextField);
        String string3 = null;
        if (jEWTDialog.runDialog()) {
            string3 = jTextField.getText();
        }
        return string3;
    }

    private boolean _isSemanticSettingBad() {
        return this.cbCheckSql.isSelected() && this.cmbConnName.getSelectedIndex() <= 0 && this.cmbCtxName.getModel().getSize() <= 1;
    }

    private String[] _getConnectionTypes() {
        try {
            String[] stringArray = ConnectionManager.getInstance().getConnectionTypeNamesForClass("CLASS_DATABASE");
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void mav$_cbCheckSql_itemStateChanged(SqljConfigurationPanel sqljConfigurationPanel, ItemEvent itemEvent) {
        sqljConfigurationPanel._cbCheckSql_itemStateChanged(itemEvent);
    }

    static void mav$_btnAddCtx_actionPerformed(SqljConfigurationPanel sqljConfigurationPanel, ActionEvent actionEvent) {
        sqljConfigurationPanel._btnAddCtx_actionPerformed(actionEvent);
    }

    static void mav$_btnEditConn_actionPerformed(SqljConfigurationPanel sqljConfigurationPanel, ActionEvent actionEvent) {
        sqljConfigurationPanel._btnEditConn_actionPerformed(actionEvent);
    }

    static void mav$_btnNewConn_actionPerformed(SqljConfigurationPanel sqljConfigurationPanel, ActionEvent actionEvent) {
        sqljConfigurationPanel._btnNewConn_actionPerformed(actionEvent);
    }

    static void mav$_btnRmCtx_actionPerformed(SqljConfigurationPanel sqljConfigurationPanel, ActionEvent actionEvent) {
        sqljConfigurationPanel._btnRmCtx_actionPerformed(actionEvent);
    }

    public final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            SqljConfigurationPanel.mav$_cbCheckSql_itemStateChanged(SqljConfigurationPanel.this, itemEvent);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SqljConfigurationPanel.mav$_btnAddCtx_actionPerformed(SqljConfigurationPanel.this, actionEvent);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SqljConfigurationPanel.mav$_btnEditConn_actionPerformed(SqljConfigurationPanel.this, actionEvent);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SqljConfigurationPanel.mav$_btnNewConn_actionPerformed(SqljConfigurationPanel.this, actionEvent);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SqljConfigurationPanel.mav$_btnRmCtx_actionPerformed(SqljConfigurationPanel.this, actionEvent);
        }
    }
}

