/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.dbuser;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.dbuser.CreateUserPanel;
import oracle.jdevimpl.wizard.dbuser.DBUserModel;
import oracle.jdevimpl.wizard.dbuser.DBUserWizard;

public final class DBUserWizardLauncher {
    private final Context _context;
    private final CreateUserPanel _panel;

    void $init$() {
        this._panel = new CreateUserPanel();
    }

    public DBUserWizardLauncher(Context context) {
        this.$init$();
        this._context = context;
    }

    private void _finish(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (!this._validateConfig()) {
            throw new PropertyVetoException("", propertyChangeEvent);
        }
        if (!this.createUser()) {
            throw new PropertyVetoException("", propertyChangeEvent);
        }
    }

    public boolean invoke() {
        String string = WizardsArb.getString((int)68);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._panel, (Component)this._panel.tfUserName, (String)string);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1());
        this._panel.populateTablespaceList(this.getConnection(this.getContextURL()));
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    private boolean _validateConfig() {
        DBUserModel dBUserModel = this._panel.getUserModel();
        String string = dBUserModel.userName;
        String string2 = dBUserModel.password1;
        String string3 = dBUserModel.password2;
        String string4 = dBUserModel.tableSpace;
        String string5 = dBUserModel.tempTableSpace;
        if (!ModelUtil.hasLength((String)string2) || !ModelUtil.hasLength((String)string3)) {
            this._showError(WizardsArb.getString((int)74));
            return false;
        }
        if (!string2.equalsIgnoreCase(string3)) {
            this._showError(WizardsArb.getString((int)75));
            return false;
        }
        if (!ModelUtil.hasLength((String)string)) {
            this._showError(WizardsArb.getString((int)76));
            return false;
        }
        if (!ModelUtil.hasLength((String)string4)) {
            this._showError(WizardsArb.getString((int)77));
            return false;
        }
        if (!ModelUtil.hasLength((String)string5)) {
            this._showError(WizardsArb.getString((int)77));
            return false;
        }
        return true;
    }

    public boolean createUser() {
        DBUserModel dBUserModel = this._panel.getUserModel();
        String string = dBUserModel.userName;
        String string2 = dBUserModel.password1;
        String string3 = dBUserModel.password2;
        String string4 = dBUserModel.tableSpace;
        String string5 = dBUserModel.tempTableSpace;
        boolean bl = false;
        if (this._validateConfig()) {
            Database database = DBUserWizard.getDatabase(this.getContextURL());
            String string6 = database.getInternalName(string);
            Schema schema = new Schema(string6);
            schema.setProperty("PASSWORD", (Object)string2);
            OracleSchemaProperties oracleSchemaProperties = new OracleSchemaProperties();
            oracleSchemaProperties.setDefaultTablespace(string4);
            oracleSchemaProperties.setTemporaryTablespace(string5);
            schema.setProperty("OracleSchemaProperties", (Object)oracleSchemaProperties);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("CONNECT");
            hashSet.add("RESOURCE");
            schema.setProperty("USER PRIVS", hashSet);
            try {
                database.createSchema(schema, false);
                bl = true;
            }
            catch (DBException dBException) {
                String string7 = WizardsArb.getString((int)81);
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(this._panel, string7, (SQLException)throwable);
                }
                ExceptionDialog.showExceptionDialog((Component)this._panel, (Throwable)throwable, (String)string7, (String)WizardsArb.getString((int)73), null);
            }
        }
        return bl;
    }

    private void _showError(String string) {
        MessageDialog.error((Component)this._panel, (Object)string, (String)WizardsArb.getString((int)81), null);
    }

    private Connection getConnection(URL uRL) {
        Database database = DBUserWizard.getDatabase(uRL);
        return database != null ? database.getConnection() : null;
    }

    private URL getContextURL() {
        try {
            URL uRL;
            if (this._context == null) {
                URL uRL2 = null;
                return uRL2;
            }
            Element element = this._context.getElement();
            if (element == null) {
                URL uRL3 = null;
                return uRL3;
            }
            URL uRL4 = uRL = ((Locatable)element).getURL();
            return uRL4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void mav$_finish(DBUserWizardLauncher dBUserWizardLauncher, PropertyChangeEvent propertyChangeEvent) {
        dBUserWizardLauncher._finish(propertyChangeEvent);
    }

    public final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                DBUserWizardLauncher.mav$_finish(DBUserWizardLauncher.this, propertyChangeEvent);
            }
        }
    }
}

