/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTreeUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateLineStyle(jComponent.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler();
        jComponent.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(jComponent);
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(graphics, n, n2, n3);
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(graphics, n, n2, n3);
        }
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, n - icon.getIconWidth() / 2 - 1, n2 - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object object) {
        this.linesEnabled = !"None".equals(object);
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath = null;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PlasticTreeUI.this.tree != null && PlasticTreeUI.this.tree.isEnabled()) {
                PlasticTreeUI.this.tree.requestFocus();
                TreePath treePath = PlasticTreeUI.this.getClosestPathForLocation(PlasticTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    int n;
                    Rectangle rectangle = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        PlasticTreeUI.super.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n = mouseEvent.getX()) > rectangle.x && n <= rectangle.x + rectangle.width && !PlasticTreeUI.super.startEditing(treePath, mouseEvent)) {
                        if (PlasticTreeUI.this.tree.isPathSelected(treePath)) {
                            this.lastSelectedPath = treePath;
                        } else {
                            this.lastSelectedPath = null;
                            PlasticTreeUI.super.selectPathForEvent(treePath, mouseEvent);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath;
            if (PlasticTreeUI.this.tree != null && PlasticTreeUI.this.tree.isEnabled() && (treePath = PlasticTreeUI.this.getClosestPathForLocation(PlasticTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY())) != null) {
                Rectangle rectangle = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, treePath);
                if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                    return;
                }
                int n = mouseEvent.getX();
                if (n > rectangle.x && n <= rectangle.x + rectangle.width && treePath.equals(this.lastSelectedPath)) {
                    PlasticTreeUI.super.selectPathForEvent(treePath, mouseEvent);
                }
            }
            this.lastSelectedPath = null;
        }
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals("JTree.lineStyle")) {
                PlasticTreeUI.this.updateLineStyle(object);
            }
        }
    }
}

