/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Dictionary;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTLookAndFeel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextComponent;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;

public class LWComponent
extends PaintContextComponent {
    private int _alignment = 0;
    private int _repaintFrozenLevel;
    private Rectangle _frozenDamage;
    private Rectangle _frozenSyncDamage;
    private PaintContext _borderContext;
    private Painter _fill;
    private static final String _KEY_INSTALLED = "oracle.bali.ewt.LWComponent.INSTALLED";
    private static boolean _IS_LINUX;

    public LWComponent() {
        LWComponent._tryInstallation();
    }

    public void setFill(Painter painter) {
        this._fill = painter;
        this.repaint();
    }

    public Painter getFill() {
        return this._fill;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int n) {
        this._alignment = n;
    }

    public int getActualAlignment() {
        int n = this.getAlignment();
        if (n == 0) {
            return LocaleUtils.getAlignmentForReadingDirection(this.getActualReadingDirection());
        }
        return n;
    }

    public int getActualReadingDirection() {
        return this.getPaintContext().getReadingDirection();
    }

    public void freezeRepaints() {
        ++this._repaintFrozenLevel;
    }

    public void unfreezeRepaints() {
        --this._repaintFrozenLevel;
        if (this._repaintFrozenLevel == 0) {
            Rectangle rectangle;
            Rectangle rectangle2;
            LWComponent lWComponent = this;
            synchronized (lWComponent) {
                rectangle2 = this._frozenDamage;
                this._frozenDamage = null;
                rectangle = this._frozenSyncDamage;
                this._frozenSyncDamage = null;
            }
            if (rectangle != null) {
                if (rectangle2 != null && rectangle.intersects(rectangle2)) {
                    rectangle.add(rectangle2);
                    this.computeVisibleRect(rectangle2);
                    LWComponent._intersectRect(rectangle, rectangle2, rectangle);
                    rectangle2 = null;
                }
                this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (rectangle2 != null) {
                this.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this.print(graphics);
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getSize();
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        return new Rectangle(n3, n4, n3, n4);
    }

    public final void repaintInterior() {
        ImmInsets immInsets = this.getBorderInsets();
        this.repaint(immInsets.left, immInsets.top, this.getWidth() - (immInsets.left + immInsets.right), this.getHeight() - (immInsets.top + immInsets.bottom));
    }

    public final void repaintInterior(int n, int n2, int n3, int n4) {
        ImmInsets immInsets = this.getBorderInsets();
        this.repaint(n + immInsets.left, n2 + immInsets.top, n3, n4);
    }

    public final void paintImmediateInterior() {
        ImmInsets immInsets = this.getBorderInsets();
        this.paintImmediately(immInsets.left, immInsets.top, this.getWidth() - (immInsets.left + immInsets.right), this.getHeight() - (immInsets.top + immInsets.bottom));
    }

    public final void paintImmediateInterior(int n, int n2, int n3, int n4) {
        ImmInsets immInsets = this.getBorderInsets();
        this.paintImmediately(n + immInsets.left, n2 + immInsets.top, n3, n4);
    }

    public final ImmInsets getBorderInsets() {
        return UIUtils.getInsets(this);
    }

    public PaintContext getPrintPaintContext(Graphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException();
        }
        return new PrintContext(graphics);
    }

    public final void clipToParents(Rectangle rectangle) {
        this.computeVisibleRect(rectangle);
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (!this._addFrozenDamage(n, n2, n3, n4, true)) {
            super.paintImmediately(n, n2, n3, n4);
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this._addFrozenDamage(n, n2, n3, n4, false)) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void updateUI() {
        this.setUI(null);
    }

    public void addNotify() {
        if (_IS_LINUX) {
            LWComponent._tryInstallation();
        }
        super.addNotify();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            super.paintComponent(graphics);
        } else if (this.isOpaque()) {
            UIUtils.fillBackground(graphics, this);
        }
        Painter painter = this.getFill();
        if (painter != null) {
            painter.paint(this.getPaintContext(), graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.paintOverChildren(graphics);
    }

    protected void paintOverChildren(Graphics graphics) {
    }

    protected final void processEvent(AWTEvent aWTEvent) {
        this.processEventImpl(aWTEvent);
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    private boolean _addFrozenDamage(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (this._repaintFrozenLevel == 0) {
            Container container = this.getParent();
            if (container instanceof LWComponent) {
                LWComponent lWComponent = (LWComponent)container;
                bl2 = lWComponent._addFrozenDamage(n + this.getX(), n2 + this.getY(), n3, n4, bl);
            } else {
                bl2 = false;
            }
        } else {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            LWComponent lWComponent = this;
            synchronized (lWComponent) {
                boolean bl3 = bl2 = this._repaintFrozenLevel != 0;
                if (bl2) {
                    Rectangle rectangle2;
                    Rectangle rectangle3 = rectangle2 = bl ? this._frozenSyncDamage : this._frozenDamage;
                    if (rectangle2 == null) {
                        rectangle2 = rectangle;
                    } else {
                        rectangle2.add(rectangle);
                    }
                    if (bl) {
                        this._frozenSyncDamage = rectangle2;
                    } else {
                        this._frozenDamage = rectangle2;
                    }
                }
            }
        }
        return bl2;
    }

    private static void _tryInstallation() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        if (Boolean.TRUE.equals(uIDefaults.get(_KEY_INSTALLED))) {
            return;
        }
        try {
            EWTLookAndFeel.installEWTLookAndFeel();
            uIDefaults.put(_KEY_INSTALLED, Boolean.TRUE);
        }
        catch (Exception exception) {
            System.err.println("Could not install EWT look-and-feel:");
            exception.printStackTrace();
        }
    }

    private static void _intersectRect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = rectangle2.x;
        int n2 = n + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = n3 + rectangle2.height;
        int n5 = rectangle3.x;
        int n6 = n5 + rectangle3.width;
        int n7 = rectangle3.y;
        int n8 = n7 + rectangle3.height;
        rectangle.x = n >= n5 ? n : n5;
        rectangle.y = n3 >= n7 ? n3 : n7;
        rectangle.width = (n2 <= n6 ? n2 : n6) - rectangle.x;
        rectangle.height = (n4 <= n8 ? n4 : n8) - rectangle.y;
    }

    static {
        String string = System.getProperty("os.name");
        _IS_LINUX = string != null && string.indexOf("Linux") != -1;
    }

    private class PrintContext
    extends PaintContextProxy {
        private Graphics _printGraphics;

        public PrintContext(Graphics graphics) {
            this._printGraphics = graphics;
        }

        protected PaintContext getPaintContext() {
            return LWComponent.this.getPaintContext();
        }

        public int getPaintState() {
            return 0;
        }

        public FontMetrics getFontMetrics(Font font) {
            return this._printGraphics.getFontMetrics(font);
        }
    }
}

