/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.busyBar;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.thread.Periodic;
import oracle.bali.share.util.IntegerUtils;

public class BusyBar
extends LWComponent
implements Accessible {
    private static final String _EMPTY_TEXT = "";
    private Periodic _timer;
    private int _timerSpeed = 50;
    private String _text = "";
    private int _state;
    private boolean _isRunning;

    public BusyBar() {
        this.updateUI();
    }

    public String getUIClassID() {
        return "EWTBusyBarUI";
    }

    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    public final void start() {
        this.setRunning(true);
    }

    public final synchronized void stop() {
        this.setRunning(false);
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public final synchronized void setRunning(boolean bl) {
        if (bl != this.isRunning()) {
            this._isRunning = bl;
            this._fireAccessibleBusy(bl);
            if (bl) {
                this.startImpl();
            } else {
                this.stopImpl();
            }
            this.repaint();
        }
    }

    protected void startImpl() {
        if (this.isRunning()) {
            if (this._timer == null) {
                this._timer = new Periodic((Runnable)new _RunnableImpl());
                this._timer.setName("BusyBar");
                this._timer.setDaemon(true);
            }
            this._timer.schedule((long)this._timerSpeed);
        }
    }

    protected void stopImpl() {
        if (this._timer != null) {
            this._timer.kill();
            this._timer = null;
        }
    }

    public void setText(String string) {
        if (string == null) {
            string = _EMPTY_TEXT;
        }
        if (!string.equals(this._text)) {
            this._text = string;
            this.repaint();
        }
    }

    public String getText() {
        return this._text;
    }

    public synchronized void setSpeed(int n) {
        this._timerSpeed = n;
        if (this._timer != null) {
            this._timer.schedule((long)n);
        }
    }

    public int getSpeed() {
        return this._timerSpeed;
    }

    public void removeNotify() {
        super.removeNotify();
        this.stopImpl();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._timer == null) {
            this.startImpl();
        }
    }

    protected Object getPaintData(Object object) {
        if (EWTBusyBarUI.IS_RUNNING_KEY.equals(object)) {
            return this.isRunning() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (EWTBusyBarUI.STATE_KEY.equals(object)) {
            return IntegerUtils.getInteger((int)this._state);
        }
        if (PaintContext.LABEL_KEY.equals(object)) {
            return this.getText();
        }
        return super.getPaintData(object);
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.isRunning()) {
            string = string + ",running";
        }
        return string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBusyBar();
        }
        return this.accessibleContext;
    }

    private void _fireAccessibleBusy(boolean bl) {
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.BUSY, bl ? AccessibleState.BUSY : null);
        }
    }

    private class _RunnableImpl
    implements Runnable {
        private _RunnableImpl() {
        }

        public void run() {
            if (BusyBar.this.isShowing()) {
                BusyBar.this._state++;
                BusyBar.this.repaint();
            } else {
                BusyBar.this.stopImpl();
            }
        }
    }

    protected class AccessibleBusyBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleBusyBar() {
            super(BusyBar.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (BusyBar.this.isRunning()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }
    }
}

