/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.FontUtils;

class DialogBarLayout
implements LayoutManager2 {
    private static final int _BUTTON_GAP = 1;
    private static final int _LEFT_RIGHT_GAP = 30;
    private static final int _GROUP_GAP = 8;
    private static final int _COMP_INDEX_HELP = 0;
    private static final int _COMP_INDEX_YES = 1;
    private static final int _COMP_INDEX_NO = 2;
    private static final int _COMP_INDEX_CANCEL = 3;
    private static final int _COMP_INDEX_BACK = 4;
    private static final int _COMP_INDEX_NEXT = 5;
    private static final int _COMP_INDEX_FINISH = 6;
    private static final int _COMP_INDEX_APPLY = 7;
    private static final int _COMP_INDEX_NULL = 8;
    private static final int _NUM_COMPS = 9;
    private static final int[] _NORMAL_SPECIAL_START = new int[]{0};
    private static final int[] _NORMAL_SPECIAL_END = new int[]{3, 2, 1, 7, 6, 5, 4};
    private static final int[] _WIZARD_SPECIAL_START = new int[]{0, 7};
    private static final int[] _WIZARD_SPECIAL_END = new int[]{2, 1, 3, 6, 5, 4};
    private Hashtable _compToConstraintMap = new Hashtable(13);
    private Component[] _specialComponents = new Component[9];
    private Container _container;
    private transient Dimension _cellSize = null;
    private static final String _RESERVED_WIZARD_BUTTONS = "WizardReservedButtonSpaces";

    public DialogBarLayout(Container container) {
        this._container = container;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void removeLayoutComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        int n = (Integer)this._compToConstraintMap.remove(component);
        if (this._specialComponents[n] == component) {
            this._specialComponents[n] = null;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        Component component2;
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            object = DialogButtonBar.CONSTRAINT_NULL;
        }
        Integer n = (Integer)object;
        this._compToConstraintMap.put(component, n);
        int n2 = n;
        if (n2 != 8 && (component2 = this._specialComponents[n2]) != null) {
            this._compToConstraintMap.put(component, DialogButtonBar.CONSTRAINT_NULL);
        }
        this._specialComponents[n2] = component;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this._calculateSize(container);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        Insets insets2 = UIManager.getInsets("EWTDialogButtonBar.margin");
        if (insets2 != null) {
            dimension.width += insets2.left + insets2.right;
            dimension.height += insets2.top + insets2.bottom;
        }
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Insets insets2 = UIManager.getInsets("EWTDialogButtonBar.margin");
        if (insets2 != null) {
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        int n3 = insets.left;
        int n4 = dimension.width - insets.right;
        int n5 = insets.top;
        int n6 = dimension.height - n5 - insets.bottom;
        Dimension dimension2 = this._getCellSize(container);
        int n7 = dimension2.width;
        int n8 = dimension2.height;
        int n9 = n6 - n8;
        if (n9 < 0) {
            n8 = n6;
            n9 = 0;
        }
        n3 = this._layoutSpecialComponents(this._getSpecialLeft(), true, n3, n4, n5, n9, n7, n8);
        n4 = this._layoutSpecialComponents(this._getSpecialRight(), false, n3, n4, n5, n9, n7, n8);
        int n10 = this._getNumVisibleSpecial();
        int n11 = this._getNumVisible(container);
        int n12 = n11 - n10;
        int n13 = n12 * n7;
        if (n12 > 0) {
            n13 += (n12 - 1) * 8;
        }
        if ((n2 = (n = n4 - n3) - n13) > 0) {
            n3 += n2;
            n -= n2;
        }
        int n14 = container.getComponentCount();
        int n15 = 0;
        while (n15 < n14) {
            Component component = container.getComponent(n15);
            if (component.isVisible() && !this._isSpecial(component)) {
                if (n7 > n) {
                    n7 = n;
                }
                int n16 = 0;
                if (n9 > 0) {
                    n16 = (int)((float)n9 * component.getAlignmentY());
                }
                component.setBounds(n3, n5 + n16, n7, n8);
                int n17 = n7 + 8;
                n3 += n17;
                n -= n17;
            }
            ++n15;
        }
    }

    private int _layoutSpecialComponents(int[] nArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (n7 < nArray.length) {
            int n8 = n2 - n;
            int n9 = nArray[n7];
            Component component = this._specialComponents[n9];
            if (component != null && component.isVisible()) {
                Component component2;
                int n10;
                if (n5 > n8) {
                    n5 = n8;
                }
                int n11 = 0;
                if (n4 > 0) {
                    n11 = (int)((float)n4 * component.getAlignmentY());
                }
                int n12 = n;
                if (!bl) {
                    n12 = n2 - n5;
                }
                component.setBounds(n12, n3 + n11, n5, n6);
                int n13 = 8;
                if (n9 == 5 && n7 + 1 < nArray.length && (n10 = nArray[n7 + 1]) == 4 && (component2 = this._specialComponents[n10]) != null && component2.isVisible()) {
                    n13 = 1;
                }
                n10 = n5 + n13;
                if (bl) {
                    n += n10;
                } else {
                    n2 -= n10;
                }
            }
            ++n7;
        }
        if (bl) {
            return n;
        }
        return n2;
    }

    public void invalidateLayout(Container container) {
        this._cellSize = null;
    }

    private Dimension _getCellSize(Container container) {
        if (this._cellSize == null) {
            this._cellSize = this._calculateCellSize(container);
        }
        return this._cellSize;
    }

    private Dimension _calculateSize(Container container) {
        int n = this._getNumVisible(container);
        Dimension dimension = this._getCellSize(container);
        int n2 = dimension.width * n;
        if (n > 0) {
            if (this._isBackAndNextVisible()) {
                n2 += (n - 2) * 8;
                ++n2;
            } else {
                n2 += (n - 1) * 8;
            }
            if (this._isBothButtonGroupVisible()) {
                n2 += Math.min(30, dimension.width);
            }
        }
        int n3 = dimension.height;
        return new Dimension(n2, n3);
    }

    private boolean _isBothButtonGroupVisible() {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = this._getSpecialStart();
        int[] nArray2 = this._getSpecialEnd();
        Component component = null;
        int n = 0;
        while (n < nArray.length) {
            component = this._specialComponents[nArray[n]];
            if (component != null && component.isVisible()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return bl;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            component = this._specialComponents[nArray2[n2]];
            if (component != null && component.isVisible()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        return bl2;
    }

    private Dimension _calculateCellSize(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        Font font = null;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (font == null) {
                    font = component.getFont();
                }
                if (dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
            }
            ++n4;
        }
        if (font != null) {
            n3 += 3 * FontUtils.getAverageWidth(font);
        }
        return new Dimension(n3, n2);
    }

    private int _getNumVisible(Container container) {
        Object object;
        int n = 0;
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (container.getComponent(n3).isVisible()) {
                ++n;
            }
            ++n3;
        }
        if (this._isWizardConfiguration() && container instanceof JComponent && (object = ((JComponent)container).getClientProperty(_RESERVED_WIZARD_BUTTONS)) instanceof Integer) {
            n += ((Integer)object).intValue();
        }
        return n;
    }

    private boolean _isBackAndNextVisible() {
        Component component = this._specialComponents[4];
        Component component2 = this._specialComponents[5];
        return component != null && component2 != null && component.isVisible() && component2.isVisible();
    }

    private boolean _isSpecial(Component component) {
        return (Integer)this._compToConstraintMap.get(component) != 8;
    }

    private int _getNumVisibleSpecial() {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            Component component = this._specialComponents[n2];
            if (component != null && component.isVisible()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int[] _getSpecialLeft() {
        if (this._isLeftToRight()) {
            return this._getSpecialStart();
        }
        return this._getSpecialEnd();
    }

    private int[] _getSpecialRight() {
        if (this._isLeftToRight()) {
            return this._getSpecialEnd();
        }
        return this._getSpecialStart();
    }

    private int[] _getSpecialStart() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_START;
        }
        return _NORMAL_SPECIAL_START;
    }

    private int[] _getSpecialEnd() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_END;
        }
        return _NORMAL_SPECIAL_END;
    }

    private boolean _isWizardConfiguration() {
        return this._specialComponents[4] != null || this._specialComponents[5] != null || this._specialComponents[6] != null;
    }

    private boolean _isLeftToRight() {
        return true;
    }
}

