/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.ColorChooserPane;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class ColorPalettePane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR_PALETTE = "colorPalette";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_COLOR_NAME = "COLORPALETTE.COLOR_NAME";
    private static final String _KEY_TITLE = "COLORPALETTE.COLOR_PALETTE_TITLE";
    private static final String _KEY_LABEL = "COLORPALETTE.AVAILABLE_COLORS";
    private static final String _KEY_CUSTOM_LABEL = "COLORPALETTE.CUSTOM_COLORS";
    private static final String _KEY_EDIT = "COLORPALETTE.EDIT_COLOR";
    private static final String _EDIT_NAME = "Edit_Custom_Color_Button";
    private static final String _GRID_NAME = "Available_Colors_Grid";
    private static final String _CUSTOM_GRID_NAME = "Custom_Colors_Grid";
    private Listener _listener = new Listener();
    private ColorGrid _grid = new ColorGrid(false);
    private JLabel _label;
    private JButton _editButton;
    private JLabel _colorName;
    private JLabel _colorNameLabel;
    private JPanel _colorNameComponent;
    private JPanel _customButtonPanel;
    private TwoDModel _names;
    private TwoDModel _customNames;
    private ColorGrid _customGrid;
    private JLabel _customLabel;
    private ColorChooserPane _colorChooserPane;
    private boolean _ignoreEvents;
    private boolean _chooserVisible;

    public static int showDialog(Component component, ColorPalettePane colorPalettePane) {
        return ColorPalettePane.showDialog(component, colorPalettePane, null, false);
    }

    public static int showDialog(Component component, ColorPalettePane colorPalettePane, String string, boolean bl) {
        Object object;
        if (colorPalettePane == null) {
            throw new IllegalArgumentException("ColorPalettePane must be non-null");
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)colorPalettePane);
        if (string == null) {
            object = ResourceBundle.getBundle(_RESOURCE, locale);
            string = ((ResourceBundle)object).getString(_KEY_TITLE);
        }
        object = JEWTDialog.createDialog(component, string, 7);
        ((Component)object).setLocale(locale);
        ((JEWTDialog)object).setContent(colorPalettePane);
        ((JEWTDialog)object).setCenterOver(component);
        ((Dialog)object).setResizable(bl);
        ((JEWTDialog)object).setInitialFocus(colorPalettePane._getInitialFocus());
        int n = ((JEWTDialog)object).runDialog() ? 1 : 2;
        ((JEWTDialog)object).dispose();
        return n;
    }

    public ColorPalettePane() {
        this(null);
    }

    public ColorPalettePane(TwoDModel twoDModel) {
        this(twoDModel, null, false);
    }

    public ColorPalettePane(TwoDModel twoDModel, Color color, boolean bl) {
        this(twoDModel, color, bl, null);
    }

    public ColorPalettePane(TwoDModel twoDModel, Color color, boolean bl, TwoDModel twoDModel2) {
        this._grid.__setSelectedSlotEnabled(true);
        this._grid.addPropertyChangeListener(this._listener);
        this._grid.setName(_GRID_NAME);
        this._label = new JLabel("");
        this._label.setLabelFor(this._grid);
        this._editButton = new JButton("");
        this._editButton.setActionCommand(_KEY_EDIT);
        this._editButton.addActionListener(this._listener);
        this._editButton.setName(_EDIT_NAME);
        this._customGrid = new ColorGrid(true);
        this._customGrid.__setSelectedSlotEnabled(true);
        this._customGrid.addPropertyChangeListener(this._listener);
        this._customGrid.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ColorPalettePane.this.isEnabled() && !mouseEvent.isConsumed() && mouseEvent.getClickCount() == 2) {
                    ColorPalettePane.this._editColor();
                }
            }
        });
        this._customGrid.setName(_CUSTOM_GRID_NAME);
        this._customLabel = new JLabel("");
        this._customLabel.setLabelFor(this._customGrid);
        this._customButtonPanel = new JPanel(new EqualColumnLayout(5));
        this._colorName = new JLabel("");
        this._colorNameLabel = new JLabel("");
        this._colorNameComponent = new JPanel();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 3));
        jPanel.add("North", this._customLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 3));
        jPanel2.add("North", this._customGrid);
        jPanel2.add("Center", this._editButton);
        jPanel.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this._grid, "West");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 5));
        jPanel4.add("North", jPanel3);
        jPanel4.add("South", jPanel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add("West", jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(5, 5));
        jPanel6.add("North", this._customButtonPanel);
        jPanel5.add("Center", jPanel6);
        this.add("North", this._label);
        this.add("Center", jPanel5);
        this.add("South", this._colorNameComponent);
        this.setColorNameVisible(false);
        this.setColorPalette(twoDModel);
        this.setCustomColorsVisible(twoDModel2 != null);
        this.setCustomColorPalette(twoDModel2);
        this.setSelectedColor(color);
        this.setEditVisible(bl);
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this._grid.setColorPalette(twoDModel);
    }

    public TwoDModel getColorPalette() {
        return this._grid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel twoDModel) {
        TwoDModel twoDModel2 = this._customGrid.getColorPalette();
        if (twoDModel == null) {
            twoDModel = NullTwoDModel.getTwoDModel();
        }
        this._customGrid.setColorPalette(twoDModel);
        this.firePropertyChange(PROPERTY_COLOR_PALETTE, twoDModel2, twoDModel);
    }

    public TwoDModel getCustomColorPalette() {
        TwoDModel twoDModel = this._customGrid.getColorPalette();
        if (twoDModel == NullTwoDModel.getTwoDModel()) {
            twoDModel = null;
        }
        return twoDModel;
    }

    public void setEditVisible(boolean bl) {
        this._editButton.setVisible(bl);
        this._revalidate();
    }

    public boolean isEditVisible() {
        return this._editButton.isVisible();
    }

    public void setSelectedColor(Color color) {
        this.setSelectedColor(color, false);
    }

    public Color getSelectedColor() {
        if (this.isCustomColorSelected()) {
            return this._customGrid.getSelectedColor();
        }
        return this._grid.getSelectedColor();
    }

    public boolean isCustomColorSelected() {
        return this._customGrid.isVisible() && this._customGrid.__getSelectedColumn() != -1 && this._customGrid.__getSelectedRow() != -1;
    }

    public void setSelectedColor(Color color, boolean bl) {
        if (bl) {
            this._grid.setSelectedColor(null);
            this._customGrid.setSelectedColor(color);
        } else {
            this._customGrid.setSelectedColor(null);
            this._grid.setSelectedColor(color);
        }
        this._updateEditButton();
    }

    public void setColorNames(TwoDModel twoDModel) {
        if (this._names != twoDModel) {
            if (this._names != null) {
                this._names.removeModelListener(this._listener);
            }
            this._names = twoDModel;
            this._grid.__setColorNames(this._names);
            if (this._names != null) {
                this._names.addModelListener(this._listener);
            }
        }
    }

    public TwoDModel getColorNames() {
        return this._names;
    }

    public void setCustomColorNames(TwoDModel twoDModel) {
        if (this._customNames != twoDModel) {
            if (this._customNames != null) {
                this._customNames.removeModelListener(this._listener);
            }
            this._customNames = twoDModel;
            this._customGrid.__setColorNames(this._names);
            if (this._customNames != null) {
                this._customNames.addModelListener(this._listener);
            }
        }
    }

    public TwoDModel getCustomColorNames() {
        return this._customNames;
    }

    public void setColorName(String string) {
        Color color = this.getSelectedColor();
        if (color != null) {
            this._colorName.setText(string);
            boolean bl = this.isCustomColorSelected();
            TwoDModel twoDModel = bl ? this.getCustomColorNames() : this.getColorNames();
            ColorGrid colorGrid = bl ? this._customGrid : this._grid;
            int n = colorGrid.__getSelectedColumn();
            int n2 = colorGrid.__getSelectedRow();
            if (n != -1 && n2 != -1 && twoDModel != null && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount()) {
                twoDModel.setData(n, n2, string);
            }
        }
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setCustomColorsVisible(boolean bl) {
        this._customLabel.setVisible(bl);
        this._customGrid.setVisible(bl);
        if (!bl) {
            this._customGrid.__setSelectedSlot(-1, -1, false);
        }
        this._revalidate();
    }

    public boolean isCustomColorsVisible() {
        return this._customGrid.isVisible();
    }

    public void setColorNameVisible(boolean bl) {
        this._colorNameComponent.setVisible(bl);
        this._revalidate();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void addCustomComponent(Component component) {
        this._customButtonPanel.add(component);
        this._revalidate();
    }

    public void removeCustomComponent(Component component) {
        this._customButtonPanel.remove(component);
        this._revalidate();
    }

    public int getCustomComponentCount() {
        return this._customButtonPanel.getComponentCount();
    }

    public Component getCustomComponent(int n) {
        return this._customButtonPanel.getComponent(n);
    }

    public ColorChooserPane getColorChooserPane() {
        if (this._colorChooserPane == null) {
            this._colorChooserPane = new ColorChooserPane();
            this._colorChooserPane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        }
        return this._colorChooserPane;
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        if (this._names != null) {
            this._names.removeModelListener(this._listener);
        }
        if (this._customNames != null) {
            this._customNames.removeModelListener(this._listener);
        }
        this._listener = null;
        this._names = null;
        this._customNames = null;
        this._grid.dispose();
        this._grid = null;
        this._customGrid.dispose();
        this._customGrid = null;
        this._label = null;
        this._colorName = null;
        this._colorNameLabel = null;
        this._customLabel = null;
        this._colorNameComponent = null;
        this._customButtonPanel = null;
        this._editButton = null;
        if (this._colorChooserPane != null) {
            this._colorChooserPane.dispose();
        }
        this._colorChooserPane = null;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._grid.setEnabled(bl);
        this._customGrid.setEnabled(bl);
        this._updateEditButton();
        this._label.setEnabled(bl);
        this._customLabel.setEnabled(bl);
        this._colorNameLabel.setEnabled(bl);
        this._colorName.setEnabled(bl);
    }

    public void addNotify() {
        super.addNotify();
        Font font = this._colorNameLabel.getFont();
        if (font != null && !font.isBold()) {
            int n = font.getStyle() | 1;
            font = new Font(font.getName(), n, font.getSize());
            this._colorNameLabel.setFont(font);
        }
        this._setText(this.getLocale());
    }

    public void updateUI() {
        super.updateUI();
        if (this._colorChooserPane != null) {
            SwingUtilities.updateComponentTreeUI(this._colorChooserPane);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColorPalettePane();
        }
        return this.accessibleContext;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._label != null) {
            this._setText(locale);
        }
    }

    private void _setText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        String string = resourceBundle.getString(_KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic((String)string));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_EDIT);
        this._editButton.setText(StringUtils.stripMnemonic((String)string));
        this._editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_CUSTOM_LABEL);
        this._customLabel.setText(StringUtils.stripMnemonic((String)string));
        this._customLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic((String)string));
        this._grid.setLocale(locale);
        this._customGrid.setLocale(locale);
    }

    private void _updateEditButton() {
        boolean bl = this.isCustomColorSelected() && this.isEnabled();
        this._editButton.setEnabled(bl);
    }

    private void _updateColorName() {
        String string = null;
        boolean bl = this.isCustomColorSelected();
        TwoDModel twoDModel = bl ? this.getCustomColorNames() : this.getColorNames();
        ColorGrid colorGrid = bl ? this._customGrid : this._grid;
        int n = colorGrid.__getSelectedColumn();
        int n2 = colorGrid.__getSelectedRow();
        if (n != -1 && n2 != -1 && twoDModel != null && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount()) {
            Object object = twoDModel.getData(n, n2);
            string = object instanceof String ? object.toString() : null;
        }
        this._colorName.setText(string);
    }

    private void _editColor() {
        if (this._chooserVisible) {
            return;
        }
        this._chooserVisible = true;
        ColorChooserPane colorChooserPane = this.getColorChooserPane();
        colorChooserPane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        String string = this.getColorName();
        Color color = this.getSelectedColor();
        if (color == null) {
            color = Color.gray;
        }
        colorChooserPane.setOriginalColor(color);
        colorChooserPane.setColor(color);
        colorChooserPane.setColorNameVisible(this.isColorNameVisible());
        colorChooserPane.setColorName(string);
        if (ColorChooserPane.showDialog(this, colorChooserPane) == 1) {
            String string2;
            Color color2 = this._customGrid.getSelectedColor();
            Color color3 = colorChooserPane.getColor();
            this._customGrid.__replaceSelectedSlotColor(color3);
            this.firePropertyChange(PROPERTY_COLOR_PALETTE, null, this.getColorPalette());
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, color3);
            if (this.isColorNameVisible() && string != (string2 = colorChooserPane.getColorName())) {
                this.setColorName(string2);
            }
        }
        this._chooserVisible = false;
    }

    private void _selectedColorChanged(ColorGrid colorGrid, Color color, Color color2) {
        boolean bl;
        if (this._ignoreEvents) {
            return;
        }
        boolean bl2 = bl = colorGrid.__getSelectedColumn() != -1 && colorGrid.__getSelectedRow() != -1;
        if (bl) {
            this._ignoreEvents = true;
            if (colorGrid == this._grid) {
                this._customGrid.setSelectedColor(null);
            } else {
                this._grid.setSelectedColor(null);
            }
            this._ignoreEvents = false;
            this.repaint();
        }
        this._updateSelectedSlots();
        this._updateColorName();
        this._updateEditButton();
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, color2);
    }

    private void _updateSelectedSlots() {
        int n = this._grid.__getSelectedColumn();
        int n2 = this._grid.__getSelectedRow();
        this._grid.__setSelectedSlot(n, n2, false);
        n = this._customGrid.__getSelectedColumn();
        n2 = this._customGrid.__getSelectedRow();
        this._customGrid.__setSelectedSlot(n, n2, false);
    }

    private void _revalidate() {
        this.invalidate();
        this.repaint();
    }

    private Component _getInitialFocus() {
        return this.isCustomColorSelected() ? this._customGrid : this._grid;
    }

    private class Listener
    extends TwoDModelAdapter
    implements ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorPalettePane.PROPERTY_SELECTED_COLOR.equals(string)) {
                ColorPalettePane.this._selectedColorChanged((ColorGrid)propertyChangeEvent.getSource(), (Color)propertyChangeEvent.getOldValue(), (Color)propertyChangeEvent.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ColorPalettePane._KEY_EDIT.equals(string)) {
                ColorPalettePane.this._editColor();
            }
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }
    }

    private class AccessibleColorPalettePane
    extends JComponent.AccessibleJComponent {
        private AccessibleColorPalettePane() {
            super(ColorPalettePane.this);
        }
    }
}

