/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTextField;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeBaseItem;
import oracle.bali.ewt.dTree.DTreeChildManager;
import oracle.bali.ewt.dTree.DTreeDeferredParent;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSparseChildManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;

public class DTreeDeferringRoot
extends DTreeBaseItem
implements DTreeDeferringParent,
DTreeRootItem,
OneDModelListener {
    private OneDModel _datasrc;
    private DTreeItemFactory _factory;
    private DTree _tree;
    private DTreeChildManager _childmgr;
    private String _label;
    private Icon _icon;
    private int _y;
    private boolean _expanded;

    public DTreeDeferringRoot(String string, Icon icon, OneDModel oneDModel, DTreeItemFactory dTreeItemFactory) {
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        this._label = string;
        this._icon = icon;
        this._datasrc = oneDModel;
        this._factory = dTreeItemFactory;
        this._childmgr = this.createChildManager();
        this._datasrc.addModelListener(this);
    }

    public void childExpansionChanged(DTreeItem dTreeItem) {
        this._childmgr.childExpansionChanged(this, dTreeItem);
    }

    public boolean commitEdit(Component component) {
        this.setLabel(((JTextField)component).getText());
        return true;
    }

    public Object getChildData(int n) {
        return this._datasrc.getData(n);
    }

    public int getChildHeight() {
        DTree dTree = this.getTree();
        EWTTreeUI eWTTreeUI = dTree.getUI();
        return eWTTreeUI.getDeferredChildHeight(dTree, this.getPaintContext(), this, this.getChildIconHeight());
    }

    public int getChildX(int n) {
        return this._childmgr.getChildX(this, n);
    }

    public int getChildY(int n) {
        return this._childmgr.getChildY(this, n);
    }

    public OneDModel getModel() {
        return this._datasrc;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public DTreeItem getItem(int n) {
        return this._childmgr.getItem(this, n);
    }

    public DTreeItem getItemAt(int n, int n2) {
        return this._childmgr.getItemAt(this, n, n2);
    }

    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    public DTreeItemFactory getItemFactory() {
        return this._factory;
    }

    public String getLabel() {
        return this._label;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextExpandedChild(this, dTreeItem);
    }

    public DTreeItem getNextInstantiatedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextInstantiatedChild(this, dTreeItem);
    }

    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight(this);
        }
        return this.getSize().height;
    }

    public int getSubTreeWidth() {
        DTree dTree = this.getTree();
        if (dTree != null) {
            return dTree.getCanvasSize().width - this.getX();
        }
        return 0;
    }

    public DTree getTree() {
        DTreeItem dTreeItem = this.getParent();
        if (dTreeItem != null) {
            return dTreeItem.getTree();
        }
        return this._tree;
    }

    public int getY() {
        return this._y;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int n, int n2) {
        this._y = n2;
        this._childmgr.layout(this, n, n2);
    }

    public void setModel(OneDModel oneDModel) {
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        OneDModel oneDModel2 = this.getModel();
        int n = this.getItemCount();
        if (n > 0) {
            this.itemsRemoved(new OneDModelEvent(oneDModel2, 2002, 0, n));
        }
        oneDModel2.removeModelListener(this);
        this._datasrc = oneDModel;
        int n2 = oneDModel.getItemCount();
        if (n2 > 0) {
            this.itemsAdded(new OneDModelEvent(oneDModel, 2001, 0, n2));
        }
        oneDModel.addModelListener(this);
    }

    public void setExpanded(boolean bl) {
        DTree dTree = this.getTree();
        if (bl == this.isExpanded()) {
            return;
        }
        if (!DTreeDeferredParent.__fireExpansionChanging(dTree, bl, this)) {
            this._expanded = bl;
            DTreeDeferredParent.__fireExpansionChanged(dTree, bl, this);
        }
    }

    public void setIcon(Icon icon) {
        if (icon != this._icon) {
            this._icon = icon;
            DTree dTree = this.getTree();
            if (dTree != null) {
                dTree.itemsInvalidated(this.getParent(), this.getIndex(), 1);
            }
        }
    }

    public void setLabel(String string) {
        if (string != this._label) {
            this._label = string;
            DTree dTree = this.getTree();
            if (dTree != null) {
                dTree.itemsInvalidated(this.getParent(), this.getIndex(), 1);
            }
        }
    }

    public void setTree(DTree dTree) {
        this._tree = dTree;
    }

    public void itemsAdded(OneDModelEvent oneDModelEvent) {
        DTree dTree;
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsAdded(this, n, n2);
        }
        if ((dTree = this.getTree()) != null) {
            dTree.itemsAdded(this, n, n2);
        }
    }

    public void itemsRemoved(OneDModelEvent oneDModelEvent) {
        DTree dTree;
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsRemoved(this, n, n2);
        }
        if ((dTree = this.getTree()) != null) {
            dTree.itemsRemoved(this, n, n2);
        }
    }

    public void invalidateItems(OneDModelEvent oneDModelEvent) {
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.itemsInvalidated(this, n, n2);
        }
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager();
    }

    protected int getChildIconHeight() {
        return 18;
    }
}

