/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.painter.LinePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class DTreeLineDecoration
implements DTreeDecoration {
    private Painter _hLinePainter;
    private Painter _vLinePainter;
    private Color _lineColor;

    public DTreeLineDecoration() {
        this(new LinePainter(true, false), new LinePainter(false, false), Color.black);
    }

    public DTreeLineDecoration(Painter painter, Painter painter2, Color color) {
        if (painter == null || painter2 == null) {
            throw new IllegalArgumentException();
        }
        this._hLinePainter = painter;
        this._vLinePainter = painter2;
        this._lineColor = color;
    }

    public ImmInsets getDecorationInsets(DTree dTree) {
        return new ImmInsets(0, dTree.getIndentWidth(), 0, 0);
    }

    public void paintDecoration(PaintContext paintContext, Graphics graphics, DTreeItem dTreeItem, int n, int n2) {
        if (this.getHasLines(dTreeItem)) {
            int n3;
            int n4;
            Color color = graphics.getColor();
            if (this._lineColor != null) {
                graphics.setColor(this._lineColor);
            }
            DTree dTree = dTreeItem.getTree();
            DTreeItem dTreeItem2 = dTreeItem.getParent();
            int n5 = dTree.getIndentWidth();
            DTreeItem dTreeItem3 = null;
            if (dTreeItem2 != null) {
                n4 = dTreeItem2.getItemCount();
                n3 = dTreeItem.getIndex();
                if (n3 < n4 - 1) {
                    dTreeItem3 = dTreeItem2.getItem(n3 + 1);
                }
            }
            n4 = dTreeItem.getY();
            graphics.translate(0, -n4);
            n3 = n5 / 2;
            this._hLinePainter.paint(paintContext, graphics, n - n3, n4, n3, n2);
            if (dTreeItem3 != null) {
                int n6 = n4 + n2 / 2;
                int n7 = dTreeItem3.getY();
                Rectangle rectangle = graphics.getClipBounds();
                if (n6 < rectangle.y) {
                    n6 = rectangle.y;
                }
                this._vLinePainter.paint(paintContext, graphics, n - n5, n6, n5, n7 - n6);
            }
            if (dTreeItem2 != dTree.getRoot() || dTreeItem.getIndex() != 0) {
                this._vLinePainter.paint(paintContext, graphics, n - n5, n4, n5, n2 / 2);
            }
            graphics.translate(0, n4);
            graphics.setColor(color);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
    }

    protected boolean getHasLines(DTreeItem dTreeItem) {
        return true;
    }
}

