/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.busyBar.BusyBar;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.elaf.windows.WindowsBusyBarPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.painter.PainterTiler;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.plaf.PainterComponentUI;

public class WindowsEWTBusyBarUI
extends PainterComponentUI
implements EWTBusyBarUI {
    private static Painter _sPainter;
    private static WindowsEWTBusyBarUI _sInstance;

    public static ComponentUI createUI(JComponent jComponent) {
        return _sInstance;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("EWTBusyBar.border".equals(object)) {
            return new WindowsBusyBarBorder();
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        LookAndFeel.installColors(jComponent, "EWTBusyBar.background", "EWTBusyBar.foreground");
        LookAndFeel.installBorder(jComponent, "EWTBusyBar.border");
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected Painter getPainter(JComponent jComponent) {
        if (_sPainter == null) {
            _sPainter = new PainterStacker(new PainterTiler(new WindowsBusyBarPainter(), 6, 1), new TextPainter());
        }
        return _sPainter;
    }

    static {
        _sInstance = new WindowsEWTBusyBarUI();
    }

    private static class WindowsBusyBarBorder
    extends AbstractBorder
    implements UIResource {
        private Border _activeBusyBorder = UIManager.getBorder("ProgressBar.border");

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((BusyBar)component).isRunning()) {
                this._activeBusyBorder.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this._activeBusyBorder.getBorderInsets(component);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this._activeBusyBorder.getBorderInsets(component);
            insets.bottom = insets2.bottom;
            insets.top = insets2.top;
            insets.left = insets2.left;
            insets.right = insets2.right;
            return insets;
        }
    }
}

