/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.elaf.EWTDateEditorUI;
import oracle.bali.ewt.elaf.basic.BasicEWTSpinnerUI;
import oracle.bali.ewt.elaf.basic.DateEditorPainter;
import oracle.bali.ewt.elaf.basic.DateEditorUtils;
import oracle.bali.ewt.elaf.windows.WindowsEWTSpinnerUI;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.util.ImmInsets;

public class WindowsEWTDateEditorUI
extends WindowsEWTSpinnerUI
implements EWTDateEditorUI {
    private Painter _textPainter;
    private Painter _selectionPainter;
    private static final int _GAP = 1;
    private static WindowsEWTDateEditorUI _sInstance;

    private WindowsEWTDateEditorUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTDateEditorUI();
        }
        return _sInstance;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        DateEditor dateEditor = (DateEditor)jComponent;
        Component component = BasicEWTSpinnerUI.getSpinButton(dateEditor);
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = DateEditorUtils.getPreferredSize(dateEditor, this);
        ImmInsets immInsets = dateEditor.getBorderInsets();
        ImmInsets immInsets2 = this.getSpinButtonInsets(jComponent);
        int n = immInsets.top + immInsets.bottom;
        return new Dimension(dimension.width + dimension2.width + 1 + immInsets.left + immInsets.right + immInsets2.left + immInsets2.right, Math.max(dimension2.height + n, dimension.height + n + immInsets2.top + immInsets2.bottom));
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        DateEditor dateEditor = (DateEditor)jComponent;
        Painter painter = this.getTextPainter(dateEditor);
        Dimension dimension = painter.getMinimumSize(dateEditor.getPaintContext());
        Component component = BasicEWTSpinnerUI.getSpinButton(dateEditor);
        Dimension dimension2 = component.getMinimumSize();
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        dimension.width += dimension2.width;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        return dimension;
    }

    public Painter getTextPainter(JComponent jComponent) {
        if (this._textPainter == null) {
            this._textPainter = new DisablingPainter(new FixedBorderPainter(new TextPainter(), 0, 2, 0, 2), true);
        }
        return this._textPainter;
    }

    public Painter getSelectionTextPainter(JComponent jComponent) {
        if (this._selectionPainter == null) {
            this._selectionPainter = new DateEditorPainter(new FixedBorderPainter(new TextPainter(), 0, 2, 0, 2));
        }
        return this._selectionPainter;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        DateEditor dateEditor = (DateEditor)jComponent;
        Color color = graphics.getColor();
        Insets insets = dateEditor.getInsets();
        graphics.setColor(dateEditor.getBackground());
        graphics.fillRect(0, 0, dateEditor.getSize().width, dateEditor.getSize().height);
        graphics.translate(insets.left, insets.top);
        graphics.setColor(color);
        dateEditor.paintInterior(graphics);
        graphics.translate(-insets.left, -insets.top);
    }
}

