/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainter;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainterWithBorder;
import oracle.bali.ewt.elaf.windows.WindowsEWTTableUI;
import oracle.bali.ewt.elaf.windows.WindowsPivotCellBorderPainter;
import oracle.bali.ewt.elaf.windows.WindowsPivotHeaderSeparator;
import oracle.bali.ewt.elaf.windows.WindowsTableGeometryHelper;
import oracle.bali.ewt.elaf.windows.WindowsUIUtils;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public class WindowsEWTPivotHeaderUI
extends EWTPivotHeaderUI {
    private static WindowsEWTPivotHeaderUI _sInstance;
    private static WindowsEWTTableUI _sTableUI;

    protected WindowsEWTPivotHeaderUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTPivotHeaderUI();
            _sTableUI = (WindowsEWTTableUI)WindowsEWTTableUI.createUI(jComponent);
        }
        return _sInstance;
    }

    public void installUI(JComponent jComponent) {
        boolean bl;
        _sTableUI.installUI(jComponent);
        PivotHeader pivotHeader = (PivotHeader)jComponent;
        pivotHeader.setBorder(null);
        Grid grid = pivotHeader.getGrid();
        grid.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        grid.setBorder(null);
        grid.setUpperLeft(false);
        grid.setLowerRight(false);
        boolean bl2 = bl = ((PivotHeader)jComponent).getOrientation() == 0;
        if (bl) {
            grid.setLowerLeft(false);
        } else {
            grid.setUpperRight(false);
        }
        grid.setOverlayBorderVisible(false);
        Painter painter = WindowsPivotHeaderSeparator.getHorizontalSeparator();
        pivotHeader.setHorizontalSeparatorPainter(painter);
        painter = WindowsPivotHeaderSeparator.getVerticalSeparator();
        pivotHeader.setVerticalSeparatorPainter(painter);
        Header header = pivotHeader.getRowHeader();
        if (header != null) {
            header.setBorder(null);
            header.setFirstEdge(true);
            header.setDefaultPainter(this.getDefaultHeaderItemPainter(jComponent, !bl));
        }
        if ((header = pivotHeader.getColumnHeader()) != null) {
            header.setBorder(null);
            header.setFirstEdge(true);
            header.setDefaultPainter(this.getDefaultHeaderItemPainter(jComponent, !bl));
        }
    }

    public Painter getCornerPainter(JComponent jComponent, int n) {
        return _sTableUI.getCornerPainter(jComponent, n);
    }

    public Painter getDefaultHeaderItemPainter(JComponent jComponent, boolean bl) {
        return PivotHeaderGrippyPainter.getPainter(bl, true);
    }

    public Painter getDefaultHeaderItemPainterWithBorder(JComponent jComponent) {
        return PivotHeaderGrippyPainterWithBorder.getPainter(true);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("PivotHeader.DefaultAppearance".equals(object)) {
            return WindowsEWTPivotHeaderUI._getDefaultAppearance();
        }
        return null;
    }

    public Image getDrillImage(JComponent jComponent) {
        return WindowsUIUtils.getImage("drillTriangle.gif");
    }

    public Image getDrilledImage(JComponent jComponent) {
        return WindowsUIUtils.getImage("drilledTriangle.gif");
    }

    public Color getSwapForegroundColor(JComponent jComponent, Appearance appearance) {
        Color color = UIManager.getColor(LookAndFeel.DARK_INTENSITY);
        if (color == null) {
            color = ColorUtils.lighterShadeColor(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        }
        return color;
    }

    public Color getSwapBackgroundColor(JComponent jComponent, Appearance appearance) {
        Color color = appearance.getBackground();
        if (color == null) {
            color = jComponent.getBackground();
        }
        return ColorUtils.darkerShadeColor(color);
    }

    public void updateGeometry(JComponent jComponent) {
        WindowsTableGeometryHelper.updateGeometry((SpreadTable)jComponent, WindowsPivotCellBorderPainter.getBorderPainter(false));
    }

    private static Appearance _getDefaultAppearance() {
        Appearance appearance = (Appearance)UIManager.get("Grid.DefaultAppearance");
        appearance = appearance.copy();
        appearance.setInsets(ImmInsets.getEmptyInsets());
        appearance.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        appearance.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        boolean bl = false;
        BorderPainter borderPainter = WindowsPivotCellBorderPainter.getBorderPainter(bl);
        appearance.setBorderPainter(borderPainter);
        return appearance;
    }
}

