/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;

public abstract class CellInputHandler {
    public boolean validateFocus(Grid grid, int n, int n2) {
        return true;
    }

    public void updateUI() {
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        boolean bl;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !(bl = grid.requestFocus(n, n2, mouseEvent))) {
            mouseEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseEntered(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseMoved(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyCode() == 113 && keyEvent.getModifiers() == 0) {
            grid.startCellEdit(n, n2);
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        grid.startCellEdit(n, n2);
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent, Grid grid, int n, int n2) {
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
    }

    public void focusLost(AWTEvent aWTEvent, Grid grid, int n, int n2) {
    }

    public Component getEditControl(Grid grid, int n, int n2) {
        return null;
    }

    public Rectangle getEditControlBounds(Grid grid, int n, int n2) {
        return null;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return true;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
    }

    public void cancelEdit(Grid grid, int n, int n2) {
    }

    public Object commitEdit(Grid grid, int n, int n2) {
        return grid.getModel().getData(n, n2);
    }

    public Component[] getFocusableComponents(Grid grid, int n, int n2) {
        Component component = this.getEditControl(grid, n, n2);
        if (component == null) {
            return new Component[0];
        }
        return new Component[]{component};
    }
}

