/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.olaf.AbstractButtonPaintContext;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.MarginBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.util.ImmInsets;

class OracleComboBoxButton
extends PainterButton {
    private JComboBox _comboBox;
    private JList _listBox;
    private CellRendererPane _rendererPane;
    private boolean _iconOnly;
    private static Painter _sPainter;
    private static Painter _sIconOnlyPainter;
    private static ImmInsets _sIconInsets;
    private static ImmInsets _sIconArmedInsets;
    private static ImmInsets _sInsets;
    private static ImmInsets _sArmedInsets;

    public OracleComboBoxButton(JComboBox jComboBox, CellRendererPane cellRendererPane) {
        super((Painter)null);
        this._comboBox = jComboBox;
        this._rendererPane = cellRendererPane;
        this.setFocusable(false);
        this.setModel(this.model);
        this.setBackground(null);
        this.setForeground(null);
    }

    void setList(JList jList) {
        this._listBox = jList;
    }

    public void updateUI() {
        super.updateUI();
        PaintCtxt paintCtxt = new PaintCtxt(this);
        OracleUIUtils.putPaintContext(this, paintCtxt);
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean hasPaintFocus() {
        if (this._comboBox != null) {
            return this._comboBox.hasFocus();
        }
        return false;
    }

    public Painter getPainter() {
        if (this.isIconOnly()) {
            if (_sIconOnlyPainter == null) {
                _sIconOnlyPainter = new FixedAlignmentPainter(this._getImageSetPainter());
            }
            return _sIconOnlyPainter;
        }
        if (_sPainter == null) {
            _sPainter = new PainterJoiner(new FixedAlignmentPainter(this._getImageSetPainter()), new MarginBorderPainter(new OracleFocusPainter(null, true)), 10, true);
        }
        return _sPainter;
    }

    public final boolean isIconOnly() {
        return this._iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this._iconOnly = bl;
    }

    public boolean isEnabled() {
        if (this._comboBox != null) {
            return this._comboBox.isEnabled();
        }
        return super.isEnabled();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getID() == 501) {
            if (this._comboBox.isEditable()) {
                this._comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this._comboBox.requestFocus();
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getForeground());
        JComboBox jComboBox = this._comboBox;
        PaintContext paintContext = OracleUIUtils.getPaintContext(this);
        if (!this.isIconOnly() && jComboBox != null) {
            boolean bl;
            boolean bl2;
            Insets insets = this.getInsets();
            int n = this.getWidth() - (insets.left + insets.right);
            int n2 = this.getHeight() - (insets.top + insets.bottom);
            ImmInsets immInsets = OracleFocusPainter.getFocusInsets();
            int n3 = insets.left + immInsets.left;
            int n4 = insets.top + immInsets.top;
            boolean bl3 = bl2 = (paintContext.getPaintState() & 2) != 0;
            if (bl2) {
                ++n4;
                --n2;
                ++n3;
                --n;
            }
            int n5 = n3 + (n - 1) - (immInsets.left + immInsets.right);
            int n6 = n4 + (n2 - 1) - (immInsets.top + immInsets.bottom);
            ListCellRenderer<Object> listCellRenderer = jComboBox.getRenderer();
            boolean bl4 = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this._listBox, jComboBox.getSelectedItem(), -1, bl4, false);
            CellRendererPane cellRendererPane = this._rendererPane;
            component.setFont(cellRendererPane.getFont());
            component.setBackground(this.getBackground());
            component.setForeground(this.getForeground());
            boolean bl5 = bl = jComboBox.isEnabled() != component.isEnabled();
            if (bl) {
                component.setEnabled(!component.isEnabled());
            }
            int n7 = n - (insets.right + 14);
            cellRendererPane.paintComponent(graphics, component, this, n3 += 2, n4 -= 2, n7 -= 2, n2);
            if (bl) {
                component.setEnabled(!component.isEnabled());
            }
        }
        UIUtils.paint(graphics, this.getPainter(), paintContext, this);
    }

    private Painter _getImageSetPainter() {
        return new ShadowBorder(new ImageSetPainter());
    }

    static {
        _sIconInsets = ImmInsets.getEmptyInsets();
        _sIconArmedInsets = new ImmInsets(1, 1, -1, -1);
        _sInsets = new ImmInsets(0, 0, 1, 0);
        _sArmedInsets = new ImmInsets(1, 1, 0, -1);
    }

    static class ShadowBorder
    extends MarginBorderPainter {
        public ShadowBorder(Painter painter) {
            super(painter);
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent = paintContext.getComponent();
            JComboBox jComboBox = (JComboBox)jComponent.getParent();
            int n5 = paintContext.getPaintState();
            boolean bl = (n5 & 1) != 0;
            boolean bl2 = (n5 & 2) != 0;
            boolean bl3 = (n5 & 4) != 0;
            boolean bl4 = jComboBox.isEditable();
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 2, rectangle.width + 2, rectangle.height + 4);
            n2 = -1;
            int n6 = n + n3;
            int n7 = n2 + jComponent.getSize().height;
            Color color = graphics.getColor();
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            if (!bl3) {
                if (bl2 && bl4) {
                    Color color2 = uIDefaults.getColor(ColorScheme.DARK_INTENSITY);
                    graphics.setColor(color2);
                    graphics.drawLine(n + 1, n2 - 1, n + 1, n7 - 1);
                    graphics.drawLine(n + 2, n2 - 1, n + 2, n7 - 1);
                } else if (bl4) {
                    Color color3 = uIDefaults.getColor(ColorScheme.NORMAL_INTENSITY);
                    Color color4 = bl ? jComboBox.getBackground() : Color.white;
                    graphics.setColor(color3);
                    graphics.drawLine(n, n2, n + 1, n2);
                    graphics.drawLine(n6, n2, n6 - 1, n2);
                    graphics.drawLine(n, n2, n, n7);
                    graphics.drawLine(n6, n2, n6, n7 - 1);
                    graphics.drawLine(n, n7, n6 - 1, n7);
                    graphics.drawLine(n, n7 - 1, n + 1, n7 - 1);
                    graphics.drawLine(n6, n7 - 1, n6 - 1, n7 - 1);
                    graphics.setColor(color4);
                    graphics.drawLine(n + 2, n2, n6 - 2, n2);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n7 - 2);
                }
            } else if (bl4) {
                Color color5 = uIDefaults.getColor(ColorScheme.NORMAL_INTENSITY);
                Color color6 = jComboBox.getBackground();
                graphics.setColor(color6);
                graphics.drawLine(n + 1, n2 - 1, n6 - 1, n2 - 1);
                graphics.drawLine(n, n2, n6, n2);
                graphics.drawLine(n + 1, n7 + 1, n6 - 1, n7 + 1);
                graphics.drawLine(n6, n, n6, n7);
                graphics.setColor(color5);
                graphics.drawLine(n - 1, n2 - 1, n - 1, n7 + 1);
                graphics.drawLine(n, n2 - 1, n, n2 - 1);
                graphics.drawLine(n, n7 + 1, n, n7 + 1);
            }
            graphics.setColor(color);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private class PaintCtxt
    extends AbstractButtonPaintContext {
        public PaintCtxt(OracleComboBoxButton oracleComboBoxButton2) {
            super(oracleComboBoxButton2, true);
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (OracleComboBoxButton.this.hasPaintFocus()) {
                n |= 0x40;
            }
            if (OracleComboBoxButton.this._comboBox != null && OracleComboBoxButton.this._comboBox.isPopupVisible()) {
                n |= 2;
            }
            return n;
        }

        public Object getPaintData(Object object) {
            if (PaintContext.IMAGESET_KEY.equals(object)) {
                return (ImageSet)this.getPaintUIDefaults().get("ComboBox.arrowSet");
            }
            if (MarginBorderPainter.MARGIN_KEY.equals(object)) {
                boolean bl;
                boolean bl2 = bl = (this.getPaintState() & 2) != 0;
                if (OracleComboBoxButton.this.isIconOnly()) {
                    return bl ? _sIconArmedInsets : _sIconInsets;
                }
                return bl ? _sArmedInsets : _sInsets;
            }
            return super.getPaintData(object);
        }
    }
}

