/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleScrollPaneUI
extends BasicScrollPaneUI
implements Serializable {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleScrollPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OracleUIUtils.putPaintContext(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            OracleUIUtils.fillBackground(graphics, jComponent);
        }
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        Color color = graphics.getColor();
        graphics.setColor(OracleUIUtils.getUIDefaults(jComponent).getColor(ColorScheme.NORMAL_INTENSITY));
        if (jScrollBar != null && jScrollBar.isVisible()) {
            int n = jScrollBar2 != null && jScrollBar2.isVisible() ? jScrollBar2.getY() + jScrollBar2.getHeight() - jScrollBar.getY() : jScrollBar.getHeight();
            graphics.fillRect(jScrollBar.getX(), jScrollBar.getY(), jScrollBar.getWidth(), n);
        }
        if (jScrollBar2 != null && jScrollBar2.isVisible()) {
            graphics.fillRect(jScrollBar2.getX(), jScrollBar2.getY(), jScrollBar2.getWidth(), jScrollBar2.getHeight());
        }
        graphics.setColor(color);
        this.paint(graphics, jComponent);
    }

    protected void syncScrollPaneWithViewport() {
        Component component;
        super.syncScrollPaneWithViewport();
        JViewport jViewport = this.scrollpane.getViewport();
        if (jViewport != null && (component = jViewport.getView()) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (jComponent instanceof JTextComponent) {
                jComponent.setBorder(new BasicBorders.MarginBorder());
            } else if (jComponent.getBorder() instanceof UIResource) {
                jComponent.setBorder(null);
            }
        }
    }

    private OracleScrollPaneUI() {
    }
}

