/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;

class FixedFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean _selectAll = true;

    FixedFieldCaret() {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
            if (this._selectAll) {
                this.setDot(0);
                this.moveDot(this.getComponent().getDocument().getLength());
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        boolean bl = true;
        if (bl && !focusEvent.isTemporary()) {
            this._selectAll = true;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this._selectAll = false;
        }
        super.mousePressed(mouseEvent);
    }

    protected void adjustVisibility(Rectangle rectangle) {
        JTextField jTextField = (JTextField)this.getComponent();
        BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
        int n = rectangle.x + boundedRangeModel.getValue();
        int n2 = boundedRangeModel.getExtent() / 4;
        if (n < boundedRangeModel.getValue()) {
            boundedRangeModel.setValue(n - n2);
        } else if (n > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
            boundedRangeModel.setValue(n - 3 * n2);
        }
    }
}

