/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;

public class PivotHeaderInputHandler
extends ProxyInputHandler {
    public PivotHeaderInputHandler() {
        super(NullInputHandler.getCellInputHandler());
    }

    public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        grid.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        PivotHeader pivotHeader = this.getHeader(grid);
        AbstractPivotHeaderCell abstractPivotHeaderCell = pivotHeader.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            Cursor cursor;
            Point point = AbstractBigCell.convertPoint(grid, abstractPivotHeaderCell, n, n2, mouseEvent.getX(), mouseEvent.getY());
            int n3 = abstractPivotHeaderCell.getColumn();
            int n4 = abstractPivotHeaderCell.getRow();
            Cursor cursor2 = grid.getCursor();
            if (cursor2 != (cursor = pivotHeader.isDrill(n3, n4, point.x, point.y) ? pivotHeader.getDrillCursor(n3, n4) : Cursor.getDefaultCursor())) {
                grid.setCursor(cursor);
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.mouseMoved(mouseEvent, grid, n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        if (!bl) {
            return;
        }
        PivotHeader pivotHeader = this.getHeader(grid);
        AbstractPivotHeaderCell abstractPivotHeaderCell = pivotHeader.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            boolean bl2 = pivotHeader.isDrillable(n, n2);
            boolean bl3 = bl2 ? false : pivotHeader.isCollapsable(n, n2);
            Point point = AbstractBigCell.convertPoint(grid, abstractPivotHeaderCell, n, n2, mouseEvent.getX(), mouseEvent.getY());
            if ((bl2 || bl3) && pivotHeader.isDrill(abstractPivotHeaderCell.getColumn(), abstractPivotHeaderCell.getRow(), point.x, point.y)) {
                if (bl2) {
                    pivotHeader.fireHeaderCellDrillRequest(n, n2);
                } else {
                    pivotHeader.fireCollapse(n, n2);
                }
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.mousePressed(mouseEvent, grid, n, n2);
        }
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.isConsumed()) {
            return;
        }
        PivotHeader pivotHeader = this.getHeader(grid);
        AbstractPivotHeaderCell abstractPivotHeaderCell = pivotHeader.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            boolean bl;
            boolean bl2 = pivotHeader.isDrillable(n, n2);
            boolean bl3 = bl2 ? false : pivotHeader.isCollapsable(n, n2);
            boolean bl4 = bl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? keyEvent.isControlDown() : keyEvent.isAltDown();
            if (bl2 && bl && keyEvent.getKeyCode() == 40) {
                pivotHeader.fireHeaderCellDrillRequest(n, n2);
                keyEvent.consume();
            } else if (bl3 & bl & keyEvent.getKeyCode() == 38) {
                pivotHeader.fireCollapse(n, n2);
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent, grid, n, n2);
        }
    }

    protected PivotHeader getHeader(Grid grid) {
        Container container = grid.getParent();
        PivotHeader pivotHeader = null;
        if (container instanceof PivotHeader) {
            pivotHeader = (PivotHeader)container;
        } else if (container instanceof PivotScrollPaneView) {
            PivotScrollPaneView pivotScrollPaneView = (PivotScrollPaneView)container;
            PivotTable pivotTable = pivotScrollPaneView.getPivotTable();
            pivotHeader = pivotTable.getPivotHeader(pivotScrollPaneView.getOrientation());
        }
        return pivotHeader;
    }
}

