/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTShuttleUI;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Reorderable;
import oracle.bali.ewt.shuttle.Reorderable2;
import oracle.bali.ewt.shuttle.ShuttleDnDSupport;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleLayout;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class Shuttle
extends LWComponent
implements Accessible {
    public static final String FROM_HEADER_COMPONENT = "FromHeader";
    public static final String TO_HEADER_COMPONENT = "ToHeader";
    public static final String FROM_FOOTER_COMPONENT = "FromFooter";
    public static final String TO_FOOTER_COMPONENT = "ToFooter";
    public static final String COMMON_FOOTER_COMPONENT = "CommonFooter";
    public static final String BUTTON_AREA_COMPONENT = "ButtonArea";
    public static final int ICON_MODE = 1;
    public static final int TEXT_MODE = 2;
    public static final int MOVE_BUTTON = 1;
    public static final int MOVE_ALL_BUTTON = 2;
    public static final int REMOVE_BUTTON = 4;
    public static final int REMOVE_ALL_BUTTON = 8;
    public static final int MOVE_MODE = 0;
    public static final int COPY_MODE = 1;
    public static final int BUTTON_INDEX_ADD = 0;
    public static final int BUTTON_INDEX_REMOVE = 1;
    public static final int BUTTON_INDEX_ADD_ALL = 2;
    public static final int BUTTON_INDEX_REMOVE_ALL = 3;
    public static final int BUTTON_INDEX_COPY = 4;
    public static final int BUTTON_INDEX_COPY_ALL = 5;
    public static final int BUTTON_INDEX_UP = 6;
    public static final int BUTTON_INDEX_DOWN = 7;
    public static final int BUTTON_INDEX_TOP = 8;
    public static final int BUTTON_INDEX_BOTTOM = 9;
    private boolean _ignoreSelectionEvents = false;
    private LayoutManager _HORIZONTAL_BUTTON_LAYOUT;
    private LayoutManager _VERTICAL_BUTTON_LAYOUT;
    private ItemPicker _fromPicker;
    private ItemPicker _toPicker;
    private JPanel _shuttleButtons;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _addAllButton;
    private JButton _removeAllButton;
    private JButton _toReorderUp;
    private JButton _toReorderDown;
    private JButton _toReorderTop;
    private JButton _toReorderBottom;
    private JButton _fromReorderUp;
    private JButton _fromReorderDown;
    private JButton _fromReorderTop;
    private JButton _fromReorderBottom;
    private Header _fromHeader;
    private Header _toHeader;
    private int _buttonMode;
    private int _buttonsShown;
    private int _itemsUnique;
    private boolean _horizontalLayout = true;
    private boolean _reversed;
    private boolean _actualReversed;
    private String[] _buttonLabels;
    private int[] _buttonMnemonics;
    private static Image[] _buttonImages;
    private ShuttleHandler _handler;
    private ListenerManager _shuttleListeners;
    private int[] _actionMap;
    private ShuttleDnDSupport _shuttleDnDSupport;
    private static final int _INTERIOR_BUTTON_GAP = 3;
    private static final LayoutManager _REORDER_LAYOUT;
    private static final int _STRINGINDEX_MOVE = 0;
    private static final int _STRINGINDEX_MOVEALL = 1;
    private static final int _STRINGINDEX_REMOVE = 2;
    private static final int _STRINGINDEX_REMOVEALL = 3;
    private static final int _STRINGINDEX_COPY = 4;
    private static final int _STRINGINDEX_COPYALL = 5;
    private static final int _STRINGINDEX_REORDER_UP = 6;
    private static final int _STRINGINDEX_REORDER_DOWN = 7;
    private static final int _STRINGINDEX_REORDER_TOP = 8;
    private static final int _STRINGINDEX_REORDER_BOTTOM = 9;
    private static final int _OLD_MNEMONIC_COUNT = 6;
    private static final int _MNEMONIC_COUNT = 10;
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _MOVE_KEY = "SHUTTLE.MOVE";
    private static final String _REMOVE_KEY = "SHUTTLE.REMOVE";
    private static final String _MOVE_ALL_KEY = "SHUTTLE.MOVE_ALL";
    private static final String _REMOVE_ALL_KEY = "SHUTTLE.REMOVE_ALL";
    private static final String _COPY_KEY = "SHUTTLE.COPY";
    private static final String _COPY_ALL_KEY = "SHUTTLE.COPY_ALL";
    private static final String _REORDER_UP_KEY = "SHUTTLE.REORDER_UP";
    private static final String _REORDER_DOWN_KEY = "SHUTTLE.REORDER_DOWN";
    private static final String _REORDER_TOP_KEY = "SHUTTLE.REORDER_TOP";
    private static final String _REORDER_BOTTOM_KEY = "SHUTTLE.REORDER_BOTTOM";
    private static final String _BUTTON_TOOL_TIP_KEY = "SHUTTLE.BUTTON_TOOL_TIP";
    private static Method _sIconGapMethod;
    private static final String _ADD_NAME = "Add";
    private static final String _ADD_ALL_NAME = "Add All";
    private static final String _REMOVE_NAME = "Remove";
    private static final String _REMOVE_ALL_NAME = "Remove All";
    private static final String _UP_NAME = "Up";
    private static final String _DOWN_NAME = "Down";
    private static final String _TOP_NAME = "Top";
    private static final String _BOTTOM_NAME = "Bottom";
    private static final String _LABELED_BY = "labeledBy";
    static /* synthetic */ Class class$javax$swing$AbstractButton;

    public Shuttle() {
        ShuttleLayout shuttleLayout = this._createLayoutManager();
        super.setLayout(shuttleLayout);
        this._buttonMode = 1;
        this._buttonsShown = 15;
        this._shuttleButtons = new JPanel();
        FocusUtils.setFocusable(this._shuttleButtons, false);
        this._handler = new ShuttleHandler();
        this._addButton = this._createButton(_ADD_NAME);
        this._removeButton = this._createButton(_REMOVE_NAME);
        this._addAllButton = this._createButton(_ADD_ALL_NAME);
        this._removeAllButton = this._createButton(_REMOVE_ALL_NAME);
        this._loadCompatibleButtonLabels();
        this._updateButtonVisibility();
        this._shuttleButtons.add(this._addButton);
        this._shuttleButtons.add(this._addAllButton);
        this._shuttleButtons.add(this._removeButton);
        this._shuttleButtons.add(this._removeAllButton);
        this.add((Component)this._shuttleButtons, "ShuttleControl");
        this.addPropertyChangeListener(this._handler);
        this.updateUI();
    }

    public void dispose() {
        Enumeration enumeration;
        if (this._shuttleButtons == null) {
            return;
        }
        ItemPicker itemPicker = this._fromPicker;
        this.setFromPicker(null);
        if (itemPicker != null && itemPicker instanceof ListPicker) {
            ((ListPicker)itemPicker).dispose();
        }
        this._fromPicker = null;
        ItemPicker itemPicker2 = this._toPicker;
        this.setToPicker(null);
        if (itemPicker2 != null && itemPicker2 instanceof ListPicker) {
            ((ListPicker)itemPicker2).dispose();
        }
        this._toPicker = null;
        this._disposeReorderControls();
        if (this._fromHeader != null) {
            this._fromHeader.setHeader(null);
            this._fromHeader = null;
        }
        if (this._toHeader != null) {
            this._toHeader.setHeader(null);
            this._toHeader = null;
        }
        if (this._shuttleDnDSupport != null) {
            this._shuttleDnDSupport.dispose();
            this._shuttleDnDSupport = null;
        }
        this._addButton.removeActionListener(this._handler);
        this._addButton = null;
        this._removeButton.removeActionListener(this._handler);
        this._removeButton = null;
        this._addAllButton.removeActionListener(this._handler);
        this._addAllButton = null;
        this._removeAllButton.removeActionListener(this._handler);
        this._removeAllButton = null;
        this.removePropertyChangeListener(this._handler);
        this._handler = null;
        this._buttonLabels = null;
        this._buttonMnemonics = null;
        this._actionMap = null;
        if (this._shuttleListeners != null && (enumeration = this._shuttleListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                this._shuttleListeners.removeListener((EventListener)enumeration.nextElement());
            }
        }
        this._shuttleListeners = null;
        this._shuttleButtons.removeAll();
        this._shuttleButtons.setLayout(null);
        this._shuttleButtons = null;
        this.removeAll();
        this.setLayout(null);
    }

    public synchronized void addShuttleListener(ShuttleListener shuttleListener) {
        if (this._shuttleListeners == null) {
            this._shuttleListeners = new ListenerManager();
        }
        this._shuttleListeners.addListener((EventListener)shuttleListener);
    }

    public synchronized void removeShuttleListener(ShuttleListener shuttleListener) {
        this._shuttleListeners.removeListener((EventListener)shuttleListener);
    }

    public void setFromPicker(ItemPicker itemPicker) {
        if (this._fromPicker != null) {
            this.remove(this._fromPicker.getComponent());
        }
        if (itemPicker != null) {
            this.add(itemPicker.getComponent(), "FromList");
            if (this._fromHeader == null) {
                this._fromHeader = new Header(itemPicker, null, true);
                this.add((Component)this._fromHeader, FROM_HEADER_COMPONENT);
            }
        }
        if (this._fromHeader != null) {
            this._fromHeader.setItemPicker(itemPicker);
        }
        this._setFromPicker(itemPicker);
    }

    public final ItemPicker getFromPicker() {
        return this._fromPicker;
    }

    public void setToPicker(ItemPicker itemPicker) {
        if (this._toPicker != null) {
            this.remove(this._toPicker.getComponent());
        }
        if (itemPicker != null) {
            this.add(itemPicker.getComponent(), "ToList");
            if (this._toHeader == null) {
                this._toHeader = new Header(itemPicker, null, false);
                this.add((Component)this._toHeader, TO_HEADER_COMPONENT);
            }
        }
        if (this._toHeader != null) {
            this._toHeader.setItemPicker(itemPicker);
        }
        this._setToPicker(itemPicker);
    }

    public final ItemPicker getToPicker() {
        return this._toPicker;
    }

    public Component getComponent(Object object) {
        if (object == FROM_HEADER_COMPONENT) {
            return this._fromHeader == null ? null : this._fromHeader.getUserHeader();
        }
        if (object == TO_HEADER_COMPONENT) {
            return this._toHeader == null ? null : this._toHeader.getUserHeader();
        }
        return this._getLayout().getComponent(object);
    }

    public void setUseTextButtons(boolean bl) {
        if (bl) {
            this.setButtonDisplayMode(2);
        } else {
            this.setButtonDisplayMode(1);
        }
    }

    public void setButtonDisplayMode(int n) {
        if (n != this._buttonMode) {
            if (n < 1 || n > 3) {
                throw new IllegalArgumentException();
            }
            this._buttonMode = n;
            this._updateButtonContents();
            this._updateReorderContents();
        }
    }

    public int getButtonDisplayMode() {
        return this._buttonMode;
    }

    public boolean getUseTextButtons() {
        return (this._buttonMode & 2) != 0;
    }

    public boolean isHorizontalLayout() {
        return this._horizontalLayout;
    }

    public boolean isLayoutReversed() {
        return this._reversed;
    }

    public int getMode() {
        return this._itemsUnique;
    }

    public void setHorizontalLayout(boolean bl) {
        if (bl != this._horizontalLayout) {
            this._horizontalLayout = bl;
            this._getLayout().setHorizontalLayout(bl);
            if (this._horizontalLayout) {
                this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
            } else {
                this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
            }
            this._updateButtonContents();
            this.revalidate();
            AccessibleContext accessibleContext = this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, bl ? AccessibleState.HORIZONTAL : AccessibleState.VERTICAL);
            }
        }
    }

    public void setLayoutReversed(boolean bl) {
        this._reversed = bl;
        int n = this.getActualReadingDirection();
        if (n == 2) {
            this._setActualLayoutReversed(!bl);
        } else {
            this._setActualLayoutReversed(bl);
        }
    }

    public void setMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (n != this._itemsUnique) {
            this._itemsUnique = n;
            this._updateButtonContents();
            this._updateButtonMnemonics();
            this.revalidate();
            this._createShuttleDnDSupport();
        }
    }

    public void setMoveAllAllowed(boolean bl) {
        if (bl) {
            this.setButtonsShown(this._buttonsShown | 2 | 8);
        } else {
            this.setButtonsShown(this._buttonsShown & 0xFFFFFFFD & 0xFFFFFFF7);
        }
    }

    public void setMoveAllowed(boolean bl) {
        if (bl) {
            this.setButtonsShown(this._buttonsShown | 1 | 4);
        } else {
            this.setButtonsShown(this._buttonsShown & 0xFFFFFFFE & 0xFFFFFFFB);
        }
    }

    public void setButtonsShown(int n) {
        if (n != this._buttonsShown) {
            this._buttonsShown = n;
            this._updateButtonVisibility();
        }
    }

    public String[] getButtonLabels() {
        if (this._buttonLabels == null) {
            this._loadCompatibleButtonLabels();
        }
        String[] stringArray = new String[]{this._buttonLabels[0], this._buttonLabels[2], this._buttonLabels[1], this._buttonLabels[3], this._buttonLabels[4], this._buttonLabels[5], this._buttonLabels[6], this._buttonLabels[7], this._buttonLabels[8], this._buttonLabels[9]};
        return stringArray;
    }

    public void setButtonLabels(String[] stringArray) {
        if (stringArray == null) {
            this._loadCompatibleButtonLabels();
        } else {
            if (stringArray.length < 6) {
                throw new IllegalArgumentException("Must provide all 6 button labels");
            }
            if (this._buttonLabels == null) {
                this._loadCompatibleButtonLabels();
            }
            this._buttonLabels[0] = stringArray[0];
            this._buttonLabels[2] = stringArray[1];
            this._buttonLabels[1] = stringArray[2];
            this._buttonLabels[3] = stringArray[3];
            this._buttonLabels[4] = stringArray[4];
            this._buttonLabels[5] = stringArray[5];
            this._updateMnemonicsfromLabel(stringArray);
        }
        this._updateButtonContents();
        this._updateButtonMnemonics();
    }

    public int[] getButtonMnemonics() {
        int[] nArray = null;
        if (this._buttonMnemonics != null) {
            nArray = new int[]{this._buttonMnemonics[0], this._buttonMnemonics[2], this._buttonMnemonics[1], this._buttonMnemonics[3], this._buttonMnemonics[4], this._buttonMnemonics[5], this._buttonMnemonics[6], this._buttonMnemonics[7], this._buttonMnemonics[8], this._buttonMnemonics[9]};
        } else {
            nArray = this._getDefaultMnemonics();
            int n = nArray[1];
            int n2 = nArray[2];
            nArray[2] = n;
            nArray[1] = n2;
        }
        return nArray;
    }

    public void setButtonMnemonics(int[] nArray) {
        if (nArray == null) {
            this._buttonMnemonics = null;
        } else {
            if (nArray.length != 10 && nArray.length != 6) {
                throw new IllegalArgumentException("wrong mnemonic count");
            }
            if (this._buttonMnemonics == null || this._buttonMnemonics.length != 10) {
                this._buttonMnemonics = new int[10];
            }
            this._buttonMnemonics[0] = nArray[0];
            this._buttonMnemonics[2] = nArray[1];
            this._buttonMnemonics[1] = nArray[2];
            this._buttonMnemonics[3] = nArray[3];
            this._buttonMnemonics[4] = nArray[4];
            this._buttonMnemonics[5] = nArray[5];
            if (nArray.length == 6) {
                this._buttonMnemonics[6] = 0;
                this._buttonMnemonics[7] = 0;
                this._buttonMnemonics[8] = 0;
                this._buttonMnemonics[9] = 0;
            } else {
                this._buttonMnemonics[6] = nArray[6];
                this._buttonMnemonics[7] = nArray[7];
                this._buttonMnemonics[8] = nArray[8];
                this._buttonMnemonics[9] = nArray[9];
            }
        }
        this._updateButtonMnemonics();
        this._updateButtonContents();
        this._updateReorderContents();
    }

    public boolean isMoveAllAllowed() {
        return (this._buttonsShown & 2) != 0 && (this._buttonsShown & 8) != 0;
    }

    public boolean isMoveAllowed() {
        return (this._buttonsShown & 1) != 0 && (this._buttonsShown & 4) != 0;
    }

    public int getButtonsShown() {
        return this._buttonsShown;
    }

    public void remove(Component component) {
        if (component != null && component.getParent() == this._shuttleButtons) {
            this._shuttleButtons.remove(component);
            this._updateButtonFocus();
        } else if (component != null && component.getParent() instanceof Header) {
            ((Header)component.getParent()).setHeader(null);
            this._updateButtonFocus();
        } else {
            this._updateFooterVisiblity(component, false);
            super.remove(component);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._updateButtonFonts();
    }

    public void addNotify() {
        super.addNotify();
        this._updateButtonFonts();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (object == null || object == BUTTON_AREA_COMPONENT) {
            int n2 = this._shuttleButtons.getComponentCount();
            if (this.isMoveAllowed()) {
                n2 -= 2;
            } else if (this.isMoveAllAllowed()) {
                --n2;
            }
            this._shuttleButtons.add(component, n2);
            this._updateButtonFocus();
            this._updateButtonFonts();
            this.revalidate();
        } else {
            ShuttleLayout shuttleLayout = this._getLayout();
            Component component2 = this.getComponent(object);
            if (object == FROM_HEADER_COMPONENT) {
                if (this._fromHeader == null) {
                    this._fromHeader = new Header(this._fromPicker, component, true);
                    component = this._fromHeader;
                } else if (component != this._fromHeader) {
                    this._fromHeader.setHeader(component);
                    this._updateButtonFocus();
                    return;
                }
            } else if (object == TO_HEADER_COMPONENT) {
                if (this._toHeader == null) {
                    this._toHeader = new Header(this._toPicker, component, false);
                    component = this._toHeader;
                } else if (component != this._toHeader) {
                    this._toHeader.setHeader(component);
                    this._updateButtonFocus();
                    return;
                }
            }
            super.addImpl(component, object, n);
            if (component2 != null) {
                super.remove(component2);
            }
            if (this._updateFooterVisiblity(component, true)) {
                this._updateButtonFocus();
            }
        }
    }

    public String getUIClassID() {
        return "EWTShuttleUI";
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof ShuttleLayout) {
            super.setLayout(layoutManager);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._addButton != null) {
            this._loadCompatibleButtonLabels();
            this._updateButtonContents();
            this._updateButtonMnemonics();
        }
        if (this._fromReorderUp != null || this._toReorderUp != null) {
            this._updateReorderContents();
        }
        if (this._fromHeader != null) {
            this._fromHeader.loadButtonLabel();
        }
        if (this._toHeader != null) {
            this._toHeader.loadButtonLabel();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        if (this._toReorderUp != null) {
            this._toReorderUp.setEnabled(bl);
            this._toReorderDown.setEnabled(bl);
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setEnabled(bl);
            this._fromReorderDown.setEnabled(bl);
        }
        if (this._toReorderTop != null) {
            this._toReorderTop.setEnabled(bl);
            this._toReorderBottom.setEnabled(bl);
        }
        if (this._fromReorderTop != null) {
            this._fromReorderTop.setEnabled(bl);
            this._fromReorderBottom.setEnabled(bl);
        }
        Component[] componentArray2 = this._shuttleButtons.getComponents();
        int n2 = 0;
        while (n2 < componentArray2.length) {
            componentArray2[n2].setEnabled(bl);
            ++n2;
        }
        if (bl) {
            this._updateReorderButtonsEnabled(this._toPicker, null);
            if (this._fromPicker != null) {
                this._updateButtonsEnabled(this._fromPicker);
            }
            if (this._toPicker != null) {
                this._updateButtonsEnabled(this._toPicker);
            }
        }
    }

    public void removeAll() {
        if (this._shuttleButtons != null) {
            this._shuttleButtons.removeAll();
        }
        this._setFromPicker(null);
        this._setToPicker(null);
        super.removeAll();
    }

    public void setNextFocusableComponent(Component component) {
        super.setNextFocusableComponent(component);
        this._getLayout().updateFocusCycle();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleShuttle();
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        this.setUI((EWTShuttleUI)UIManager.getUI(this));
        EWTShuttleUI eWTShuttleUI = (EWTShuttleUI)this.ui;
        this._HORIZONTAL_BUTTON_LAYOUT = eWTShuttleUI.getHorizontalButtonLayout(this);
        this._VERTICAL_BUTTON_LAYOUT = eWTShuttleUI.getVerticalButtonLayout(this);
        if (this._horizontalLayout) {
            this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
        } else {
            this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
        }
        this._updateButtonContents();
        this._updateButtonMnemonics();
        this._updateButtonMargins();
        this._updateReorderContents();
        Color color = UIManager.getColor("control");
        if (this._toReorderUp != null) {
            this._toReorderUp.setBackground(color);
            this._toReorderDown.setBackground(color);
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setBackground(color);
            this._fromReorderDown.setBackground(color);
        }
        this._updateButtonFonts();
    }

    protected String paramString() {
        String string = super.paramString();
        string = string + ", mode=" + (this.getMode() == 0 ? "MOVE" : "COPY");
        string = string + ", horizontal=" + this.isHorizontalLayout();
        string = string + ", reverseLayout=" + this.isLayoutReversed();
        string = string + ", moveAllAllowed=" + this.isMoveAllAllowed();
        string = string + ", textLabels=" + this.getUseTextButtons();
        return string;
    }

    protected void validateTree() {
        super.validateTree();
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this._getLayout().updateFocusCycle();
        }
    }

    private void _updateButtonFonts() {
        Font font = this.getFont();
        if (font != null) {
            float f = font.getSize2D() - 2.0f;
            if (f < 10.0f) {
                f = Math.min(font.getSize2D(), 10.0f);
            }
            font = font.deriveFont(f);
            int n = 0;
            while (n < this._shuttleButtons.getComponentCount()) {
                this._shuttleButtons.getComponent(n).setFont(font);
                ++n;
            }
            if (this._toReorderUp != null) {
                this._toReorderUp.setFont(font);
                this._toReorderDown.setFont(font);
            }
            if (this._toReorderTop != null) {
                this._toReorderTop.setFont(font);
                this._toReorderBottom.setFont(font);
            }
            if (this._fromReorderUp != null) {
                this._fromReorderUp.setFont(font);
                this._fromReorderDown.setFont(font);
            }
            if (this._fromReorderTop != null) {
                this._fromReorderTop.setFont(font);
                this._fromReorderBottom.setFont(font);
            }
        }
    }

    private void _setFromPicker(ItemPicker itemPicker) {
        ItemPicker itemPicker2 = this._fromPicker;
        this._fromPicker = itemPicker;
        this._setPicker(itemPicker2, itemPicker, this._toPicker, false);
    }

    private void _setToPicker(ItemPicker itemPicker) {
        ItemPicker itemPicker2 = this._toPicker;
        this._toPicker = itemPicker;
        this._setPicker(itemPicker2, this._toPicker, this._fromPicker, true);
    }

    private void _setPicker(ItemPicker itemPicker, ItemPicker itemPicker2, ItemPicker itemPicker3, boolean bl) {
        if (itemPicker != itemPicker2) {
            boolean bl2;
            if (itemPicker != null) {
                itemPicker.removePropertyChangeListener(this._handler);
                itemPicker.removeActionListener(this._handler);
                bl2 = false;
                if (itemPicker instanceof Reorderable2) {
                    bl2 = !(itemPicker2 instanceof Reorderable2);
                } else if (itemPicker instanceof Reorderable) {
                    boolean bl3 = bl2 = itemPicker2 instanceof Reorderable2 || !(itemPicker2 instanceof Reorderable);
                }
                if (bl2) {
                    this._removeReorderControls(bl);
                }
            }
            if (itemPicker2 != null) {
                itemPicker2.addPropertyChangeListener(this._handler);
                itemPicker2.addActionListener(this._handler);
                bl2 = false;
                if (itemPicker2 instanceof Reorderable2) {
                    bl2 = !(itemPicker instanceof Reorderable2);
                } else if (itemPicker2 instanceof Reorderable) {
                    boolean bl4 = bl2 = itemPicker instanceof Reorderable2 || !(itemPicker instanceof Reorderable);
                }
                if (bl2) {
                    boolean bl5 = itemPicker2 instanceof Reorderable2;
                    this._createReorderControls(bl, bl5);
                    this._updateButtonsEnabled(itemPicker2);
                } else if (itemPicker2 instanceof Reorderable) {
                    this._updateReorderButtonsEnabled(itemPicker2, null);
                } else {
                    this._updateButtonsEnabled(itemPicker2);
                }
                if (itemPicker3 != null) {
                    this._updateButtonsEnabled(itemPicker3);
                }
            }
            this._createShuttleDnDSupport();
        }
    }

    private Component _getFromComponent() {
        return this._fromPicker != null ? this._fromPicker.getComponent() : null;
    }

    private Component _getToComponent() {
        return this._toPicker != null ? this._toPicker.getComponent() : null;
    }

    private Component _getShuttleControl() {
        return this._getLayout().getShuttleControl();
    }

    private ShuttleLayout _getLayout() {
        return (ShuttleLayout)this.getLayout();
    }

    private ShuttleLayout _createLayoutManager() {
        return new ShuttleLayout(this);
    }

    private JButton _createButton(String string) {
        JButton jButton = new JButton("");
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.addActionListener(this._handler);
        jButton.setMargin(this._getButtonMargin());
        Shuttle._setIconTextGap(jButton);
        jButton.setName(string);
        return jButton;
    }

    private Insets _getButtonMargin() {
        return UIManager.getInsets("EWTShuttleButton.margin");
    }

    private static void _setIconTextGap(AbstractButton abstractButton) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            if (_sIconGapMethod == null) {
                try {
                    _sIconGapMethod = (class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = Shuttle.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton).getMethod("setIconTextGap", Integer.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (_sIconGapMethod != null) {
                try {
                    _sIconGapMethod.invoke((Object)abstractButton, IntegerUtils.getInteger((int)0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void _updateButtonVisibility() {
        this._addAllButton.setVisible((this._buttonsShown & 2) != 0);
        this._removeAllButton.setVisible((this._buttonsShown & 8) != 0);
        this._addButton.setVisible((this._buttonsShown & 1) != 0);
        this._removeButton.setVisible((this._buttonsShown & 4) != 0);
        this._updateButtonFocus();
    }

    private void _updateButtonFocus() {
        int n = this._shuttleButtons.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this._shuttleButtons.getComponent(n2);
            if (component instanceof JComponent) {
                ((JComponent)component).setNextFocusableComponent(null);
            }
            ++n2;
        }
        this._getLayout().updateFocusCycle();
    }

    private void _loadButtonImage(JButton jButton, int n) {
        Image[] imageArray = _buttonImages;
        if (imageArray == null) {
            imageArray = new Image[8];
        }
        if (this._isActualLayoutReversed()) {
            n = (n + 2) % 4;
        }
        if (!this.isHorizontalLayout()) {
            n += 4;
        }
        EWTShuttleUI eWTShuttleUI = (EWTShuttleUI)this.ui;
        jButton.setIcon(eWTShuttleUI.getButtonIcon(this, n));
    }

    private void _updateButtonContents() {
        Object object;
        boolean bl = this.getMode() == 1;
        String[] stringArray = this._buttonLabels;
        if ((this._buttonMode & 2) != 0) {
            this._addButton.setText(StringUtils.stripMnemonic((String)(bl ? stringArray[4] : stringArray[0])));
            this._addAllButton.setText(StringUtils.stripMnemonic((String)(bl ? stringArray[5] : stringArray[1])));
            this._removeButton.setText(StringUtils.stripMnemonic((String)stringArray[2]));
            this._removeAllButton.setText(StringUtils.stripMnemonic((String)stringArray[3]));
            this._addButton.setToolTipText(null);
            this._removeButton.setToolTipText(null);
            this._addAllButton.setToolTipText(null);
            this._removeAllButton.setToolTipText(null);
        } else {
            this._addButton.setText(null);
            this._removeButton.setText(null);
            this._addAllButton.setText(null);
            this._removeAllButton.setText(null);
            this._updateButtonMnemonics();
            object = new String[2];
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
            String string = resourceBundle.getString(_BUTTON_TOOL_TIP_KEY);
            Object object2 = null;
            object[0] = StringUtils.stripMnemonic((String)(bl ? stringArray[4] : stringArray[0]));
            object[1] = this._getAcceleratorString(this._addButton.getMnemonic());
            object2 = "".equals(object[1]) ? object[0] : MessageFormat.format(string, (Object[])object);
            this._addButton.setToolTipText((String)object2);
            object[0] = StringUtils.stripMnemonic((String)(bl ? stringArray[5] : stringArray[1]));
            object[1] = this._getAcceleratorString(this._addAllButton.getMnemonic());
            object2 = "".equals(object[1]) ? object[0] : MessageFormat.format(string, (Object[])object);
            this._addAllButton.setToolTipText((String)object2);
            object[0] = StringUtils.stripMnemonic((String)stringArray[2]);
            object[1] = this._getAcceleratorString(this._removeButton.getMnemonic());
            object2 = "".equals(object[1]) ? object[0] : MessageFormat.format(string, (Object[])object);
            this._removeButton.setToolTipText((String)object2);
            object[0] = StringUtils.stripMnemonic((String)stringArray[3]);
            object[1] = this._getAcceleratorString(this._removeAllButton.getMnemonic());
            object2 = "".equals(object[1]) ? object[0] : MessageFormat.format(string, (Object[])object);
            this._removeAllButton.setToolTipText((String)object2);
        }
        if ((this._buttonMode & 1) != 0) {
            this._loadButtonImage(this._addButton, 0);
            this._loadButtonImage(this._removeButton, 2);
            this._loadButtonImage(this._addAllButton, 1);
            this._loadButtonImage(this._removeAllButton, 3);
        } else {
            this._addButton.setIcon(null);
            this._addAllButton.setIcon(null);
            this._removeButton.setIcon(null);
            this._removeAllButton.setIcon(null);
        }
        object = this._addButton.getAccessibleContext();
        ((AccessibleContext)object).setAccessibleName(StringUtils.stripMnemonic((String)(bl ? stringArray[4] : stringArray[0])));
        ((AccessibleContext)object).setAccessibleDescription(((AccessibleContext)object).getAccessibleName());
        object = this._addAllButton.getAccessibleContext();
        ((AccessibleContext)object).setAccessibleName(StringUtils.stripMnemonic((String)(bl ? stringArray[5] : stringArray[1])));
        ((AccessibleContext)object).setAccessibleDescription(((AccessibleContext)object).getAccessibleName());
        object = this._removeButton.getAccessibleContext();
        ((AccessibleContext)object).setAccessibleName(StringUtils.stripMnemonic((String)stringArray[2]));
        ((AccessibleContext)object).setAccessibleDescription(((AccessibleContext)object).getAccessibleName());
        object = this._removeAllButton.getAccessibleContext();
        ((AccessibleContext)object).setAccessibleName(StringUtils.stripMnemonic((String)stringArray[3]));
        ((AccessibleContext)object).setAccessibleDescription(((AccessibleContext)object).getAccessibleName());
    }

    private void _updateReorderContents() {
        AccessibleContext accessibleContext;
        int[] nArray;
        boolean bl;
        if (this._toReorderUp == null && this._fromReorderUp == null) {
            return;
        }
        EWTShuttleUI eWTShuttleUI = (EWTShuttleUI)this.ui;
        boolean bl2 = this._isActualLayoutReversed();
        Icon icon = null;
        Object[] objectArray = new String[2];
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
        String string = resourceBundle.getString(_BUTTON_TOOL_TIP_KEY);
        Object object = null;
        int n = this.getButtonDisplayMode();
        boolean bl3 = (n & 1) != 0;
        boolean bl4 = bl = (n & 2) != 0;
        if (this._buttonLabels == null) {
            this._loadCompatibleButtonLabels();
        }
        String string2 = StringUtils.stripMnemonic((String)this._buttonLabels[6]);
        String string3 = StringUtils.stripMnemonic((String)this._buttonLabels[7]);
        String string4 = null;
        String string5 = null;
        if (this._toReorderTop != null || this._fromReorderTop != null) {
            string4 = StringUtils.stripMnemonic((String)this._buttonLabels[8]);
            string5 = StringUtils.stripMnemonic((String)this._buttonLabels[9]);
        }
        if ((nArray = this._buttonMnemonics) == null) {
            nArray = this._getDefaultMnemonics();
        }
        if (this._toReorderUp != null) {
            this._toReorderUp.setMnemonic(nArray[6]);
            this._toReorderDown.setMnemonic(nArray[7]);
            accessibleContext = this._toReorderUp.getAccessibleContext();
            accessibleContext.setAccessibleName(string2);
            accessibleContext.setAccessibleDescription(string2);
            accessibleContext = this._toReorderDown.getAccessibleContext();
            accessibleContext.setAccessibleName(string3);
            accessibleContext.setAccessibleDescription(string3);
            if (bl3) {
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 10 : 8);
                this._toReorderUp.setIcon(icon);
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 11 : 9);
                this._toReorderDown.setIcon(icon);
            } else {
                this._toReorderUp.setIcon(null);
                this._toReorderDown.setIcon(null);
            }
            if (bl) {
                this._toReorderUp.setText(string2);
                this._toReorderDown.setText(string3);
                this._toReorderUp.setToolTipText(null);
                this._toReorderDown.setToolTipText(null);
            } else {
                this._toReorderUp.setText(null);
                this._toReorderDown.setText(null);
                objectArray[0] = string2;
                objectArray[1] = this._getAcceleratorString(this._toReorderUp.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._toReorderUp.setToolTipText((String)object);
                objectArray[0] = string3;
                objectArray[1] = this._getAcceleratorString(this._toReorderDown.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._toReorderDown.setToolTipText((String)object);
            }
        }
        if (this._toReorderTop != null) {
            this._toReorderTop.setMnemonic(nArray[8]);
            this._toReorderBottom.setMnemonic(nArray[9]);
            accessibleContext = this._toReorderTop.getAccessibleContext();
            accessibleContext.setAccessibleName(string4);
            accessibleContext.setAccessibleDescription(string4);
            accessibleContext = this._toReorderBottom.getAccessibleContext();
            accessibleContext.setAccessibleName(string5);
            accessibleContext.setAccessibleDescription(string5);
            if (bl3) {
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 14 : 12);
                this._toReorderTop.setIcon(icon);
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 15 : 13);
                this._toReorderBottom.setIcon(icon);
            } else {
                this._toReorderTop.setIcon(null);
                this._toReorderBottom.setIcon(null);
            }
            if (bl) {
                this._toReorderTop.setText(string4);
                this._toReorderBottom.setText(string5);
                this._toReorderTop.setToolTipText(null);
                this._toReorderBottom.setToolTipText(null);
            } else {
                this._toReorderTop.setText(null);
                this._toReorderBottom.setText(null);
                objectArray[0] = string4;
                objectArray[1] = this._getAcceleratorString(this._toReorderTop.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._toReorderTop.setToolTipText((String)object);
                objectArray[0] = string5;
                objectArray[1] = this._getAcceleratorString(this._toReorderBottom.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._toReorderBottom.setToolTipText((String)object);
            }
        }
        if (this._fromReorderUp != null) {
            if (this._toReorderUp == null) {
                this._fromReorderUp.setMnemonic(nArray[6]);
                this._fromReorderDown.setMnemonic(nArray[7]);
            } else {
                this._fromReorderUp.setMnemonic(0);
                this._fromReorderDown.setMnemonic(0);
            }
            accessibleContext = this._fromReorderUp.getAccessibleContext();
            accessibleContext.setAccessibleName(string2);
            accessibleContext.setAccessibleDescription(string2);
            accessibleContext = this._fromReorderDown.getAccessibleContext();
            accessibleContext.setAccessibleName(string3);
            accessibleContext.setAccessibleDescription(string3);
            if (bl3) {
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 8 : 10);
                this._fromReorderUp.setIcon(icon);
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 9 : 11);
                this._fromReorderDown.setIcon(icon);
            } else {
                this._fromReorderUp.setIcon(null);
                this._fromReorderDown.setIcon(null);
            }
            if (bl) {
                this._fromReorderUp.setText(string2);
                this._fromReorderDown.setText(string3);
                this._fromReorderUp.setToolTipText(null);
                this._fromReorderDown.setToolTipText(null);
            } else {
                this._fromReorderUp.setText(null);
                this._fromReorderDown.setText(null);
                objectArray[0] = string2;
                objectArray[1] = this._getAcceleratorString(this._fromReorderUp.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._fromReorderUp.setToolTipText((String)object);
                objectArray[0] = string3;
                objectArray[1] = this._getAcceleratorString(this._fromReorderDown.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._fromReorderDown.setToolTipText((String)object);
            }
        }
        if (this._fromReorderTop != null) {
            if (this._toReorderTop == null) {
                this._fromReorderTop.setMnemonic(nArray[8]);
                this._fromReorderBottom.setMnemonic(nArray[9]);
            } else {
                this._fromReorderTop.setMnemonic(0);
                this._fromReorderBottom.setMnemonic(0);
            }
            accessibleContext = this._fromReorderTop.getAccessibleContext();
            accessibleContext.setAccessibleName(string4);
            accessibleContext.setAccessibleDescription(string4);
            accessibleContext = this._fromReorderBottom.getAccessibleContext();
            accessibleContext.setAccessibleName(string5);
            accessibleContext.setAccessibleDescription(string5);
            if (bl3) {
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 12 : 14);
                this._fromReorderTop.setIcon(icon);
                icon = eWTShuttleUI.getButtonIcon(this, bl2 ? 13 : 15);
                this._fromReorderBottom.setIcon(icon);
            } else {
                this._fromReorderTop.setIcon(null);
                this._fromReorderBottom.setIcon(null);
            }
            if (bl) {
                this._fromReorderTop.setText(string4);
                this._fromReorderBottom.setText(string5);
                this._fromReorderTop.setToolTipText(null);
                this._fromReorderBottom.setToolTipText(null);
            } else {
                this._fromReorderTop.setText(null);
                this._fromReorderBottom.setText(null);
                objectArray[0] = string4;
                objectArray[1] = this._getAcceleratorString(this._fromReorderTop.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._fromReorderTop.setToolTipText((String)object);
                objectArray[0] = string5;
                objectArray[1] = this._getAcceleratorString(this._fromReorderBottom.getMnemonic());
                object = "".equals(objectArray[1]) ? objectArray[0] : MessageFormat.format(string, objectArray);
                this._fromReorderBottom.setToolTipText((String)object);
            }
        }
    }

    private void _updateButtonMargins() {
        Insets insets = this._getButtonMargin();
        this._addButton.setMargin(insets);
        this._removeButton.setMargin(insets);
        this._addAllButton.setMargin(insets);
        this._removeAllButton.setMargin(insets);
        if (this._toReorderUp != null) {
            this._toReorderUp.setMargin(insets);
            this._toReorderDown.setMargin(insets);
            if (this._toReorderTop != null) {
                this._toReorderTop.setMargin(insets);
                this._toReorderBottom.setMargin(insets);
            }
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setMargin(insets);
            this._fromReorderDown.setMargin(insets);
            if (this._fromReorderTop != null) {
                this._fromReorderTop.setMargin(insets);
                this._fromReorderBottom.setMargin(insets);
            }
        }
    }

    private boolean _isActualLayoutReversed() {
        return this._actualReversed;
    }

    void _setActualLayoutReversed(boolean bl) {
        if (this._actualReversed != bl) {
            this._actualReversed = bl;
            this._getLayout().setReverseLayout(bl);
            this._updateButtonContents();
            this._updateReorderContents();
            this.revalidate();
        }
    }

    private void _updateReorderButtonsEnabled(ItemPicker itemPicker, JButton jButton) {
        if (!(itemPicker instanceof Reorderable) || this._ignoreSelectionEvents) {
            return;
        }
        Reorderable reorderable = (Reorderable)((Object)itemPicker);
        if (reorderable == this._fromPicker) {
            this._update(reorderable, this._fromPicker, this._fromReorderUp, this._fromReorderDown, this._fromReorderTop, this._fromReorderBottom);
        } else {
            this._update(reorderable, this._toPicker, this._toReorderUp, this._toReorderDown, this._toReorderTop, this._toReorderBottom);
        }
    }

    private void _update(Reorderable reorderable, ItemPicker itemPicker, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        Object object;
        Component component;
        Component component2 = component = SwingUtilities.findFocusOwner(this);
        boolean bl = reorderable.isSelectionUpwardlyMobile();
        boolean bl2 = reorderable.isSelectionDownwardlyMobile();
        boolean bl3 = false;
        boolean bl4 = false;
        if (reorderable instanceof Reorderable2) {
            object = (Reorderable2)reorderable;
            bl3 = object.isSelectionTopMobile();
            bl4 = object.isSelectionBottomMobile();
        }
        if (component == jButton && !bl || jButton3 != null && component == jButton3 && !bl3) {
            component2 = bl2 ? jButton2 : ShuttleLayout.__getFocusableComponent(itemPicker.getComponent());
        } else if (component == jButton2 && !bl2 || jButton4 != null && component == jButton4 && !bl4) {
            component2 = bl ? jButton : ShuttleLayout.__getFocusableComponent(itemPicker.getComponent());
        }
        jButton.setEnabled(bl);
        jButton2.setEnabled(bl2);
        if (jButton3 != null) {
            jButton3.setEnabled(bl3);
        }
        if (jButton4 != null) {
            jButton4.setEnabled(bl4);
        }
        if (component == jButton3 || component == jButton4) {
            if (component2 != null) {
                object = component2;
                Runnable runnable = new Runnable((Component)object){
                    boolean _first = true;
                    private final /* synthetic */ Component val$temp;
                    {
                        this.val$temp = component;
                    }

                    public void run() {
                        this.val$temp.requestFocus();
                        if (this._first) {
                            this._first = false;
                            SwingUtilities.invokeLater(this);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else if (component != component2 && component2 != null) {
            component.requestFocus();
        }
    }

    private void _updateButtonsEnabled(ItemPicker itemPicker) {
        Object object;
        JButton jButton;
        JButton jButton2;
        if (this._ignoreSelectionEvents) {
            return;
        }
        if (itemPicker == this._fromPicker) {
            jButton2 = this._addButton;
            jButton = this._addAllButton;
        } else {
            jButton2 = this._removeButton;
            jButton = this._removeAllButton;
        }
        this._updateReorderButtonsEnabled(itemPicker, null);
        boolean bl = itemPicker.isSelectableItemPresent();
        boolean bl2 = itemPicker.isItemSelected();
        if (itemPicker == this._fromPicker && this._toPicker != null) {
            boolean bl3 = bl2;
            object = itemPicker.getSelectionDataFlavors();
            if (bl2 && object != null) {
                bl2 = this._toPicker.canAcceptFlavors((DataFlavor[])object);
            }
            if (bl && (bl2 || !bl3)) {
                if (object != null) {
                    bl = this._toPicker.canAcceptFlavors((DataFlavor[])object);
                }
            } else {
                bl = false;
            }
        }
        Component component = SwingUtilities.findFocusOwner(this);
        jButton.setEnabled(bl);
        jButton2.setEnabled(bl2);
        object = null;
        if (component == jButton2 && !bl2) {
            if (jButton2 == this._addButton) {
                if (this._toPicker != null) {
                    object = FocusUtils.getFirstFocusableComponent((Container)this._toPicker.getComponent());
                }
            } else if (jButton2 == this._removeButton && this._fromPicker != null) {
                object = FocusUtils.getFirstFocusableComponent((Container)this._fromPicker.getComponent());
            }
        } else if (component == jButton && !bl) {
            if (jButton == this._addAllButton) {
                if (this._toPicker != null) {
                    object = FocusUtils.getFirstFocusableComponent((Container)this._toPicker.getComponent());
                }
            } else if (jButton == this._removeAllButton && this._fromPicker != null) {
                object = FocusUtils.getFirstFocusableComponent((Container)this._fromPicker.getComponent());
            }
        }
        if (object != null) {
            DataFlavor[] dataFlavorArray = object;
            SwingUtilities.invokeLater(new Runnable((Component)dataFlavorArray){
                private final /* synthetic */ Component val$temp;
                {
                    this.val$temp = component;
                }

                public void run() {
                    this.val$temp.requestFocus();
                }
            });
        }
        this._updateButtonFocus();
    }

    private boolean _addItems() {
        boolean bl;
        ItemPicker itemPicker = this._fromPicker;
        ItemPicker itemPicker2 = this._toPicker;
        DataFlavor[] dataFlavorArray = itemPicker.getSelectionDataFlavors();
        boolean bl2 = bl = dataFlavorArray == null ? true : itemPicker2.canAcceptFlavors(dataFlavorArray);
        if (bl) {
            itemPicker2.deselectAll();
            boolean bl3 = itemPicker2.addSelectedItems(itemPicker.getSelectedItems());
            if (this._itemsUnique == 0 && bl3) {
                itemPicker.removeSelectedItems();
            }
            return true;
        }
        return false;
    }

    private boolean _removeItems() {
        ItemPicker itemPicker = this._fromPicker;
        ItemPicker itemPicker2 = this._toPicker;
        boolean bl = true;
        if (this._itemsUnique == 0) {
            bl = itemPicker.addSelectedItems(itemPicker2.getSelectedItems());
        }
        if (bl) {
            itemPicker2.removeSelectedItems();
            return true;
        }
        return false;
    }

    protected void processShuttleEvent(ShuttleEvent shuttleEvent) {
        Enumeration enumeration;
        int n = shuttleEvent.getID();
        ListenerManager listenerManager = this._shuttleListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ShuttleListener shuttleListener = (ShuttleListener)enumeration.nextElement();
                switch (n) {
                    case 2000: 
                    case 2001: 
                    case 2002: 
                    case 2003: {
                        shuttleListener.shuttleItemsMoved(shuttleEvent);
                        break;
                    }
                    case 2004: 
                    case 2005: {
                        shuttleListener.shuttleItemsRemoved(shuttleEvent);
                        break;
                    }
                    case 2006: 
                    case 2007: 
                    case 2008: 
                    case 2009: 
                    case 2010: {
                        shuttleListener.shuttleItemsReordered(shuttleEvent);
                        break;
                    }
                }
            }
        }
    }

    protected String[] getLocalizedLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, locale);
        String[] stringArray = new String[10];
        stringArray[0] = resourceBundle.getString(_MOVE_KEY);
        stringArray[2] = resourceBundle.getString(_REMOVE_KEY);
        stringArray[1] = resourceBundle.getString(_MOVE_ALL_KEY);
        stringArray[3] = resourceBundle.getString(_REMOVE_ALL_KEY);
        stringArray[4] = resourceBundle.getString(_COPY_KEY);
        stringArray[5] = resourceBundle.getString(_COPY_ALL_KEY);
        stringArray[6] = resourceBundle.getString(_REORDER_UP_KEY);
        stringArray[7] = resourceBundle.getString(_REORDER_DOWN_KEY);
        stringArray[8] = resourceBundle.getString(_REORDER_TOP_KEY);
        stringArray[9] = resourceBundle.getString(_REORDER_BOTTOM_KEY);
        return stringArray;
    }

    protected void initItemPickersSelection() {
        if (this._fromPicker instanceof ListPicker && !this._fromPicker.isItemSelected()) {
            ((ListPicker)this._fromPicker).__selectItem(0);
        }
    }

    private void _updateMnemonicsfromLabel(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (StringUtils.getMnemonicKeyCode((String)stringArray[n]) != 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            if (this._buttonMnemonics == null) {
                this._buttonMnemonics = new int[6];
            }
            this._buttonMnemonics[0] = StringUtils.getMnemonicKeyCode((String)stringArray[0]);
            this._buttonMnemonics[2] = StringUtils.getMnemonicKeyCode((String)stringArray[1]);
            this._buttonMnemonics[1] = StringUtils.getMnemonicKeyCode((String)stringArray[2]);
            this._buttonMnemonics[3] = StringUtils.getMnemonicKeyCode((String)stringArray[3]);
            this._buttonMnemonics[4] = StringUtils.getMnemonicKeyCode((String)stringArray[4]);
            this._buttonMnemonics[5] = StringUtils.getMnemonicKeyCode((String)stringArray[5]);
        }
    }

    private void _disposeReorderControls() {
        if (this._toReorderUp != null) {
            this._toReorderUp.removeActionListener(this._handler);
            this._toReorderUp.setModel(null);
            this._toReorderUp = null;
        }
        if (this._toReorderDown != null) {
            this._toReorderDown.removeActionListener(this._handler);
            this._toReorderDown.setModel(null);
            this._toReorderDown = null;
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.removeActionListener(this._handler);
            this._fromReorderUp.setModel(null);
            this._fromReorderUp = null;
        }
        if (this._fromReorderDown != null) {
            this._fromReorderDown.removeActionListener(this._handler);
            this._fromReorderDown.setModel(null);
            this._fromReorderDown = null;
        }
        if (this._toReorderTop != null) {
            this._toReorderTop.removeActionListener(this._handler);
            this._toReorderTop = null;
        }
        if (this._toReorderBottom != null) {
            this._toReorderBottom.removeActionListener(this._handler);
            this._toReorderBottom = null;
        }
        if (this._fromReorderTop != null) {
            this._fromReorderTop.removeActionListener(this._handler);
            this._fromReorderTop = null;
        }
        if (this._fromReorderBottom != null) {
            this._fromReorderBottom.removeActionListener(this._handler);
            this._fromReorderBottom = null;
        }
    }

    void __processMove() {
        this._processMove();
    }

    void __processRemove() {
        this._processRemove();
    }

    void __processDnDReorder(ItemPicker itemPicker) {
        this._ignoreSelectionEvents = true;
        ((ShuttleDnDSupport.ItemPickerDnD)((Object)itemPicker)).processDnDReorder();
        this.processShuttleEvent(new ShuttleEvent(this, 2010, itemPicker.getSelectedItems(), itemPicker));
        this._ignoreSelectionEvents = false;
        this._updateReorderButtonsEnabled(itemPicker, null);
    }

    private void _createReorderControls(boolean bl, boolean bl2) {
        Insets insets = this._getButtonMargin();
        JButton jButton = new JButton();
        jButton.setName(_UP_NAME);
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setMargin(insets);
        jButton.addActionListener(this._handler);
        jButton.setModel(new ShuttleButtonModel(jButton));
        Shuttle._setIconTextGap(jButton);
        JButton jButton2 = new JButton();
        jButton2.setName(_DOWN_NAME);
        jButton2.setHorizontalTextPosition(0);
        jButton2.setVerticalTextPosition(3);
        jButton2.setMargin(insets);
        jButton2.addActionListener(this._handler);
        jButton2.setModel(new ShuttleButtonModel(jButton2));
        Shuttle._setIconTextGap(jButton2);
        JPanel jPanel = new JPanel(_REORDER_LAYOUT);
        FocusUtils.setFocusable(jPanel, false);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addFocusListener(this._handler);
        jButton2.addFocusListener(this._handler);
        JButton jButton3 = null;
        JButton jButton4 = null;
        if (bl2) {
            jButton3 = new JButton();
            jButton3.setName(_TOP_NAME);
            jButton3.setHorizontalTextPosition(0);
            jButton3.setVerticalTextPosition(3);
            jButton3.setMargin(insets);
            jButton3.addActionListener(this._handler);
            jPanel.add((Component)jButton3, 0);
            Shuttle._setIconTextGap(jButton3);
            jButton4 = new JButton();
            jButton4.setName(_BOTTOM_NAME);
            jButton4.setHorizontalTextPosition(0);
            jButton4.setVerticalTextPosition(3);
            jButton4.setMargin(insets);
            jButton4.addActionListener(this._handler);
            jPanel.add(jButton4);
            Shuttle._setIconTextGap(jButton4);
        }
        if (bl) {
            this._toReorderUp = jButton;
            this._toReorderDown = jButton2;
            this._toReorderTop = jButton3;
            this._toReorderBottom = jButton4;
            this.add((Component)jPanel, "ToReorderControl");
        } else {
            this._fromReorderUp = jButton;
            this._fromReorderDown = jButton2;
            this._fromReorderTop = jButton3;
            this._fromReorderBottom = jButton4;
            this.add((Component)jPanel, "FromReorderControl");
        }
        this._updateReorderContents();
        this._updateReorderButtonsEnabled(bl ? this._toPicker : this._fromPicker, null);
        this._updateButtonFonts();
    }

    private void _removeReorderControls(boolean bl) {
        Container container = null;
        if (bl) {
            container = this._toReorderUp.getParent();
            this._toReorderDown = null;
            this._toReorderUp = null;
            this._toReorderBottom = null;
            this._toReorderTop = null;
        } else {
            container = this._fromReorderUp.getParent();
            this._fromReorderDown = null;
            this._fromReorderUp = null;
            this._fromReorderBottom = null;
            this._fromReorderTop = null;
        }
        this.remove(container);
        this._updateReorderContents();
    }

    private boolean _processMove() {
        boolean bl = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return bl;
        }
        if (this._fromPicker.isItemSelected()) {
            Transferable[] transferableArray = this._fromPicker.getSelectedItems();
            this._ignoreSelectionEvents = true;
            try {
                bl = this._addItems();
                Object var4_3 = null;
                this._ignoreSelectionEvents = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this._ignoreSelectionEvents = false;
                throw throwable;
            }
            if (bl) {
                if (this._itemsUnique == 0) {
                    this.processShuttleEvent(new ShuttleEvent(this, 2000, transferableArray));
                } else {
                    this.processShuttleEvent(new ShuttleEvent(this, 2002, transferableArray));
                }
            }
        }
        this._updateShuttleButtonsEnabled();
        return bl;
    }

    private boolean _processRemove() {
        boolean bl = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return bl;
        }
        if (this._toPicker.isItemSelected()) {
            Transferable[] transferableArray = this._toPicker.getSelectedItems();
            this._ignoreSelectionEvents = true;
            try {
                bl = this._removeItems();
                Object var4_3 = null;
                this._ignoreSelectionEvents = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this._ignoreSelectionEvents = false;
                throw throwable;
            }
            if (bl) {
                this.processShuttleEvent(new ShuttleEvent(this, 2004, transferableArray));
            }
        }
        this._updateShuttleButtonsEnabled();
        return bl;
    }

    private boolean _processMoveAll() {
        boolean bl;
        boolean bl2 = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return bl2;
        }
        DataFlavor[] dataFlavorArray = this._fromPicker.getSelectionDataFlavors();
        boolean bl3 = bl = dataFlavorArray == null ? true : this._toPicker.canAcceptFlavors(dataFlavorArray);
        if (bl) {
            this._toPicker.deselectAll();
            boolean bl4 = false;
            Transferable[] transferableArray = this._fromPicker.getAllSelectableItems();
            bl4 = this._toPicker.addSelectedItems(transferableArray);
            if (this._itemsUnique == 0 && bl4) {
                this._fromPicker.removeAllSelectableItems();
            }
            if (bl4) {
                bl2 = true;
            }
            if (this._itemsUnique == 0) {
                this.processShuttleEvent(new ShuttleEvent(this, 2001, transferableArray));
            } else {
                this.processShuttleEvent(new ShuttleEvent(this, 2003, transferableArray));
            }
        }
        this._updateShuttleButtonsEnabled();
        return bl2;
    }

    private boolean _processRemoveAll() {
        if (this._fromPicker == null || this._toPicker == null) {
            return false;
        }
        boolean bl = this._itemsUnique == 1;
        this._fromPicker.deselectAll();
        Transferable[] transferableArray = this._toPicker.getAllSelectableItems();
        if (this._itemsUnique == 0) {
            bl = this._fromPicker.addSelectedItems(transferableArray);
        }
        if (bl) {
            this._toPicker.removeAllSelectableItems();
        }
        this.processShuttleEvent(new ShuttleEvent(this, 2005, transferableArray));
        this._updateShuttleButtonsEnabled();
        return bl;
    }

    private void _updateShuttleButtonsEnabled() {
        this._updateButtonsEnabled(this._fromPicker);
        this._updateButtonsEnabled(this._toPicker);
    }

    private void _updateButtonMnemonics() {
        boolean bl;
        int[] nArray = this._buttonMnemonics;
        if (nArray == null) {
            nArray = this._getDefaultMnemonics();
        }
        boolean bl2 = bl = (this.getMode() & 1) != 0;
        if (bl) {
            this._addButton.setMnemonic(nArray[4]);
            this._addAllButton.setMnemonic(nArray[5]);
        } else {
            this._addButton.setMnemonic(nArray[0]);
            this._addAllButton.setMnemonic(nArray[1]);
        }
        this._removeButton.setMnemonic(nArray[2]);
        this._removeAllButton.setMnemonic(nArray[3]);
    }

    private int[] _getDefaultMnemonics() {
        int n;
        boolean bl;
        String string = _MOVE_KEY;
        String string2 = _MOVE_ALL_KEY;
        int n2 = 0;
        int n3 = 1;
        boolean bl2 = bl = (this.getMode() & 1) != 0;
        if (bl) {
            string = _COPY_KEY;
            string2 = _COPY_ALL_KEY;
            n2 = 4;
            n3 = 5;
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, locale);
        String[] stringArray = new String[]{resourceBundle.getString(string), resourceBundle.getString(string2), resourceBundle.getString(_REMOVE_KEY), resourceBundle.getString(_REMOVE_ALL_KEY), resourceBundle.getString(_REORDER_UP_KEY), resourceBundle.getString(_REORDER_DOWN_KEY), resourceBundle.getString(_REORDER_TOP_KEY), resourceBundle.getString(_REORDER_BOTTOM_KEY)};
        if (this._buttonLabels == null) {
            this._loadCompatibleButtonLabels();
        }
        int[] nArray = new int[10];
        if (stringArray[0].equals(this._buttonLabels[n2]) && stringArray[1].equals(this._buttonLabels[n3]) && stringArray[2].equals(this._buttonLabels[2]) && stringArray[3].equals(this._buttonLabels[3])) {
            nArray[n2] = StringUtils.getMnemonicKeyCode((String)stringArray[0]);
            nArray[n3] = StringUtils.getMnemonicKeyCode((String)stringArray[1]);
            nArray[2] = StringUtils.getMnemonicKeyCode((String)stringArray[2]);
            nArray[3] = StringUtils.getMnemonicKeyCode((String)stringArray[3]);
            if (bl) {
                nArray[0] = 0;
                nArray[1] = 0;
            } else {
                nArray[4] = 0;
                nArray[5] = 0;
            }
        } else {
            n = 0;
            while (n < 6) {
                nArray[n] = 0;
                ++n;
            }
        }
        if (stringArray[4].equals(this._buttonLabels[6]) && stringArray[5].equals(this._buttonLabels[7]) && stringArray[6].equals(this._buttonLabels[8]) && stringArray[7].equals(this._buttonLabels[9])) {
            nArray[6] = StringUtils.getMnemonicKeyCode((String)stringArray[4]);
            nArray[7] = StringUtils.getMnemonicKeyCode((String)stringArray[5]);
            nArray[8] = StringUtils.getMnemonicKeyCode((String)stringArray[6]);
            nArray[9] = StringUtils.getMnemonicKeyCode((String)stringArray[7]);
        } else {
            n = 6;
            while (n <= 9) {
                nArray[n] = 0;
                ++n;
            }
        }
        return nArray;
    }

    private String _getAcceleratorString(int n) {
        if (n != 0) {
            Object object;
            if (FocusUtils.areNewFocusAPIsAvailable() ? Boolean.FALSE.equals(UIManager.get("ToolTip.hideAccelerator")) : (object = UIManager.get("Shuttle.ShowAcclInToolTip")) == null || Boolean.FALSE.equals(object)) {
                return "";
            }
            object = UIManager.getString("MenuItem.acceleratorDelimiter");
            if (object == null) {
                object = "+";
            }
            int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? 2 : 8;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            return KeyEvent.getKeyModifiersText(n2).toUpperCase(locale) + (String)object + KeyEvent.getKeyText(n).toUpperCase(locale);
        }
        return "";
    }

    private void _loadCompatibleButtonLabels() {
        String[] stringArray = this.getLocalizedLabels(LocaleUtils.getDefaultableLocale((Component)this));
        if (stringArray.length == 8) {
            String[] stringArray2 = new String[10];
            System.arraycopy(stringArray, 0, stringArray2, 0, 8);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
            stringArray2[8] = resourceBundle.getString(_REORDER_TOP_KEY);
            stringArray2[9] = resourceBundle.getString(_REORDER_BOTTOM_KEY);
            stringArray = stringArray2;
        }
        if (stringArray.length < 10) {
            throw new IllegalArgumentException("Should provide 10 button labels");
        }
        this._buttonLabels = stringArray;
    }

    private boolean _updateFooterVisiblity(Component component, boolean bl) {
        Component component2;
        boolean bl2 = !bl;
        boolean bl3 = false;
        if (component == this.getComponent(COMMON_FOOTER_COMPONENT)) {
            Component component3 = this.getComponent(FROM_FOOTER_COMPONENT);
            if (component3 != null) {
                component3.setVisible(bl2);
                bl3 = true;
            }
            if ((component3 = this.getComponent(TO_FOOTER_COMPONENT)) != null) {
                component3.setVisible(bl2);
                bl3 = true;
            }
        } else if ((component == this.getComponent(FROM_FOOTER_COMPONENT) || component == this.getComponent(TO_FOOTER_COMPONENT)) && (component2 = this.getComponent(COMMON_FOOTER_COMPONENT)) != null) {
            if (bl) {
                component2.setVisible(bl2);
                bl3 = true;
                component2 = this.getComponent(FROM_FOOTER_COMPONENT);
                if (component2 != null) {
                    component2.setVisible(true);
                }
                if ((component2 = this.getComponent(TO_FOOTER_COMPONENT)) != null) {
                    component2.setVisible(true);
                }
            } else if (component.isVisible()) {
                Component component4 = this.getComponent(FROM_FOOTER_COMPONENT);
                Component component5 = this.getComponent(TO_FOOTER_COMPONENT);
                component2.setVisible(!(component4 != component && component4 != null || component5 != component && component5 != null));
                bl3 = true;
            }
        }
        return bl3;
    }

    private void _createShuttleDnDSupport() {
        if (this._shuttleDnDSupport != null) {
            this._shuttleDnDSupport.dispose();
        }
        boolean bl = this._fromPicker instanceof ShuttleDnDSupport.ItemPickerDnD;
        boolean bl2 = this._toPicker instanceof ShuttleDnDSupport.ItemPickerDnD;
        if (bl && bl2 || bl && this._fromPicker instanceof Reorderable || bl2 && this._toPicker instanceof Reorderable) {
            this._shuttleDnDSupport = new ShuttleDnDSupport(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int[] access$002(Shuttle shuttle, int[] nArray) {
        shuttle._actionMap = nArray;
        return nArray;
    }

    static {
        _REORDER_LAYOUT = new EqualColumnLayout(3);
    }

    private class Header
    extends JPanel {
        private JLabel _defHeader;
        private Component _userHeader;
        private boolean _isFromHeader;
        private ItemPicker _itemPicker;

        public Header(ItemPicker itemPicker, Component component, boolean bl) {
            this.setLayout(new BorderLayout());
            this._isFromHeader = bl;
            this.setHeader(component);
            this.setItemPicker(itemPicker);
        }

        public void setItemPicker(ItemPicker itemPicker) {
            this._itemPicker = itemPicker;
            if (this._defHeader != null && this._userHeader == null) {
                if (this._itemPicker != null) {
                    this._defHeader.setLabelFor(this._getFirstFocusableComponent(this._itemPicker.getComponent()));
                } else {
                    this._defHeader.setLabelFor(null);
                }
            }
        }

        public void setHeader(Component component) {
            this._userHeader = component;
            if (this._userHeader == null) {
                if (this._defHeader == null) {
                    this._defHeader = new JLabel();
                    this.loadButtonLabel();
                }
                this.removeAll();
                this.add(this._defHeader);
                if (this._itemPicker != null) {
                    this._defHeader.setLabelFor(this._getFirstFocusableComponent(this._itemPicker.getComponent()));
                }
            } else {
                if (this._defHeader != null) {
                    Component component2 = null;
                    Object object = null;
                    if (this._itemPicker != null && (component2 = this._defHeader.getLabelFor()) instanceof JComponent) {
                        object = ((JComponent)component2).getClientProperty(Shuttle._LABELED_BY);
                    }
                    this._defHeader.setLabelFor(null);
                    if (object != null && object != this._defHeader) {
                        ((JComponent)component2).putClientProperty(Shuttle._LABELED_BY, object);
                    }
                }
                this.removeAll();
                this.add(component);
            }
            this.revalidate();
        }

        public Component getUserHeader() {
            return this._userHeader;
        }

        public void loadButtonLabel() {
            if (this._defHeader != null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(Shuttle._RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
                String string = resourceBundle.getString(this._isFromHeader ? "SHUTTLE.FROM_HEADER" : "SHUTTLE.TO_HEADER");
                this._defHeader.setText(StringUtils.stripMnemonic((String)string));
                this._defHeader.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            }
        }

        public Insets getInsets() {
            return this.getUserHeader() == null ? new Insets(0, 0, 5, 0) : super.getInsets();
        }

        private Component _getFirstFocusableComponent(Component component) {
            if (FocusUtils.isFocusable(component)) {
                return component;
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = 0;
                int n2 = container.getComponentCount();
                while (n < n2) {
                    Component component2 = this._getFirstFocusableComponent(container.getComponent(n));
                    if (component2 != null) {
                        return component2;
                    }
                    ++n;
                }
            }
            return null;
        }
    }

    private class ShuttleButtonModel
    extends ContinuousButtonModel {
        public ShuttleButtonModel(AbstractButton abstractButton) {
            super(abstractButton);
        }

        protected void processPulse() {
            Reorderable reorderable;
            AbstractButton abstractButton = this.getButton();
            if (abstractButton == Shuttle.this._toReorderUp) {
                Reorderable reorderable2 = (Reorderable)((Object)Shuttle.this._toPicker);
                if (reorderable2.isSelectionUpwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reorderable2.moveSelectionUp();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, Shuttle.this._toReorderUp);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (abstractButton == Shuttle.this._toReorderDown) {
                Reorderable reorderable3 = (Reorderable)((Object)Shuttle.this._toPicker);
                if (reorderable3.isSelectionDownwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reorderable3.moveSelectionDown();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, Shuttle.this._toReorderDown);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (abstractButton == Shuttle.this._fromReorderUp) {
                Reorderable reorderable4 = (Reorderable)((Object)Shuttle.this._fromPicker);
                if (reorderable4.isSelectionUpwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reorderable4.moveSelectionUp();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, Shuttle.this._fromReorderUp);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (abstractButton == Shuttle.this._fromReorderDown && (reorderable = (Reorderable)((Object)Shuttle.this._fromPicker)).isSelectionDownwardlyMobile()) {
                Shuttle.this._ignoreSelectionEvents = true;
                try {
                    reorderable.moveSelectionDown();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                    Object var10_15 = null;
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    Shuttle.this._ignoreSelectionEvents = false;
                    throw throwable;
                }
                Shuttle.this._ignoreSelectionEvents = false;
                Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, Shuttle.this._fromReorderDown);
                Shuttle.this._updateButtonFocus();
            }
        }
    }

    class ShuttleHandler
    implements ActionListener,
    PropertyChangeListener,
    FocusListener {
        ShuttleHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ItemPicker itemPicker = Shuttle.this._fromPicker;
            ItemPicker itemPicker2 = Shuttle.this._toPicker;
            if (actionEvent.getSource() instanceof ItemPicker) {
                ItemPicker itemPicker3 = (ItemPicker)actionEvent.getSource();
                if (itemPicker3 == itemPicker) {
                    Shuttle.this._processMove();
                } else if (itemPicker3 == itemPicker2) {
                    Shuttle.this._processRemove();
                }
            } else if (actionEvent.getSource() instanceof Component) {
                Component component = (Component)actionEvent.getSource();
                if (component == Shuttle.this._addButton) {
                    Shuttle.this._processMove();
                } else if (component == Shuttle.this._addAllButton) {
                    Shuttle.this._processMoveAll();
                } else if (component == Shuttle.this._removeButton) {
                    Shuttle.this._processRemove();
                } else if (component == Shuttle.this._removeAllButton) {
                    Shuttle.this._processRemoveAll();
                } else if (component == Shuttle.this._toReorderTop) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._toPicker)).moveSelectionTop();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2008, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, null);
                } else if (component == Shuttle.this._fromReorderTop) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._fromPicker)).moveSelectionTop();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2008, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, null);
                } else if (component == Shuttle.this._toReorderBottom) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._toPicker)).moveSelectionBottom();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2009, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                        Object var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, null);
                } else if (component == Shuttle.this._fromReorderBottom) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._fromPicker)).moveSelectionBottom();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2009, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                        Object var12_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, null);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "selection") {
                Shuttle.this._updateButtonsEnabled((ItemPicker)propertyChangeEvent.getSource());
            } else if (propertyChangeEvent.getSource() == Shuttle.this && "ancestor".equals(string) && propertyChangeEvent.getNewValue() != null && Shuttle.this.isVisible()) {
                Shuttle.this._ignoreSelectionEvents = !Shuttle.this.isEnabled();
                Shuttle.this.initItemPickersSelection();
                Shuttle.this._ignoreSelectionEvents = false;
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (!component.isEnabled()) {
                if (component == Shuttle.this._fromReorderUp) {
                    Shuttle.this._fromReorderDown.requestFocus();
                } else if (component == Shuttle.this._fromReorderDown) {
                    Shuttle.this._fromReorderUp.requestFocus();
                } else if (component == Shuttle.this._toReorderUp) {
                    Shuttle.this._toReorderDown.requestFocus();
                } else if (component == Shuttle.this._toReorderDown) {
                    Shuttle.this._toReorderUp.requestFocus();
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class AccessibleShuttle
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        protected AccessibleShuttle() {
            super(Shuttle.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Shuttle.this.isHorizontalLayout()) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            if (Shuttle.this._actionMap == null) {
                boolean bl = Shuttle.this.isMoveAllowed();
                boolean bl2 = Shuttle.this.isMoveAllAllowed();
                int n = 0;
                if (bl) {
                    n += 2;
                }
                if (bl2) {
                    n += 2;
                }
                Shuttle.access$002(Shuttle.this, new int[n]);
                int n2 = 0;
                if (bl) {
                    ((Shuttle)Shuttle.this)._actionMap[n2] = 0;
                    ((Shuttle)Shuttle.this)._actionMap[n2 + 1] = 2;
                    n2 += 2;
                }
                if (bl2) {
                    ((Shuttle)Shuttle.this)._actionMap[n2] = 1;
                    ((Shuttle)Shuttle.this)._actionMap[n2 + 1] = 3;
                }
            }
            return Shuttle.this._actionMap.length;
        }

        public String getAccessibleActionDescription(int n) {
            if (Shuttle.this._buttonLabels == null) {
                Shuttle.this._loadCompatibleButtonLabels();
            }
            return Shuttle.this._buttonLabels[Shuttle.this._actionMap[n]];
        }

        public boolean doAccessibleAction(int n) {
            boolean bl = false;
            int n2 = Shuttle.this._actionMap[n];
            if (n2 == 0) {
                bl = Shuttle.this._processMove();
            } else if (n2 == 2) {
                bl = Shuttle.this._processRemove();
            } else if (n2 == 1) {
                bl = Shuttle.this._processMoveAll();
            } else if (n2 == 3) {
                bl = Shuttle.this._processRemoveAll();
            }
            return bl;
        }
    }
}

