/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.WrappingNumericSpinBoxModel;
import oracle.bali.share.collection.Range;

public class ArraySpinBoxModel
implements SpinBoxModel {
    private Object[] _array;
    private NumericSpinBoxModel _numeric;
    private boolean _wrap;

    public ArraySpinBoxModel(Object[] objectArray, boolean bl) {
        this._array = objectArray;
        this._wrap = bl;
        Range range = new Range(0, objectArray.length - 1);
        this._numeric = bl ? new WrappingNumericSpinBoxModel(range) : new NumericSpinBoxModel(range);
    }

    public Object[] getArray() {
        return this._array;
    }

    public boolean isWrapping() {
        return this._wrap;
    }

    public void setIndex(int n) {
        if (n < 0 || n >= this._array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._numeric.setValue(n);
    }

    public int getIndex() {
        return this._numeric.getValue();
    }

    public Object nextElement() {
        return this._array[(Integer)this._numeric.nextElement()];
    }

    public void setIteratingForward(boolean bl) {
        this._numeric.setIteratingForward(bl);
    }

    public boolean isIteratingForward() {
        return this._numeric.isIteratingForward();
    }

    public boolean hasMoreElements() {
        return this._numeric.hasMoreElements();
    }

    public Object skip(int n) {
        return this._array[(Integer)this._numeric.skip(n)];
    }

    public int remainingElements(int n) {
        return this._numeric.remainingElements(n);
    }
}

