/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.statusBar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;
import oracle.bali.ewt.elaf.EWTStatusBarUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class StatusBar
extends LWComponent
implements Accessible {
    private int _lastWidth = -1;
    private int _lastHeight = -1;
    private int _lastFillWidth;
    private int _itemSplitWidth;
    private int _leftCandidate;
    private int _rightCandidate;
    private int _resizeLeft;
    private int _resizeRight;
    private int _resizer;
    private int _dragX;
    private boolean _direction;
    private boolean _canResize;
    private boolean _firstLayout = true;
    private Cursor _savedCursor;
    private boolean _foregroundDefaulted = true;
    private int _ITEM_SPACING;
    private static final int _MINIMUM_WIDTH = 10;
    private static final Object _MIN_WIDTH_KEY = new Object();
    private static final Object _EXPANDING_KEY = new Object();

    public StatusBar() {
        this(4);
    }

    public StatusBar(int n) {
        this.updateUI();
        long l = 48L;
        this.enableEvents(l);
        this._canResize = true;
        this.setLayout(new StatusBarLayout());
    }

    public final JLabel add(String string) {
        return (JLabel)this.add(new JLabel(string));
    }

    public final JLabel add(String string, int n) {
        return (JLabel)this.add((Component)new JLabel(string), n);
    }

    public final JLabel add(Icon icon) {
        return (JLabel)this.add(new JLabel(icon));
    }

    public final JLabel add(Icon icon, int n) {
        return (JLabel)this.add((Component)new JLabel(icon), n);
    }

    protected void addImpl(Component component, Object object, int n) {
        Component component2;
        this._installBorder(component);
        if (object != null && object instanceof Component && (component2 = (Component)object).getParent() == this) {
            n = this.getComponentIndex(component2);
        }
        super.addImpl(component, object, n);
        this._lastHeight = -1;
        this._lastWidth = -1;
        this._firstLayout = true;
        if (component.isVisible()) {
            this.revalidate();
        }
    }

    public int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (component == componentArray[n]) {
                return n;
            }
            ++n;
        }
        throw new IndexOutOfBoundsException();
    }

    public void remove(int n) {
        this._uninstallBorder(this.getComponent(n));
        super.remove(n);
        this._lastHeight = -1;
        this._lastWidth = -1;
        this._firstLayout = true;
        this.revalidate();
    }

    public String getUIClassID() {
        return "EWTStatusBarUI";
    }

    public void setItemResizeAllowed(boolean bl) {
        if (bl != this._canResize) {
            this._itemSplitWidth = bl ? this._getSplitterWidth() : 0;
            this._canResize = bl;
            this._lastHeight = -1;
            this._lastWidth = -1;
            this.revalidate();
        }
    }

    public boolean isItemResizeAllowed() {
        return this._canResize;
    }

    public boolean isExpandable(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (component instanceof JComponent) {
            Object object = ((JComponent)component).getClientProperty(_EXPANDING_KEY);
            return object != null;
        }
        return false;
    }

    public void setExpandable(JComponent jComponent, boolean bl) {
        if (jComponent == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            jComponent.putClientProperty(_EXPANDING_KEY, _EXPANDING_KEY);
        } else {
            jComponent.putClientProperty(_EXPANDING_KEY, null);
        }
        if (jComponent.getParent() == this) {
            this._lastHeight = -1;
            this._lastWidth = -1;
            this.revalidate();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].setEnabled(bl);
                ++n;
            }
            super.setEnabled(bl);
            this.repaint();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStatusBar();
        }
        return this.accessibleContext;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getComponentCount() == 0) {
            return;
        }
        if (!this.isItemResizeAllowed()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 506: {
                this._handleMouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this._handleMouseMoved(mouseEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getComponentCount() == 0) {
            return;
        }
        if (!this.isItemResizeAllowed()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this._handleMousePressed(mouseEvent);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent);
            }
            case 505: {
                this._handleMouseExited(mouseEvent);
            }
        }
    }

    public void updateUI() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this._uninstallBorder(componentArray[n]);
            ++n;
        }
        this.setUI(UIManager.getUI(this));
        int n2 = 0;
        while (n2 < componentArray.length) {
            this._installBorder(componentArray[n2]);
            ++n2;
        }
        this._itemSplitWidth = this._getSplitterWidth();
        this._ITEM_SPACING = this.getEWTStatusBarUI().getItemSpacing(this);
    }

    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (object == EWTStatusBarUI.RESIZABLE_SPLITTERS_KEY) {
            object2 = this._getSplitters(true);
        } else if (object == EWTStatusBarUI.NONRESIZABLE_SPLITTERS_KEY) {
            object2 = this._getSplitters(false);
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getComponentCount();
        if (n == 0) {
            return;
        }
        Component[] componentArray = this.getComponents();
        if (this._firstLayout) {
            this.doLayout();
        }
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n2 = this.getActualReadingDirection();
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = this.isItemResizeAllowed();
        int n3 = n2 == 2 ? -this._ITEM_SPACING - this._itemSplitWidth : this._ITEM_SPACING;
        Component component = componentArray[0];
        boolean bl2 = bl && this.isExpandable(component) && n > 1;
        int n4 = 0;
        PaintContext paintContext = this.getPaintContext();
        while (component != null) {
            Component component2 = component;
            boolean bl3 = bl2;
            if (++n4 < n) {
                component = componentArray[n4];
                bl2 = bl && this.isExpandable(component);
            } else {
                component = null;
                bl2 = false;
            }
            Rectangle rectangle2 = component2.getBounds();
            if (!rectangle2.intersects(rectangle)) continue;
            EWTStatusBarUI eWTStatusBarUI = this.getEWTStatusBarUI();
            Painter painter = component == null ? null : (bl3 ? (bl2 ? eWTStatusBarUI.getCenterSplitterPainter(this) : (n2 != 2 ? eWTStatusBarUI.getLeftSplitterPainter(this) : eWTStatusBarUI.getRightSplitterPainter(this))) : eWTStatusBarUI.getStaticSplitterPainter(this));
            if (painter == null) continue;
            int n5 = rectangle2.x + n3;
            if (n2 != 2) {
                n5 += rectangle2.width;
            }
            graphics.setColor(paintContext.getPaintBackground());
            graphics.fillRect(n5 - n3, insets.top, this._itemSplitWidth + n3 * 2, dimension.height - (insets.top + insets.bottom));
            painter.paint(paintContext, graphics, n5, 0, this._itemSplitWidth, dimension.height);
        }
    }

    protected final EWTStatusBarUI getEWTStatusBarUI() {
        return (EWTStatusBarUI)this.ui;
    }

    private void _recalculateSlides(int n, int n2) {
        int n3;
        Component component;
        int n4;
        int n5 = this.getActualReadingDirection();
        Component[] componentArray = this.getComponents();
        int n6 = componentArray.length;
        if (n > -1) {
            this._resizeLeft = 0;
            this._leftCandidate = -1;
            n4 = n;
            while (n4 >= 0) {
                component = componentArray[n4];
                if (this.isExpandable(component) && (n3 = component.getSize().width - component.getMinimumSize().width) > 0) {
                    this._resizeLeft = n3;
                    this._leftCandidate = n4;
                    break;
                }
                --n4;
            }
            if (this._leftCandidate < 0) {
                this._leftCandidate = this._resizer;
            }
        }
        if (n2 > -1) {
            this._resizeRight = 0;
            this._rightCandidate = -1;
            n4 = n2 + 1;
            while (n4 < n6) {
                component = componentArray[n4];
                if (this.isExpandable(component) && (n3 = component.getSize().width - component.getMinimumSize().width) > 0) {
                    this._resizeRight = n3;
                    this._rightCandidate = n4;
                    break;
                }
                ++n4;
            }
            if (this._rightCandidate == -1) {
                component = componentArray[n6 - 1];
                n3 = component.getMinimumSize().width;
                this._resizeRight = n5 == 2 ? component.getSize().width - n3 : this.getSize().width - this.getInsets().right - (component.getLocation().x + n3);
                this._rightCandidate = n6 - 1;
            }
        }
    }

    private void _handleMousePressed(MouseEvent mouseEvent) {
        Insets insets = this.getInsets();
        int n = mouseEvent.getX();
        this._resizer = this._getResizeCandidate(n);
        this._recalculateSlides(this._resizer, this._resizer);
        this._dragX = n;
        this._direction = true;
    }

    private void _handleMouseReleased(MouseEvent mouseEvent) {
        this._rightCandidate = -1;
        this._leftCandidate = -1;
        this._resizer = -1;
        this._dragX = 0;
        this._resizeRight = 0;
        this._resizeLeft = 0;
    }

    private void _handleMouseExited(MouseEvent mouseEvent) {
        this._restoreCursor();
    }

    private void _handleMouseDragged(MouseEvent mouseEvent) {
        Serializable serializable;
        int n;
        int n2;
        if (this._leftCandidate < 0 && this._rightCandidate < 0 || this._resizer < 0) {
            return;
        }
        int n3 = this.getActualReadingDirection();
        int n4 = this._leftCandidate;
        int n5 = this._rightCandidate;
        Component[] componentArray = this.getComponents();
        int n6 = componentArray.length;
        int n7 = mouseEvent.getX();
        Component component = n4 >= 0 ? componentArray[n4] : null;
        Component component2 = n5 >= 0 ? componentArray[n5] : null;
        Component component3 = componentArray[this._resizer];
        int n8 = -1;
        int n9 = -1;
        int n10 = n2 = n3 == 2 ? this._dragX - n7 : n7 - this._dragX;
        if (n2 <= 0) {
            if (this._direction) {
                int n11 = n6 - 1;
                n = this._resizer + 1;
                while (n < n6 - 1) {
                    if (this.isExpandable(componentArray[n])) {
                        n11 = n;
                        break;
                    }
                    ++n;
                }
                n5 = n11;
                serializable = componentArray[n11];
                this._resizeRight = serializable.getSize().width - serializable.getMinimumSize().width;
                component2 = serializable;
                n5 = this._rightCandidate = n11;
            }
            if (this._resizeLeft < -n2) {
                n10 = -this._resizeLeft;
                n8 = n4 - 1;
            }
            if (n10 != 0) {
                Dimension dimension = component.getSize();
                component.setSize(dimension.width + n10, dimension.height);
                if (n3 == 2) {
                    n = n4;
                    while (n < n5) {
                        serializable = componentArray[n].getLocation();
                        componentArray[n].setLocation(((Point)serializable).x - n10, ((Point)serializable).y);
                        ++n;
                    }
                } else {
                    n = n5;
                    while (n > n4) {
                        serializable = componentArray[n].getLocation();
                        componentArray[n].setLocation(((Point)serializable).x + n10, ((Point)serializable).y);
                        --n;
                    }
                }
            }
        } else if (n2 > 0) {
            if (!this._direction) {
                n8 = this._resizer;
            }
            if (this._resizeRight < n2) {
                n10 = this._resizeRight;
                n9 = n5 + 1;
            }
            Dimension dimension = component3.getSize();
            component3.setSize(dimension.width + n10, dimension.height);
            if (n3 == 2) {
                n = n5 - 1;
                while (n >= this._resizer) {
                    serializable = componentArray[n].getLocation();
                    componentArray[n].setLocation(((Point)serializable).x - n10, ((Point)serializable).y);
                    --n;
                }
            } else {
                n = this._resizer + 1;
                while (n <= n5) {
                    serializable = componentArray[n].getLocation();
                    componentArray[n].setLocation(((Point)serializable).x + n10, ((Point)serializable).y);
                    ++n;
                }
            }
        }
        Dimension dimension = component2.getSize();
        component2.setSize(dimension.width - n10, dimension.height);
        this._resizeLeft += n10;
        this._resizeRight -= n10;
        n = 0;
        int n12 = 0;
        if (n3 == 2) {
            n = componentArray[n5].getLocation().x;
            n12 = componentArray[n4].getLocation().x + componentArray[n4].getSize().width;
        } else {
            n = componentArray[n4].getLocation().x;
            n12 = componentArray[n5].getLocation().x + componentArray[n5].getSize().width;
        }
        int n13 = this.getSize().height;
        int n14 = this.getInsets().left;
        this.paintImmediately(n + n14, 0, n12 + n14, n13);
        if (n8 > -1 || n9 > -1) {
            this._recalculateSlides(n8, n9);
        }
        if (n10 != 0) {
            this._dragX += n3 == 2 ? -n10 : n10;
        }
        this._direction = n2 > 0;
    }

    private void _handleMouseMoved(MouseEvent mouseEvent) {
        Insets insets = this.getInsets();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._getResizeCandidate(n) < 0) {
            this._restoreCursor();
        } else {
            int n3 = this.getActualReadingDirection();
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Component[] componentArray = this.getComponents();
            int n4 = componentArray.length;
            if (n3 == 2) {
                int n5 = componentArray[n4 - 1].getLocation().x;
                if (!rectangle.contains(n, n2) || n < n5) {
                    return;
                }
            } else {
                int n6 = componentArray[n4 - 1].getLocation().x + componentArray[n4 - 1].getSize().width;
                if (!rectangle.contains(n, n2) || n >= n6) {
                    return;
                }
            }
            this._showResizeCursor();
        }
    }

    private int _getResizeCandidate(int n) {
        int n2 = 0;
        int n3 = this.getComponentCount();
        if (n3 < 2) {
            return -1;
        }
        Component[] componentArray = this.getComponents();
        int n4 = this.getActualReadingDirection();
        if (n4 == 2) {
            int n5 = 1;
            while (n5 < n3) {
                Rectangle rectangle = componentArray[n5].getBounds();
                n2 = rectangle.x + rectangle.width;
                if (n2 < n) {
                    Component component = componentArray[n5 - 1];
                    rectangle = componentArray[n5 - 1].getBounds();
                    if (n >= rectangle.x && n < rectangle.width + rectangle.x || !this.isExpandable(component)) {
                        return -1;
                    }
                    return n5 - 1;
                }
                ++n5;
            }
        } else {
            int n6 = 1;
            while (n6 < n3) {
                Rectangle rectangle = componentArray[n6].getBounds();
                n2 = rectangle.x;
                if (n2 > n) {
                    Component component = componentArray[n6 - 1];
                    rectangle = componentArray[n6 - 1].getBounds();
                    if (n < rectangle.width + rectangle.x || !this.isExpandable(component)) {
                        return -1;
                    }
                    return n6 - 1;
                }
                ++n6;
            }
        }
        return -1;
    }

    private void _showResizeCursor() {
        this.setCursor(Cursor.getPredefinedCursor(10));
    }

    private void _restoreCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int _getSplitterWidth() {
        Painter painter = this.getEWTStatusBarUI().getCenterSplitterPainter(this);
        return painter == null ? 0 : painter.getMinimumSize((PaintContext)this.getPaintContext()).width;
    }

    private int[] _getSplitters(boolean bl) {
        Object object;
        if (!this.isItemResizeAllowed()) {
            return new int[0];
        }
        int n = this.getActualReadingDirection();
        int n2 = n == 2 ? -this._ITEM_SPACING - this._itemSplitWidth : this._ITEM_SPACING;
        int n3 = this.getBorderInsets().left;
        int n4 = 0;
        Component[] componentArray = this.getComponents();
        int n5 = componentArray.length;
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5 - 1) {
            object = componentArray[n6];
            if (bl == this.isExpandable((Component)object)) {
                Rectangle rectangle = ((Component)object).getBounds();
                int n7 = rectangle.x + n2;
                if (n != 2) {
                    n7 += rectangle.width;
                }
                nArray[n4] = n7;
                ++n4;
            }
            ++n6;
        }
        object = new int[n4];
        System.arraycopy(nArray, 0, object, 0, n4);
        return object;
    }

    private void _installBorder(Component component) {
        Border border = this.getEWTStatusBarUI().getItemBorder(this);
        if (border != null && component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Border border2 = jComponent.getBorder();
            if (border2 != null) {
                CompoundBorder compoundBorder = new CompoundBorder(border, border2);
                border = compoundBorder;
            }
            jComponent.setBorder(border);
        }
    }

    private void _uninstallBorder(Component component) {
        if (component instanceof JComponent) {
            Border border = this.getEWTStatusBarUI().getItemBorder(this);
            if (border == null) {
                return;
            }
            JComponent jComponent = (JComponent)component;
            Border border2 = jComponent.getBorder();
            if (border2 != null) {
                CompoundBorder compoundBorder;
                Border border3;
                if (border2 == border) {
                    jComponent.setBorder(null);
                } else if (border2 instanceof CompoundBorder && (border3 = (compoundBorder = (CompoundBorder)border2).getOutsideBorder()) == border) {
                    jComponent.setBorder(compoundBorder.getInsideBorder());
                }
            }
        }
    }

    private Dimension _getMinimumSize() {
        int n = 20;
        int n2 = 15;
        Insets insets = this.getInsets();
        int n3 = 0;
        EWTStatusBarUI eWTStatusBarUI = this.getEWTStatusBarUI();
        boolean bl = this.getEWTStatusBarUI().getStaticSplitterPainter(this) != null;
        Component[] componentArray = this.getComponents();
        int n4 = componentArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            if (component.isVisible()) {
                Dimension dimension = component.getMinimumSize();
                n += dimension.width;
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                if (this.isExpandable(component) || bl) {
                    ++n3;
                }
            }
            ++n5;
        }
        if (n4 > 0) {
            if (n3 > 0 && this.isItemResizeAllowed()) {
                if (this.isExpandable(componentArray[n4 - 1]) || bl) {
                    --n3;
                }
                n += n3 * (this._itemSplitWidth + this._ITEM_SPACING);
            }
            n += (n4 - 1) * this._ITEM_SPACING;
        }
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    private Dimension _getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension2 != null) {
            if (dimension.width > dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height > dimension2.height) {
                dimension.height = dimension2.height;
            }
        }
        return dimension;
    }

    protected boolean isChildInvalidationIgnored() {
        return true;
    }

    private void _doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isChildInvalidationIgnored() && n == this._lastWidth && n2 == this._lastHeight) {
            return;
        }
        this._lastWidth = n;
        this._lastHeight = n2;
        int n3 = this.getComponentCount();
        if (n3 < 1) {
            return;
        }
        Component[] componentArray = this.getComponents();
        Insets insets = this.getInsets();
        n2 -= insets.top + insets.bottom;
        boolean bl = this.getEWTStatusBarUI().getStaticSplitterPainter(this) != null;
        int n4 = this.getActualReadingDirection();
        int n5 = n4 == 1 ? insets.left : (n -= insets.left + insets.right);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            Component component = componentArray[n10];
            if (component.isVisible()) {
                Dimension dimension = component.getMinimumSize();
                n6 += dimension.width;
                if (dimension.height > n7) {
                    n7 = dimension.height;
                }
                if (n10 < n3 - 1 && (this.isExpandable(component) || bl)) {
                    ++n9;
                }
                if (this.isExpandable(component)) {
                    ++n8;
                }
            }
            ++n10;
        }
        int n11 = n - (n6 += n9 * (this._itemSplitWidth + this._ITEM_SPACING) + (n3 - 1) * this._ITEM_SPACING);
        if (n11 < 0) {
            n11 = 0;
        }
        int n12 = n11;
        int n13 = n8;
        if (this.isExpandable(componentArray[n3 - 1])) {
            --n13;
        }
        int n14 = 0;
        while (n14 < n3) {
            Component component = componentArray[n14];
            if (component.isVisible()) {
                Dimension dimension = component.getSize();
                if (this._firstLayout || dimension.width <= 0 || dimension.height <= 0) {
                    dimension = new Dimension(component.getMinimumSize());
                }
                if (this.isExpandable(component) || n14 == n3 - 1) {
                    float f;
                    int n15 = 0;
                    int n16 = component.getMinimumSize().width;
                    if (--n8 <= 0) {
                        n15 = n12;
                    } else if (this._firstLayout || this._lastFillWidth == 0) {
                        n15 = n11 / n13;
                    } else if (this._lastFillWidth > 0 && (n15 = (int)((f = (float)(dimension.width - n16) / (float)this._lastFillWidth) * (float)n11)) > n12) {
                        n15 = n12;
                    }
                    dimension.width = n16 + n15;
                    n12 -= n15;
                }
                component.setSize(dimension.width, n2);
                if (n4 == 2) {
                    component.setLocation(n5 -= dimension.width, insets.top);
                    if ((bl || this.isExpandable(component)) && n14 < n3 - 1) {
                        n5 -= this._itemSplitWidth + 2 * this._ITEM_SPACING;
                    }
                } else {
                    component.setLocation(n5, insets.top);
                    n5 += dimension.width + this._ITEM_SPACING;
                    if ((bl || this.isExpandable(component)) && n14 < n3 - 1) {
                        n5 += this._itemSplitWidth + this._ITEM_SPACING;
                    }
                }
            }
            ++n14;
        }
        this._lastFillWidth = n11;
        this._firstLayout = false;
    }

    protected class AccessibleStatusBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleStatusBar() {
            super(StatusBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.STATUS_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.HORIZONTAL);
            return accessibleStateSet;
        }
    }

    private class StatusBarLayout
    implements LayoutManager {
        private StatusBarLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return StatusBar.this._getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return StatusBar.this._getMinimumSize();
        }

        public void layoutContainer(Container container) {
            StatusBar.this._doLayout();
        }
    }
}

