/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.text.WrapInfo;
import oracle.bali.share.nls.LocaleUtils;

public class WrappedText
implements WrapInfo {
    private boolean _forceFit;
    private FontMetrics _metrics;
    private Locale _locale;
    private int _width;
    private String _text;
    private Vector _lines;

    public static String wrapText(String string, Component component) {
        return WrappedText.wrapText(string, WordWrapper.getTextWrapper(), component);
    }

    public static String wrapText(String string, TextWrapper textWrapper, Component component) {
        return new WrappedText(string, textWrapper, component).getWrappedText();
    }

    public WrappedText(String string, TextWrapper textWrapper, Component component) {
        this(string, textWrapper, component, false);
    }

    public WrappedText(String string, TextWrapper textWrapper, Component component, boolean bl) {
        this(string, textWrapper, WrappedText._getInnerWidth(component), component.getFontMetrics(component.getFont()), LocaleUtils.getDefaultableLocale((Component)component), bl);
    }

    public WrappedText(String string, TextWrapper textWrapper, int n, FontMetrics fontMetrics, Locale locale, boolean bl) {
        int n2;
        if (string == null) {
            string = "";
        }
        int n3 = -1;
        int n4 = string.length();
        this._text = string;
        this._width = n;
        this._metrics = fontMetrics;
        this._locale = locale == null ? Locale.getDefault() : locale;
        this._forceFit = bl;
        if (fontMetrics == null) {
            return;
        }
        if (this._width <= 0) {
            this._width = (int)Math.sqrt((double)((float)fontMetrics.stringWidth(this._text) * (float)fontMetrics.getHeight()) * 4.0) + 1;
        }
        while ((n2 = n3 + 1) != n4) {
            n3 = string.indexOf(10, n2);
            if (n3 == -1) {
                textWrapper.wrapParagraph(this, string.substring(n2));
            } else if (n3 == n2) {
                this.addLine("", 0, 0);
            } else {
                textWrapper.wrapParagraph(this, string.substring(n2, n3));
            }
            if (n3 != -1) continue;
        }
    }

    public String getText() {
        return this._text;
    }

    public String getWrappedText() {
        int n = this.getLineCount();
        StringBuffer stringBuffer = new StringBuffer(this.getText().length() + n - 1);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.getLine(n2));
            if (n2 < n - 1) {
                stringBuffer.append('\n');
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    public int getLineCount() {
        if (this._lines == null) {
            return 1;
        }
        return this._lines.size();
    }

    public String getLine(int n) {
        if (n < 0 || n >= this.getLineCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (this._lines == null) {
            return this._text;
        }
        return (String)this._lines.elementAt(n);
    }

    public boolean addLine(String string, int n, int n2) {
        if (string == this.getText() && n == 0 && n2 == string.length()) {
            return false;
        }
        Vector<String> vector = this._lines;
        if (vector == null) {
            this._lines = vector = new Vector<String>();
        }
        vector.addElement(string.substring(n, n2));
        return true;
    }

    public boolean isCalculatingPreferred() {
        return !this._forceFit;
    }

    public FontMetrics getFontMetrics() {
        return this._metrics;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int getWrapWidth() {
        return this._width;
    }

    private static int _getInnerWidth(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            int n = jComponent.getWidth();
            if (jComponent.getBorder() != null) {
                Insets insets = jComponent.getBorder().getBorderInsets(component);
                n -= insets.left + insets.right;
            }
            return n;
        }
        return component.getSize().width;
    }
}

