/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.elaf.EWTWizardUI;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public abstract class BaseWizard
extends LWComponent
implements Accessible {
    public static final int MNEMONIC_APPLY = 0;
    public static final int MNEMONIC_CANCEL = 1;
    public static final int MNEMONIC_FINISH = 2;
    public static final int MNEMONIC_NEXT = 3;
    public static final int MNEMONIC_PREVIOUS = 4;
    public static final int MNEMONIC_HELP = 5;
    private LWComponent _buttonRow;
    JButton _apply;
    JButton _cancel;
    JButton _finish;
    JButton _next;
    JButton _previous;
    JButton _help;
    private Vector _pages;
    private Action _listener;
    private ListenerManager _wizardListeners;
    private WizardPage _selectedPage;
    private int _customButtons;
    private boolean _finishDefaulted = true;
    private boolean _sequential;
    private JLabel _accessibleLabel;
    private JPanel _bottomPanel;
    private static final int _BUTTON_SEPARATION = 8;
    private static final int _BUTTON_CONTENT_DISTANCE = 7;
    private static final int _WIDTH = 600;
    private static final int _HEIGHT = 400;
    private static final String _FINISH_KEY = "WIZARD.FINISH";
    private static final String _APPLY_KEY = "WIZARD.APPLY";
    private static final String _CANCEL_KEY = "WIZARD.CANCEL";
    private static final String _PREVIOUS_KEY = "WIZARD.PREV";
    private static final String _NEXT_KEY = "WIZARD.NEXT";
    private static final String _HELP_KEY = "WIZARD.HELP";
    private static final String _OK_KEY = "OK";
    private static final String _FINISH_NAME = "Finish";
    private static final String _APPLY_NAME = "Apply";
    private static final String _CANCEL_NAME = "Cancel";
    private static final String _PREVIOUS_NAME = "Back";
    private static final String _NEXT_NAME = "Next";
    private static final String _HELP_NAME = "Help";
    private static final String _OK_NAME = "OK";
    private static final String _BUNDLE_NAME = "oracle.bali.ewt.resource.JEWTBundle";

    protected BaseWizard() {
        this(true);
    }

    BaseWizard(boolean bl) {
        this._sequential = bl;
        Action action = new Action();
        this.setLayout(new BorderLayout(0, 7));
        this._buttonRow = new DialogButtonBar();
        this._bottomPanel = new JPanel(new BorderLayout());
        this._bottomPanel.add("North", this._buttonRow);
        this.add("South", this._bottomPanel);
        this._pages = new Vector();
        JButton jButton = this._createButton(action);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this._cancel = jButton;
        jButton = this._createButton(action);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_HELP);
        this._help = jButton;
        jButton = this._createButton(action);
        jButton.setVisible(false);
        this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        this._apply = jButton;
        jButton = this._createButton(action);
        jButton.setEnabled(false);
        if (bl) {
            this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_BACK);
        }
        this._previous = jButton;
        this._previous.setHorizontalTextPosition(11);
        this._previous.setVerticalTextPosition(0);
        jButton = this._createButton(action);
        jButton.setEnabled(false);
        if (bl) {
            this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_NEXT);
        }
        this._next = jButton;
        this._next.setHorizontalTextPosition(10);
        this._next.setVerticalTextPosition(0);
        jButton = this._createButton(action);
        jButton.setEnabled(false);
        if (bl) {
            this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_FINISH);
        } else {
            this._buttonRow.add((Component)jButton, DialogButtonBar.CONSTRAINT_YES);
        }
        this._finish = jButton;
        this._cancel.setName(_CANCEL_NAME);
        this._help.setName(_HELP_NAME);
        this._apply.setName(_APPLY_NAME);
        this._previous.setName(_PREVIOUS_NAME);
        this._next.setName(_NEXT_NAME);
        this._finish.setName(this._sequential ? _FINISH_NAME : "OK");
        this._listener = action;
        this._registerKeyboardActions();
        this.updateUI();
    }

    public final WizardPage addPage(WizardPage wizardPage) {
        return this.addPage(wizardPage, null);
    }

    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        this.addPageImpl(wizardPage, wizardPage2);
        if (this.getSelectedPage() == null && wizardPage.isEnabled() && wizardPage.isVisible()) {
            this.selectPage(wizardPage, false);
        }
        return wizardPage;
    }

    public final void addPages(BaseWizard baseWizard, WizardPage wizardPage) {
        Object[] objectArray;
        if (baseWizard == this || baseWizard.getPageCount() == 0) {
            return;
        }
        BaseWizard baseWizard2 = baseWizard;
        synchronized (baseWizard2) {
            objectArray = new WizardPage[baseWizard.getPageCount()];
            baseWizard._pages.copyInto(objectArray);
            baseWizard.removeAllPages();
        }
        int n = 0;
        while (n < objectArray.length) {
            this.addPage((WizardPage)objectArray[n], wizardPage);
            ++n;
        }
    }

    public synchronized void removePage(WizardPage wizardPage) {
        if (this._selectedPage == wizardPage) {
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            if (wizardPage2 == null) {
                wizardPage2 = this.getPreviousPage(wizardPage);
            }
            this.selectPage(wizardPage2, false);
        } else {
            int n;
            int n2 = this.getPageIndex(wizardPage);
            if (this._selectedPage != null && (n = this.getPageIndex(this._selectedPage)) > n2 && n < this.getPageCount() - 2) {
                this.selectPage(this.getPageAt(n + 1));
            }
        }
        wizardPage.removePropertyChangeListener(this._listener);
        wizardPage.setParent(null);
        this._pages.removeElement(wizardPage);
        this.enableButtons();
        this._tryUpdateTitle();
    }

    public synchronized void removeAllPages() {
        int n = this._pages.size();
        while (--n >= 0) {
            WizardPage wizardPage = (WizardPage)this._pages.elementAt(n);
            wizardPage.removePropertyChangeListener(this._listener);
            wizardPage.setParent(null);
        }
        this._pages.removeAllElements();
        this.selectPage(null, false);
        this.enableButtons();
        this._tryUpdateTitle();
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public WizardPage getPageAt(int n) {
        return (WizardPage)this._pages.elementAt(n);
    }

    public WizardPage getSelectedPage() {
        return this._selectedPage;
    }

    public int getCurrentPageIndex() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return -1;
        }
        return wizardPage.getIndex();
    }

    public void setCurrentPageIndex(int n) {
        this.selectPage(this.getPageAt(n));
    }

    public void selectPage(WizardPage wizardPage) {
        this.selectPage(wizardPage, true);
    }

    public void restart() {
        if (this.getPageCount() == 0) {
            return;
        }
        WizardPage wizardPage = this.getPageAt(0);
        if (!wizardPage.isEnabled() || !wizardPage.isVisible()) {
            wizardPage = this.getNextPage(wizardPage);
        }
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        int n2 = this.getPageCount();
        while (++n < n2) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !wizardPage2.isEnabled()) continue;
            return wizardPage2;
        }
        return null;
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        while (--n >= 0) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !wizardPage2.isEnabled()) continue;
            return wizardPage2;
        }
        return null;
    }

    public synchronized void addWizardListener(WizardListener wizardListener) {
        if (this._wizardListeners == null) {
            this._wizardListeners = new ListenerManager();
        }
        this._wizardListeners.addListener((EventListener)wizardListener);
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        this._wizardListeners.removeListener((EventListener)wizardListener);
    }

    public void setHelpAvailable(boolean bl) {
        this._help.setVisible(bl);
    }

    public boolean isHelpAvailable() {
        return this._help.isVisible();
    }

    public void setCanApply(boolean bl) {
        this._apply.setVisible(bl);
        if (this._accessibleLabel != null && bl) {
            this.enableButtons();
        }
    }

    public boolean getCanApply() {
        return this._apply.isVisible();
    }

    public void setFinishText(String string) {
        if (string == null || "".equals(string)) {
            if (this._finishDefaulted) {
                return;
            }
            if (this.getPeer() == null) {
                this._finish.setText("");
            } else {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE_NAME, LocaleUtils.getDefaultableLocale((Component)this));
                this._setButtonLabel(this._finish, this._sequential ? resourceBundle.getString(_FINISH_KEY) : resourceBundle.getString("OK"));
            }
            this._finishDefaulted = true;
        } else {
            if (this._finishDefaulted) {
                this._finish.setMnemonic(0);
            }
            this._finish.setText(string);
            this._finishDefaulted = false;
        }
    }

    public String getFinishText() {
        return this._finish.getText();
    }

    public void setFinishMnemonic(int n) {
        this._finish.setMnemonic(n);
    }

    public int getFinishMnemonic() {
        return this._finish.getMnemonic();
    }

    public int getButtonMnemonic(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this._apply.getMnemonic();
                break;
            }
            case 1: {
                n2 = this._cancel.getMnemonic();
                break;
            }
            case 2: {
                n2 = this._finish.getMnemonic();
                break;
            }
            case 3: {
                n2 = this._next.getMnemonic();
                break;
            }
            case 4: {
                n2 = this._previous.getMnemonic();
                break;
            }
            case 5: {
                n2 = this._help.getMnemonic();
            }
        }
        return n2;
    }

    public void addCustomButton(Component component) {
        if (component.getParent() != this._buttonRow) {
            this._buttonRow.add(component, 2 + this._customButtons);
            ++this._customButtons;
            this._buttonRow.revalidate();
        }
    }

    public void removeCustomButton(Component component) {
        if (component.getParent() == this._buttonRow) {
            --this._customButtons;
            this._buttonRow.remove(component);
            this._buttonRow.revalidate();
        }
    }

    public void setReservedButtonSpaces(int n) {
        this._buttonRow.putClientProperty("WizardReservedButtonSpaces", n == 0 ? null : new Integer(n));
    }

    public int getReservedButtonSpaces() {
        Object object = this._buttonRow.getClientProperty("WizardReservedButtonSpaces");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void dispose() {
        if (this._buttonRow == null) {
            return;
        }
        this._unregisterKeyboardActions();
        this.removeAllPages();
        this._pages = null;
        this._apply.removeActionListener(this._listener);
        this._apply = null;
        this._cancel.removeActionListener(this._listener);
        this._cancel = null;
        this._finish.removeActionListener(this._listener);
        this._finish = null;
        this._next.removeActionListener(this._listener);
        this._next = null;
        this._previous.removeActionListener(this._listener);
        this._previous = null;
        this._help.removeActionListener(this._listener);
        this._help = null;
        this._buttonRow.removeAll();
        this._buttonRow = null;
        this._listener = null;
        this._wizardListeners = null;
        this._selectedPage = null;
        this._bottomPanel.removeAll();
        this._bottomPanel = null;
    }

    public void updateUI() {
        this.setUI((EWTWizardUI)UIManager.getUI(this));
        this.updateReadingDirection(this.getActualReadingDirection());
    }

    public String getUIClassID() {
        return "EWTWizardUI";
    }

    protected final synchronized void addPageImpl(WizardPage wizardPage, WizardPage wizardPage2) {
        int n;
        if (wizardPage.getParent() != null) {
            wizardPage.getParent().removePage(wizardPage);
        }
        if (wizardPage2 == null) {
            this._pages.addElement(wizardPage);
        } else {
            this._pages.insertElementAt(wizardPage, this._pages.indexOf(wizardPage2));
        }
        wizardPage.setParent(this);
        wizardPage.addPropertyChangeListener(this._listener);
        this.enableButtons();
        int n2 = this.getPageIndex(wizardPage);
        if (this._selectedPage != null && (n = this.getPageIndex(this._selectedPage)) >= n2) {
            this.selectPage(this.getPageAt(n - 1));
        }
        this._tryUpdateTitle();
    }

    protected void pagePropertyChange(WizardPage wizardPage, PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("accessibleDescription".equals(string)) {
            if (wizardPage == this.getSelectedPage()) {
                this._updateAccessibleLabel();
            }
        } else if ("visible".equals(string) || "enabled".equals(string)) {
            if (wizardPage == this.getSelectedPage() && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                WizardPage wizardPage2 = null;
                WizardPage wizardPage3 = this.getNextPage(wizardPage);
                if (wizardPage3 != null) {
                    wizardPage2 = wizardPage3;
                } else {
                    WizardPage wizardPage4 = this.getPreviousPage(wizardPage);
                    if (wizardPage4 != null) {
                        wizardPage2 = wizardPage4;
                    }
                }
                this.setSelectedPage(wizardPage2);
            } else {
                this.enableButtons();
            }
            this._tryUpdateTitle();
        } else if ("canAdvance".equals(string) || "canGoBack".equals(string)) {
            this.enableButtons();
        }
    }

    protected void updateReadingDirection(int n) {
    }

    public void addNotify() {
        super.addNotify();
        final Window window = WindowUtils.getWindow(this);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                BaseWizard.this.resetFocus(BaseWizard.this.getSelectedPage());
                BaseWizard.this._updateAccessibleTitle();
                BaseWizard.this._updateAccessibleLabel();
                window.removeWindowListener(this);
            }
        });
        this._loadButtonText(this.getLocale());
        this.enableButtons();
        this.resetFocus(this.getSelectedPage());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._buttonRow != null) {
            this._loadButtonText(LocaleUtils.getDefaultableLocale((Component)this));
        }
    }

    public void enable() {
        super.enable();
        this.enableButtons();
    }

    public void disable() {
        super.disable();
        this.enableButtons();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWizard();
            this._accessibleLabel = new AccessibleLabel();
            StatusBar statusBar = new StatusBar();
            statusBar.setPreferredSize(new Dimension(0, 0));
            statusBar.add(this._accessibleLabel);
            this._bottomPanel.add("South", statusBar);
            this.validate();
            this._updateAccessibleTitle();
            this._updateAccessibleLabel();
        }
        return this.accessibleContext;
    }

    protected boolean getMustFinish() {
        return true;
    }

    protected boolean getCanAdvance() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return false;
        }
        return wizardPage.getCanAdvance();
    }

    protected boolean getCanGoBack() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return false;
        }
        return wizardPage.getCanGoBack();
    }

    protected void doCancel() {
        this.processEvent(new WizardEvent(this, 2003, this.getSelectedPage()));
    }

    protected void doApply() {
        if (this.validateSelectedPage()) {
            this.processEvent(new WizardEvent(this, 2002, this.getSelectedPage()));
        }
    }

    protected void doFinish() {
        if (this.validateSelectedPage()) {
            this.processEvent(new WizardEvent(this, 2004, this.getSelectedPage()));
        }
    }

    protected void doNext() {
        WizardPage wizardPage;
        if (this.validateSelectedPage() && (wizardPage = this.getNextPage(this.getSelectedPage())) != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doHelp() {
        Component component = null;
        WizardPage wizardPage = this.getSelectedPage();
        Window window = WindowUtils.getWindow(this);
        if (window != null) {
            component = window.getFocusOwner();
        }
        if (component == null || component.getParent() == this._buttonRow || component.getParent() == this) {
            component = wizardPage != null ? wizardPage.getContent() : this;
        }
        try {
            HelpUtils.showHelp(component);
        }
        catch (HelpUnavailableException helpUnavailableException) {
            // empty catch block
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WizardEvent) {
            this.processWizardEvent((WizardEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processWizardEvent(WizardEvent wizardEvent) {
        Enumeration enumeration;
        int n = wizardEvent.getID();
        ListenerManager listenerManager = this._wizardListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                WizardListener wizardListener = (WizardListener)enumeration.nextElement();
                switch (n) {
                    case 2001: {
                        wizardListener.wizardSelectionChanged(wizardEvent);
                        break;
                    }
                    case 2002: {
                        wizardListener.wizardApplyState(wizardEvent);
                        break;
                    }
                    case 2003: {
                        wizardListener.wizardCanceled(wizardEvent);
                        break;
                    }
                    case 2004: {
                        wizardListener.wizardFinished(wizardEvent);
                        break;
                    }
                }
            }
        }
    }

    protected String paramString() {
        String string = super.paramString();
        WizardPage wizardPage = this._selectedPage;
        if (wizardPage != null) {
            string = string + ",selected page=" + wizardPage;
        }
        return string;
    }

    protected void enableButtons() {
        this.freezeRepaints();
        try {
            boolean bl;
            WizardPage wizardPage = this._selectedPage;
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            boolean bl2 = this.getCanAdvance();
            boolean bl3 = this.getCanGoBack();
            boolean bl4 = this.getMustFinish();
            boolean bl5 = this.isEnabled();
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                JButton jButton;
                JButton jButton2 = jRootPane.getDefaultButton();
                JButton jButton3 = jButton = !this._sequential || wizardPage2 == null ? this._finish : this._next;
                if (!(this._previous.hasFocus() || this._apply.hasFocus() || this._cancel.hasFocus() || this._help.hasFocus())) {
                    jButton.setDefaultCapable(true);
                    jRootPane.setDefaultButton(jButton);
                    if (jButton2 != jButton && jButton2 != null) {
                        jButton2.setDefaultCapable(false);
                    }
                }
            }
            boolean bl6 = bl = bl5 && bl2 && (wizardPage2 == null || !bl4);
            if (bl && this._next.hasFocus()) {
                this._finish.requestFocus();
            }
            this._finish.setEnabled(bl);
            this._next.setEnabled(bl5 && bl2 && wizardPage2 != null);
            this._previous.setEnabled(bl5 && bl3 && this.getPreviousPage(wizardPage) != null);
            if (this._accessibleLabel == null || this._apply.isVisible()) {
                this._apply.setEnabled(bl5 && bl2);
            }
            this._cancel.setEnabled(bl5);
            Object var11_11 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        if (wizardPage != this._selectedPage && (!bl || this.validateSelectedPage())) {
            Component component;
            this.setSelectedPage(wizardPage);
            this.processEvent(new WizardEvent(this, 2001, wizardPage));
            this.enableButtons();
            this._updateAccessibleTitle();
            this._updateAccessibleLabel();
            this.resetFocus(wizardPage);
            if (wizardPage != null && (component = wizardPage.getContent()) != null && component instanceof JComponent) {
                HelpUtils.setHelpID(this._buttonRow, HelpUtils.getHelpID(component));
                HelpUtils.setHelpProvider(this._buttonRow, HelpUtils.getHelpProvider(component));
                HelpUtils.setHelpSet(this._buttonRow, HelpUtils.getHelpSet(component));
                return;
            }
            HelpUtils.setHelpID(this._buttonRow, null);
            HelpUtils.setHelpProvider(this._buttonRow, null);
            HelpUtils.setHelpSet(this._buttonRow, null);
        }
    }

    protected void setSelectedPage(WizardPage wizardPage) {
        this._selectedPage = wizardPage;
    }

    protected boolean validateSelectedPage() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return true;
        }
        return wizardPage.validatePage();
    }

    int getPageIndex(WizardPage wizardPage) {
        int n = this._pages.indexOf(wizardPage);
        return n;
    }

    protected void resetFocus(final WizardPage wizardPage) {
        if (wizardPage == null) {
            return;
        }
        Component component = wizardPage.getInitialFocus();
        if (component == null && !this._next.hasFocus() && !this._previous.hasFocus()) {
            component = !this._sequential || this._finish.isDefaultButton() ? this._finish : this._next;
        }
        if (component != null && component.isEnabled()) {
            final Component component2 = component;
            FocusUtils.requestFocus(component2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (wizardPage.isSelected()) {
                        FocusUtils.requestFocus(component2);
                    }
                }
            });
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component != this._bottomPanel && !"Center".equals(object)) {
            String string = object instanceof String ? (String)object : component.getName();
            this.addPage(new WizardPage(component, string));
        } else {
            super.addImpl(component, object, n);
        }
    }

    private JButton _createButton(Action action) {
        JButton jButton = new JButton("");
        Insets insets = jButton.getMargin();
        if (insets != null) {
            insets.left = 2;
            insets.right = 1;
        } else {
            insets = new Insets(1, 2, 1, 1);
        }
        jButton.setMargin(insets);
        jButton.addActionListener(action);
        jButton.addFocusListener(action);
        jButton.setDefaultCapable(false);
        return jButton;
    }

    private void _setButtonLabel(Component component, String string) {
        JButton jButton = (JButton)component;
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jButton.setText(StringUtils.stripMnemonic((String)string));
    }

    private void _loadButtonText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
        if (this._finishDefaulted) {
            this._setButtonLabel(this._finish, this._sequential ? resourceBundle.getString(_FINISH_KEY) : resourceBundle.getString("OK"));
        }
        this._setButtonLabel(this._apply, resourceBundle.getString(_APPLY_KEY));
        this._setButtonLabel(this._help, resourceBundle.getString(_HELP_KEY));
        EWTWizardUI eWTWizardUI = (EWTWizardUI)this.ui;
        this._setButtonLabel(this._previous, eWTWizardUI.getPreviousString(this, resourceBundle.getString(_PREVIOUS_KEY)));
        this._setButtonLabel(this._next, eWTWizardUI.getNextString(this, resourceBundle.getString(_NEXT_KEY)));
        this._setButtonLabel(this._cancel, resourceBundle.getString(_CANCEL_KEY));
    }

    private void _unregisterKeyboardActions() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
    }

    private void _tryUpdateTitle() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof WizardDialog) {
            ((WizardDialog)window).__updateTitle();
        }
    }

    private void _registerKeyboardActions() {
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseWizard.this._cancel.doClick();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BaseWizard.this.isHelpAvailable()) {
                    BaseWizard.this.doHelp();
                }
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(112, 0), 1);
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void _updateAccessibleLabel() {
        if (this._accessibleLabel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardPage wizardPage = BaseWizard.this.getSelectedPage();
                    if (wizardPage != null) {
                        BaseWizard.this._accessibleLabel.setText(wizardPage.getAccessibleDescription());
                    }
                }
            });
        }
    }

    private void _updateAccessibleTitle() {
        if (this._accessibleLabel != null) {
            String string = null;
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window == null) {
                return;
            }
            if (window instanceof Frame) {
                string = ((Frame)window).getTitle();
            } else if (window instanceof Dialog) {
                string = ((Dialog)window).getTitle();
            }
            final String string2 = string;
            if (string2 != null && !"".equals(string2)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseWizard.this._accessibleLabel.setText(string2);
                    }
                });
            }
        }
    }

    private class Action
    implements ActionListener,
    PropertyChangeListener,
    FocusListener {
        private Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BaseWizard.this._apply) {
                BaseWizard.this.doApply();
            } else if (object == BaseWizard.this._cancel) {
                BaseWizard.this.doCancel();
            } else if (object == BaseWizard.this._finish) {
                BaseWizard.this.doFinish();
            } else if (object == BaseWizard.this._next) {
                BaseWizard.this.doNext();
            } else if (object == BaseWizard.this._previous) {
                BaseWizard.this.doPrevious();
            } else if (object == BaseWizard.this._help) {
                BaseWizard.this.doHelp();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BaseWizard.this.pagePropertyChange((WizardPage)propertyChangeEvent.getSource(), propertyChangeEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
            JButton jButton;
            JButton jButton2 = BaseWizard.this.getRootPane() == null ? null : BaseWizard.this.getRootPane().getDefaultButton();
            if (jButton2 != (jButton = (JButton)focusEvent.getSource())) {
                if (jButton2 != null) {
                    jButton2.setDefaultCapable(false);
                }
                jButton.setDefaultCapable(true);
                if (BaseWizard.this.getRootPane() != null) {
                    BaseWizard.this.getRootPane().setDefaultButton(jButton);
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                WizardPage wizardPage = BaseWizard.this.getNextPage(BaseWizard.this.getSelectedPage());
                JButton jButton = !BaseWizard.this._sequential || wizardPage == null ? BaseWizard.this._finish : BaseWizard.this._next;
                JButton jButton2 = (JButton)focusEvent.getSource();
                if (jButton2 != jButton) {
                    jButton2.setDefaultCapable(false);
                    if (BaseWizard.this.getRootPane() != null) {
                        BaseWizard.this.getRootPane().setDefaultButton(jButton);
                    }
                    if (jButton != null) {
                        jButton.setDefaultCapable(true);
                    }
                }
            }
        }
    }

    private class AccessibleLabel
    extends JLabel {
        private AccessibleLabel() {
        }

        public void setText(String string) {
            String string2 = this.getText();
            super.setText(string);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
            }
        }
    }

    private class AccessibleWizard
    extends JComponent.AccessibleJComponent {
        private AccessibleWizard() {
            super(BaseWizard.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

