/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.PaintUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ReentrantWizard;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.DWizard;

public class WizardDialog
extends JDialog {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private WizardListener _listener;
    private String _wizardTitle;
    private boolean _finishPage;
    private boolean _welcomePage;
    private WelcomeWizardPage _welcomeWizardPage;
    private boolean _skipNextTime;
    private Locale _locale;
    private Component _centerOver;
    private int _initialWidth = -1;
    private int _initialHeight = -1;
    private Runnable _runnable = null;
    private static final int _WIDTH = 600;
    private static final int _HEIGHT = 400;
    private static final int _REENTRANT_HEIGHT = 435;
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_WELCOME = "WIZARD.TITLE_WELCOME";
    private static final String _KEY_FINISH = "WIZARD.TITLE_FINISH";
    private static final String _KEY_OTHER = "WIZARD.TITLE_OTHER";
    private static final String _KEY_DASH = "WIZARD.TITLE_DASH";
    private static final Border _sBorder = new EmptyBorder(6, 6, 8, 6);

    public WizardDialog() {
        this(null, (Frame)null, true);
    }

    public WizardDialog(BaseWizard baseWizard) {
        this(baseWizard, (Frame)null, true);
    }

    public WizardDialog(BaseWizard baseWizard, Frame frame) {
        this(baseWizard, frame, true);
    }

    public WizardDialog(BaseWizard baseWizard, Frame frame, boolean bl) {
        super(frame, "", bl);
        this._init(baseWizard);
    }

    public WizardDialog(BaseWizard baseWizard, Dialog dialog) {
        this(baseWizard, dialog, true);
    }

    public WizardDialog(BaseWizard baseWizard, Dialog dialog, boolean bl) {
        super(dialog, "", bl);
        this._init(baseWizard);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(BaseWizard baseWizard) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._wizard = baseWizard;
    }

    public void setWizardTitle(String string) {
        if (this._wizardTitle != string) {
            this._wizardTitle = string;
            this.__updateTitle();
        }
    }

    public String getWizardTitle() {
        return this._wizardTitle;
    }

    public void setWelcomePageIncluded(boolean bl) {
        if (this._welcomePage != bl) {
            this._welcomePage = bl;
            this.__updateTitle();
        }
    }

    public boolean isWelcomePageIncluded() {
        return this._welcomePage;
    }

    public void setWelcomeWizardPage(WelcomeWizardPage welcomeWizardPage) {
        this._welcomeWizardPage = welcomeWizardPage;
        this.setWelcomePageIncluded(welcomeWizardPage != null);
    }

    public WelcomeWizardPage getWelcomeWizardPage() {
        return this._welcomeWizardPage;
    }

    public void setFinishPageIncluded(boolean bl) {
        if (this._finishPage != bl) {
            this._finishPage = bl;
            this.__updateTitle();
        }
    }

    public boolean isFinishPageIncluded() {
        return this._finishPage;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean runDialog() {
        return this.runDialog(null);
    }

    public boolean runDialog(Runnable runnable) {
        BaseWizard baseWizard = this._wizard;
        if (this.isVisible() || baseWizard == null || baseWizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this._runnable = runnable;
        this.getContentPane().add((Component)baseWizard, "Center");
        baseWizard.addWizardListener(this._listener);
        this._initialWidth = -1;
        this._initialHeight = -1;
        this.pack();
        ((Component)this).setBackground(baseWizard.getBackground());
        this.getContentPane().setBackground(baseWizard.getBackground());
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        this._cancelled = false;
        this.__updateTitle();
        if (this._welcomeWizardPage != null) {
            this._skipNextTime = this._welcomeWizardPage.isSkipNextTime();
            baseWizard.restart();
            if (this._skipNextTime) {
                baseWizard.doNext();
            }
        }
        ((Component)this).setVisible(true);
        if (this.isModal()) {
            baseWizard.removeWizardListener(this._listener);
            this.getContentPane().remove(baseWizard);
        }
        return !this._cancelled;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.getParent();
        if (container != null && (locale = container.getLocale()) != null) {
            return locale;
        }
        return super.getLocale();
    }

    public Dimension getPreferredSize() {
        return this._wizard instanceof ReentrantWizard ? new Dimension(600, 435) : new Dimension(600, 400);
    }

    public void dispose() {
        super.dispose();
        if (this._wizard == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this.getContentPane().remove(this._wizard);
        this._wizard.removeWizardListener(this._listener);
        this._wizard.dispose();
        this._listener = null;
        this._wizard = null;
        this._locale = null;
        this._centerOver = null;
    }

    protected void dismissDialog(boolean bl) {
        this._cancelled = bl;
        if (this.isVisible()) {
            ((Component)this).setVisible(false);
            if (!this.isModal()) {
                this._wizard.removeWizardListener(this._listener);
                this.getContentPane().remove(this._wizard);
            }
            if (!this._cancelled && this._runnable != null) {
                PaintUtils.invokeAfterRepaint(this._runnable);
                this._runnable = null;
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        if (this._initialWidth != -1) {
            n3 = Math.max(this._initialWidth, n3);
        }
        if (this._initialHeight != -1) {
            n4 = Math.max(this._initialHeight, n4);
        }
        if (n2 != n3 || n != n4) {
            ((Component)this).setSize(n3, n4);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        JButton jButton;
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201 && (jButton = this._wizard._cancel).isEnabled()) {
            jButton.doClick();
        }
    }

    void __updateTitle() {
        if (this.getWizard() != null && this.getWizard().getSelectedPage() != null) {
            this._setTitle();
        }
    }

    private void _init(BaseWizard baseWizard) {
        WindowUtils.registerWindow(this);
        this._wizard = baseWizard;
        this._listener = new WizListener();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.setBorder(_sBorder);
        this.enableEvents(65L);
        this.setDefaultCloseOperation(0);
    }

    private void _setTitle() {
        String string;
        if (this.getWizardTitle() == null) {
            return;
        }
        if (this._wizard instanceof ReentrantWizard) {
            this.setTitle(this.getWizardTitle());
            return;
        }
        WizardPage wizardPage = this.getWizard().getSelectedPage();
        String string2 = wizardPage == null ? "" : wizardPage.getLabel();
        int n = -1;
        int n2 = this.getWizard().getPageCount();
        int n3 = 0;
        if (this.getWizard() instanceof DWizard) {
            n3 = n2;
            n = ((DWizard)this.getWizard()).getCurrentPageIndex();
        } else {
            int n4 = 0;
            while (n4 < n2) {
                WizardPage wizardPage2 = this.getWizard().getPageAt(n4);
                if (wizardPage2 == wizardPage) {
                    n = n3;
                }
                if (wizardPage2.isEnabled() && wizardPage2.isVisible()) {
                    ++n3;
                }
                ++n4;
            }
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE, this.getLocale());
        if (n == 0 && this.isWelcomePageIncluded()) {
            if (string2 == null || string2.length() == 0) {
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(_KEY_WELCOME));
                Object[] objectArray = new Object[]{this.getWizardTitle()};
                string = messageFormat.format(objectArray);
            } else {
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(_KEY_DASH));
                Object[] objectArray = new Object[]{this.getWizardTitle(), string2};
                string = messageFormat.format(objectArray);
            }
        } else if (n == n3 - 1 && this.isFinishPageIncluded()) {
            if (string2 == null || string2.length() == 0) {
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(_KEY_FINISH));
                Object[] objectArray = new Object[]{this.getWizardTitle()};
                string = messageFormat.format(objectArray);
            } else {
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(_KEY_DASH));
                Object[] objectArray = new Object[]{this.getWizardTitle(), string2};
                string = messageFormat.format(objectArray);
            }
        } else {
            if (this.isWelcomePageIncluded()) {
                --n3;
            } else {
                ++n;
            }
            if (this.isFinishPageIncluded()) {
                --n3;
            }
            MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(_KEY_OTHER));
            Object[] objectArray = new Object[]{this.getWizardTitle(), new Integer(n), new Integer(n3), string2};
            string = messageFormat.format(objectArray);
        }
        this.setTitle(string);
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardSelectionChanged(WizardEvent wizardEvent) {
            WizardPage wizardPage = wizardEvent.getPage();
            if (wizardPage != null) {
                WizardDialog.this._setTitle();
            }
        }

        public void wizardFinished(WizardEvent wizardEvent) {
            WizardDialog.this.dismissDialog(false);
        }

        public void wizardCanceled(WizardEvent wizardEvent) {
            WizardDialog.this.dismissDialog(true);
            if (WizardDialog.this._welcomeWizardPage != null) {
                WizardDialog.this._welcomeWizardPage.setSkipNextTime(WizardDialog.this._skipNextTime);
            }
        }
    }
}

