/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.NullSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence;

public class DWizard
extends Wizard {
    private WizardSequence _sequence;
    private int _currentIndex;

    public DWizard() {
        this(NullSequence.getWizardSequence());
    }

    public DWizard(WizardSequence wizardSequence) {
        this.setSequence(wizardSequence);
    }

    public void restart() {
        this._sequence.goToFirstPage();
        this._currentIndex = 0;
        WizardPage wizardPage = this._sequence.getCurrentPage();
        if (wizardPage != null) {
            this._checkAdded(wizardPage);
            this.selectPage(wizardPage, false);
        }
    }

    public WizardSequence getSequence() {
        return this._sequence;
    }

    public void selectPage(WizardPage wizardPage) {
        throw new IllegalStateException("DWizards aren't freely navigable");
    }

    public int getCurrentPageIndex() {
        return this._currentIndex;
    }

    public int getPageCount() {
        return this._sequence.getPageCount();
    }

    public void setSequence(WizardSequence wizardSequence) {
        if (wizardSequence == null) {
            wizardSequence = NullSequence.getWizardSequence();
        }
        this._sequence = wizardSequence;
        this.restart();
    }

    public void goForward() {
        if (this._sequence.getNextPage() != null) {
            this.doNext();
        }
    }

    public void goBackwards() {
        if (this._sequence.getPreviousPage() != null) {
            this.doPrevious();
        }
    }

    public void enableButtons() {
        super.enableButtons();
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        return this._sequence.getNextPage();
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        return this._sequence.getPreviousPage();
    }

    public void dispose() {
        super.dispose();
        this._sequence = null;
        this._currentIndex = -1;
    }

    protected void doNext() {
        if (this.validateSelectedPage()) {
            WizardPage wizardPage = this._sequence.getNextPage();
            this._checkAdded(wizardPage);
            ++this._currentIndex;
            this._sequence.goForward();
            this.selectPage(wizardPage, false);
        }
    }

    protected void doPrevious() {
        WizardPage wizardPage = this._sequence.getPreviousPage();
        this._checkAdded(wizardPage);
        --this._currentIndex;
        this._sequence.goBackwards();
        this.selectPage(wizardPage, false);
    }

    private void _checkAdded(WizardPage wizardPage) {
        if (wizardPage != null && wizardPage.getParent() != this) {
            this.addPage(wizardPage);
        }
    }
}

