/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import java.util.NoSuchElementException;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.NullSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence;

public class SequenceSeries
implements WizardSequence {
    private WizardSequence[] _series;
    private int _index;

    public SequenceSeries() {
        this(null);
    }

    public SequenceSeries(WizardSequence[] wizardSequenceArray) {
        this.setSeries(wizardSequenceArray);
    }

    public void setSeries(WizardSequence[] wizardSequenceArray) {
        if (wizardSequenceArray == null) {
            wizardSequenceArray = new WizardSequence[]{NullSequence.getWizardSequence()};
        }
        this._series = wizardSequenceArray;
        this._index = 0;
    }

    public WizardSequence[] getSeries() {
        return this._series;
    }

    public void goToFirstPage() {
        this._index = 0;
        this._series[0].goToFirstPage();
        if (this.getCurrentPage() == null && this.getNextPage() != null) {
            this.goForward();
        }
    }

    public void goToLastPage() {
        this._index = this._series.length - 1;
        this._series[this._index].goToLastPage();
        if (this.getCurrentPage() == null && this.getPreviousPage() != null) {
            this.goBackwards();
        }
    }

    public void goForward() {
        int n = this._index;
        if (this._series[n].getNextPage() != null) {
            this._series[n].goForward();
        } else {
            do {
                if (this._index == this._series.length - 1) {
                    throw new NoSuchElementException();
                }
                this._series[++this._index].goToFirstPage();
            } while (this.getCurrentPage() == null);
        }
    }

    public void goBackwards() {
        int n = this._index;
        if (this._series[n].getPreviousPage() != null) {
            this._series[n].goBackwards();
        } else {
            do {
                if (this._index == 0) {
                    throw new NoSuchElementException();
                }
                this._series[--this._index].goToLastPage();
            } while (this.getCurrentPage() == null);
        }
    }

    public WizardPage getNextPage() {
        int n = this._index;
        WizardPage wizardPage = this._series[n].getNextPage();
        while (wizardPage == null && n < this._series.length - 1) {
            this._series[++n].goToFirstPage();
            wizardPage = this._series[n].getCurrentPage();
        }
        return wizardPage;
    }

    public WizardPage getPreviousPage() {
        int n = this._index;
        WizardPage wizardPage = this._series[n].getPreviousPage();
        while (wizardPage == null && n > 0) {
            this._series[--n].goToLastPage();
            wizardPage = this._series[n].getCurrentPage();
        }
        return wizardPage;
    }

    public WizardPage getCurrentPage() {
        return this._series[this._index].getCurrentPage();
    }

    public int getPageCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._series.length) {
            n += this._series[n2].getPageCount();
            ++n2;
        }
        return n;
    }
}

