/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.util.Dictionary;
import java.util.Hashtable;
import oracle.bali.ewt.worker.AbstractWorkerQueue;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerStatusListener;

public final class WorkerUtils {
    public static final Object PARAMETER_NULL = new Object();
    private static final int _QUEUE_ALWAYS = 0;
    private static final int _QUEUE_IF_NECESSARY = 1;
    private static final int _QUEUE_NEVER = 2;
    private static boolean _sQueueLocationsSaved = false;

    public static Throwable getFailureCause(InvocationContext invocationContext) {
        return (Throwable)invocationContext.getValue(InvocationContext.FAILURE_CAUSE, null);
    }

    public static Object getMainResult(InvocationContext invocationContext) {
        return WorkerUtils.getMainResult(invocationContext, InvocationContext.UNDEFINED);
    }

    public static Object getMainResult(InvocationContext invocationContext, Object object) {
        return invocationContext.getValue(InvocationContext.RESULT, object);
    }

    public static Boolean isCanceled(InvocationContext invocationContext) {
        return (Boolean)invocationContext.getValue(InvocationContext.CANCELED, null);
    }

    public static InvocationContext getParentContext(InvocationContext invocationContext) {
        return (InvocationContext)invocationContext.getValue(InvocationContext.PARENT_CONTEXT, null);
    }

    public static Object getDefaultParameter(InvocationContext invocationContext) {
        return WorkerUtils.getDefaultParameter(invocationContext, InvocationContext.UNDEFINED);
    }

    public static Object getDefaultParameter(InvocationContext invocationContext, Object object) {
        return invocationContext.getValue(InvocationContext.PARAMETER_VALUE, object);
    }

    public static void setQueueLocationsSaved(boolean bl) {
        _sQueueLocationsSaved = bl;
    }

    public static boolean getQueueLocationsSaved() {
        return _sQueueLocationsSaved;
    }

    public static InvocationContext queueWorker(Worker worker) {
        return WorkerUtils.queueWorker(worker, null);
    }

    public static InvocationContext queueWorker(Worker worker, WorkerStatusListener workerStatusListener) {
        return WorkerUtils.queueWorker(worker, InvocationContext.UNDEFINED, workerStatusListener);
    }

    public static InvocationContext queueWorker(Worker worker, Object object, WorkerStatusListener workerStatusListener) {
        return WorkerUtils.queueWorker(worker, InvocationContext.PARAMETER_VALUE, object, workerStatusListener);
    }

    public static InvocationContext queueWorker(Worker worker, Object object, Object object2, WorkerStatusListener workerStatusListener) {
        return WorkerUtils.queueWorker(worker, WorkerUtils.createParameters(object, object2), workerStatusListener);
    }

    public static InvocationContext queueWorker(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        try {
            return WorkerUtils._runWorker(worker, dictionary, 0, workerStatusListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            return null;
        }
    }

    public static InvocationContext runOrQueueWorker(Worker worker) {
        return WorkerUtils.runOrQueueWorker(worker, null);
    }

    public static InvocationContext runOrQueueWorker(Worker worker, WorkerStatusListener workerStatusListener) {
        return WorkerUtils.runOrQueueWorker(worker, InvocationContext.UNDEFINED, workerStatusListener);
    }

    public static InvocationContext runOrQueueWorker(Worker worker, Object object, WorkerStatusListener workerStatusListener) {
        return WorkerUtils.runOrQueueWorker(worker, InvocationContext.PARAMETER_VALUE, object, workerStatusListener);
    }

    public static InvocationContext runOrQueueWorker(Worker worker, Object object, Object object2, WorkerStatusListener workerStatusListener) {
        return WorkerUtils.runOrQueueWorker(worker, WorkerUtils.createParameters(object, object2), workerStatusListener);
    }

    public static InvocationContext runOrQueueWorker(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        try {
            return WorkerUtils._runWorker(worker, dictionary, 1, workerStatusListener);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            return null;
        }
    }

    public static Object runWorkerAndWait(Worker worker) throws Throwable {
        return WorkerUtils.runWorkerAndWait(worker, InvocationContext.UNDEFINED);
    }

    public static Object runWorkerAndWait(Worker worker, Object object) throws Throwable {
        return WorkerUtils.runWorkerAndWait(worker, InvocationContext.PARAMETER_VALUE, object);
    }

    public static Object runWorkerAndWait(Worker worker, Object object, Object object2) throws Throwable {
        return WorkerUtils.runWorkerAndWait(worker, WorkerUtils.createParameters(object, object2));
    }

    public static Object runWorkerAndWait(Worker worker, Dictionary dictionary) throws Throwable {
        InvocationContext invocationContext = WorkerUtils._runWorker(worker, dictionary, 2, null);
        Object object = invocationContext.getValue(InvocationContext.RESULT, InvocationContext.UNDEFINED);
        if (object == InvocationContext.UNDEFINED) {
            throw WorkerUtils.getFailureCause(invocationContext);
        }
        return object;
    }

    public static Dictionary createMinimalParameterDictionary() {
        return new Hashtable(7);
    }

    public static void putNullableValue(Dictionary dictionary, Object object, Object object2) {
        if (object2 == null) {
            object2 = PARAMETER_NULL;
        }
        dictionary.put(object, object2);
    }

    public static Dictionary createParameters(Object object, Object object2) {
        Dictionary dictionary = WorkerUtils.createMinimalParameterDictionary();
        if (object2 != InvocationContext.UNDEFINED) {
            WorkerUtils.putNullableValue(dictionary, object, object2);
        }
        return dictionary;
    }

    private static InvocationContext _runWorker(Worker worker, Dictionary dictionary, int n, WorkerStatusListener workerStatusListener) throws Throwable {
        WorkerQueue workerQueue = worker.getWorkerQueue();
        InvocationContext invocationContext = null;
        if (dictionary == null) {
            dictionary = WorkerUtils.createMinimalParameterDictionary();
        }
        if (n != 0 && (workerQueue == null || workerQueue.isInWorkerQueueThread())) {
            invocationContext = AbstractWorkerQueue.__runWorkerImmediately(worker, dictionary, workerStatusListener);
        } else {
            if (workerQueue == null) {
                throw new IllegalArgumentException("Attempt to queue worker with no queue");
            }
            invocationContext = n == 2 ? workerQueue.invokeAndWait(worker, dictionary, workerStatusListener) : workerQueue.invokeLater(worker, dictionary, workerStatusListener);
        }
        return invocationContext;
    }

    private WorkerUtils() {
    }
}

