/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.formatter;

import antlr.Token;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.ArrayList;
import oracle.dbtools.formatter.FormatOptions;
import oracle.dbtools.formatter.IFormatTokenLists;
import oracle.dbtools.formatter.TokenFormatterRules;
import oracle.dbtools.formatter.TokenUtil;
import oracle.dbtools.formatter.parser.PLSQLLexer;
import oracle.dbtools.formatter.parser.PLSQLTokenTypes;

public class PrettyPLSQL
implements PLSQLTokenTypes,
IFormatTokenLists {
    public String format(String input) {
        return this.format(input, new FormatOptions());
    }

    public String format(String input, FormatOptions fo) {
        String output = "";
        try {
            PLSQLLexer lexer = new PLSQLLexer(new StringReader(input));
            lexer.setFormatOptions(fo);
            output = this.format(lexer, fo);
        }
        catch (Exception e) {
            output = input;
            e.printStackTrace();
        }
        return output;
    }

    public String format(PLSQLLexer lexer) throws TokenStreamException {
        return this.format(lexer, new FormatOptions());
    }

    public String format(PLSQLLexer lexer, FormatOptions fo) throws TokenStreamException {
        String output = "";
        ArrayList<Token> tokenList = new ArrayList<Token>();
        Token prevToken = null;
        Token currToken = lexer.getNextToken();
        Token nextToken = lexer.getNextToken();
        int[] tokenPattern = new int[]{0, TokenUtil.getTokenID(currToken), TokenUtil.getTokenID(nextToken)};
        TokenFormatterRules tf = new TokenFormatterRules(fo);
        Token processedToken = null;
        while (true) {
            if (TokenUtil.getTokenID(currToken) == 1) break;
            processedToken = tf.formatToken(currToken, prevToken, nextToken);
            tokenList.add(processedToken);
            prevToken = currToken;
            currToken = nextToken;
            nextToken = lexer.getNextToken();
            int[] currTokenPattern = new int[]{TokenUtil.getTokenID(prevToken), TokenUtil.getTokenID(currToken), TokenUtil.getTokenID(nextToken)};
        }
        output = TokenUtil.generateOutput(tokenList, fo);
        return output;
    }

    public static boolean verifyResult(String input, String output) {
        String cleanOutput;
        input = input.toLowerCase();
        output = output.toLowerCase();
        String cleanInput = PrettyPLSQL.removeWhiteSpace(input);
        return cleanInput.equals(cleanOutput = PrettyPLSQL.removeWhiteSpace(output));
    }

    public static String removeWhiteSpace(String input) {
        StringBuffer cleanInput = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) continue;
            cleanInput = cleanInput.append(c);
        }
        return cleanInput.toString();
    }
}

