/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.formatter;

import antlr.Token;
import oracle.dbtools.formatter.FormatOptions;
import oracle.dbtools.formatter.IFormatTokenLists;
import oracle.dbtools.formatter.TokenUtil;
import oracle.dbtools.formatter.parser.PLSQLTokenTypes;

public class TokenFormatterRules
implements PLSQLTokenTypes,
IFormatTokenLists {
    String result = "";
    int indentLevel = 0;
    boolean isGapBefore = false;
    boolean isGapBeforePrev = false;
    boolean isLineBefore = false;
    boolean isLineBeforePrev = false;
    boolean isSpaceBefore = false;
    boolean isSpaceBeforePrev = false;
    boolean isSpaceAfter = false;
    boolean isSpaceAfterPrev = false;
    boolean isLineAfter = false;
    boolean isLineAfterPrev = false;
    boolean isGapAfter = false;
    boolean isGapAfterPrev = false;
    int parenLevel = 0;
    FormatOptions fo = null;
    int[][] reservedwordsList = null;
    int[][] predicatesList = null;
    int[][] typesList = null;
    int[][] constantsList = null;
    int[][] functionsList = null;
    boolean isGapFromOrig = false;
    boolean isInList = false;
    int specialCalIndentBefore = 0;
    int specialCalIndentAfter = 0;
    boolean specialLineBefore = false;
    boolean specialLineAfter = false;
    int bracketLevel = 0;

    public Token formatToken(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = new int[]{TokenUtil.getTokenID(prevToken), TokenUtil.getTokenID(currToken), TokenUtil.getTokenID(nextToken)};
        if (tokenPattern[1] == 42 || tokenPattern[1] == 459 || tokenPattern[1] == 460) {
            System.out.println("stop here");
        }
        this.preFormat(currToken, prevToken, nextToken);
        this.calculateIndent(currToken, prevToken, nextToken, "before");
        currToken = this.setCase(currToken, prevToken, nextToken);
        currToken = this.indent(currToken, prevToken, nextToken);
        currToken = this.spaceBefore(currToken, prevToken, nextToken);
        currToken = this.lineBefore(currToken, prevToken, nextToken);
        currToken = this.gapBefore(currToken, prevToken, nextToken);
        currToken = this.lineAfter(currToken, prevToken, nextToken);
        currToken = this.gapAfter(currToken, prevToken, nextToken);
        this.calculateIndent(currToken, prevToken, nextToken, "after");
        this.result = currToken.getText();
        this.postFormat(currToken);
        return currToken;
    }

    private void nestProcess(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (this.contains(nestList, tokenPattern)) {
            if (currToken.getType() == 459) {
                this.specialCalIndentBefore = 1;
                this.specialLineBefore = true;
                ++this.parenLevel;
            } else if (currToken.getType() == 460 && this.inParen() && !this.inBracket()) {
                this.specialCalIndentAfter = -1;
                --this.parenLevel;
                if (nextToken.getType() != 456) {
                    this.specialLineAfter = true;
                }
            }
            if (currToken.getType() == 460) {
                --this.bracketLevel;
            }
        } else if (currToken.getType() == 459) {
            ++this.bracketLevel;
        }
        if (this.bracketLevel < 0) {
            this.bracketLevel = 0;
        }
    }

    private boolean inBracket() {
        return this.bracketLevel != 0;
    }

    private boolean inParen() {
        return this.parenLevel != 0;
    }

    private void listProcess(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (this.contains(startOfList, tokenPattern)) {
            this.specialCalIndentAfter = 1;
            this.isInList = true;
        }
        if (this.contains(endOfList, tokenPattern) && this.isInList) {
            this.specialCalIndentBefore = -1;
            this.isInList = false;
        }
        if (this.contains(startOfList, tokenPattern)) {
            this.isInList = true;
        }
        if (currToken.getType() == 456) {
            this.specialLineAfter = true;
        }
    }

    private void preFormat(Token currToken, Token prevToken, Token nextToken) {
        this.preFormat(currToken);
        this.nestProcess(currToken, prevToken, nextToken);
    }

    private void preFormat(Token t) {
        if (t != null && t.getText().startsWith("\n")) {
            this.isGapFromOrig = true;
            t.setText(t.getText().substring(1));
        }
    }

    private void calculateIndent(Token currToken, Token prevToken, Token nextToken, String pos) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (pos.equals("before")) {
            if (TokenUtil.arrayContains(unindentBeforeList, tokenPattern)) {
                --this.indentLevel;
            }
            if (TokenUtil.arrayContains(indentBeforeList, tokenPattern)) {
                ++this.indentLevel;
            }
            this.indentLevel += this.specialCalIndentBefore;
        } else if (pos.equals("after")) {
            if (this.contains(indentAfterList, tokenPattern)) {
                ++this.indentLevel;
            } else if (this.contains(unindentAfterList, tokenPattern)) {
                --this.indentLevel;
            }
            this.indentLevel += this.specialCalIndentAfter;
        }
    }

    private Token setCase(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (!this.contains(origCaseList, tokenPattern)) {
            if (this.contains(lowerCaseList, tokenPattern)) {
                if (this.fo.identifierCase.equals("lower")) {
                    currToken.setText(currToken.getText().toLowerCase());
                } else if (this.fo.identifierCase.equals("upper")) {
                    currToken.setText(currToken.getText().toUpperCase());
                }
            } else if (this.fo.keywordCase.equals("lower")) {
                currToken.setText(currToken.getText().toLowerCase());
            } else if (this.fo.keywordCase.equals("upper")) {
                currToken.setText(currToken.getText().toUpperCase());
            }
        }
        return currToken;
    }

    private Token indent(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (this.contains(newLineBeforeList, tokenPattern) || this.contains(gapBeforeList, tokenPattern) || this.isLineAfterPrev || this.isGapFromOrig || this.specialLineBefore || this.isListCommaNewLineRequired(currToken, "before")) {
            currToken.setText(this.getIndent() + currToken.getText());
        }
        return currToken;
    }

    private Token spaceBefore(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (prevToken == null) {
            return currToken;
        }
        if (!this.contains(newLineBeforeList, tokenPattern) && !this.isLineAfterPrev) {
            if (!this.contains(noSpaceBeforeList, tokenPattern) && !this.isSpaceAfterPrev) {
                currToken.setText(" " + currToken.getText());
                this.isSpaceBefore = true;
            }
            if (this.isSpaceAfterPrev) {
                this.isSpaceBefore = true;
            }
        }
        if (this.inParen() && (this.specialLineBefore || this.contains(newLineBeforeList, tokenPattern) && !this.isLineAfterPrev && !this.isGapAfterPrev || this.isListCommaNewLineRequired(prevToken, "after")) && currToken.getType() != 459) {
            currToken.setText(" " + currToken.getText());
        }
        if (this.fo.isListNewLines() && prevToken.getType() == 456) {
            currToken.setText(TokenUtil.getIndent(this.fo.getTabType(), this.fo.getTabSize(), 1) + currToken.getText());
        }
        return currToken;
    }

    private Token lineBefore(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if ((this.specialLineBefore || this.contains(newLineBeforeList, tokenPattern) || this.isListCommaNewLineRequired(currToken, "before")) && !this.isLineAfterPrev && !this.isGapAfterPrev) {
            currToken.setText("\n" + currToken.getText());
            this.isLineBefore = true;
        }
        if (currToken.getType() == 478) {
            this.isLineBefore = true;
        }
        if (this.isLineAfterPrev) {
            this.isLineBefore = true;
        }
        return currToken;
    }

    private Token gapBefore(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if ((this.contains(gapBeforeList, tokenPattern) || this.isGapFromOrig) && !this.isGapAfterPrev) {
            if (this.isLineBefore) {
                currToken.setText("\n" + currToken.getText());
            } else {
                currToken.setText("\n\n" + currToken.getText());
            }
        }
        return currToken;
    }

    private Token lineAfter(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (!this.inBracket() && (this.contains(newLineAfterList, tokenPattern) || this.specialLineAfter || this.isListCommaNewLineRequired(currToken, "after"))) {
            currToken.setText(currToken.getText() + "\n");
            this.isLineAfter = true;
        }
        if (currToken.getType() == 478) {
            this.isLineAfter = true;
        }
        return currToken;
    }

    private boolean isListCommaNewLineRequired(Token currToken, String beforeOrAfter) {
        return this.fo.isListNewLines() && (currToken.getType() == 456 && beforeOrAfter.equals("after") || currToken.getType() == 58 && beforeOrAfter.equals("before"));
    }

    private Token gapAfter(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (this.contains(gapAfterList, tokenPattern)) {
            if (this.isLineAfter) {
                currToken.setText(currToken.getText() + "\n");
            } else {
                currToken.setText(currToken.getText() + "\n\n");
            }
            this.isGapAfter = true;
        }
        return currToken;
    }

    private Token specialProcess(Token currToken, Token prevToken, Token nextToken) {
        int[] tokenPattern = TokenUtil.getTokenPattern(prevToken, currToken, nextToken);
        if (this.contains(specialCaseList, tokenPattern)) {
            // empty if block
        }
        return currToken;
    }

    TokenFormatterRules(FormatOptions fo) {
        this.fo = fo;
    }

    public String getIndent() {
        return TokenUtil.getIndent(this.fo.getTabType(), this.fo.getTabSize(), this.indentLevel);
    }

    public boolean contains(int[][] tokenPatterns, int[] tokenPattern) {
        return TokenUtil.arrayContains(tokenPatterns, tokenPattern);
    }

    public boolean contains(int[] tokenPatterns, int[] tokenPattern) {
        return TokenUtil.isPatternMatched(tokenPatterns, tokenPattern);
    }

    public void postFormat(Token currToken) {
        this.isGapBeforePrev = this.isGapBefore;
        this.isGapBefore = false;
        this.isLineBeforePrev = this.isLineBefore;
        this.isLineBefore = false;
        this.isSpaceBeforePrev = this.isSpaceBefore;
        this.isSpaceBefore = false;
        this.isSpaceAfterPrev = this.isSpaceAfter;
        this.isSpaceAfter = false;
        this.isLineAfterPrev = this.isLineAfter;
        this.isLineAfter = false;
        this.isGapAfterPrev = this.isGapAfter;
        this.isGapAfter = false;
        this.isGapFromOrig = false;
        this.specialCalIndentBefore = 0;
        this.specialCalIndentAfter = 0;
        this.specialLineBefore = false;
        this.specialLineAfter = false;
    }
}

