/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.formatter;

import antlr.Token;
import java.io.StringReader;
import java.util.ArrayList;
import oracle.dbtools.formatter.FormatOptions;
import oracle.dbtools.formatter.parser.PLSQLLexer;

public class TokenUtil {
    private static StringBuffer _output = new StringBuffer();

    public static int[][] createTokenIDArray(String[] strArray) {
        PLSQLLexer p = new PLSQLLexer(new StringReader("a"));
        int[][] intArray = new int[strArray.length][3];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i][0] = 0;
            intArray[i][1] = p.getTokenID(strArray[i]);
            intArray[i][2] = 0;
        }
        return intArray;
    }

    public static boolean arrayContains(int[][] patternArray, int[] tokenPattern) {
        int[] currPattern;
        int i;
        for (i = 0; i < patternArray.length; ++i) {
            currPattern = TokenUtil.getTokenPattern(patternArray, i);
            if (!TokenUtil.isBadPatternMatched(currPattern, tokenPattern)) continue;
            return false;
        }
        for (i = 0; i < patternArray.length; ++i) {
            currPattern = TokenUtil.getTokenPattern(patternArray, i);
            if (!TokenUtil.isPatternMatched(currPattern, tokenPattern)) continue;
            return true;
        }
        return false;
    }

    public static int[] getTokenPattern(int[][] patternArray, int pos) {
        int size = patternArray[pos].length;
        int[] tokenPattern = new int[size];
        for (int i = 0; i < size; ++i) {
            tokenPattern[i] = patternArray[pos][i];
        }
        return tokenPattern;
    }

    public static int[] getTokenPattern(Token prevToken, Token currToken, Token nextToken) {
        int[] tokenPattern = new int[]{TokenUtil.getTokenID(prevToken), TokenUtil.getTokenID(currToken), TokenUtil.getTokenID(nextToken)};
        return tokenPattern;
    }

    public static boolean arrayContains(int[] patternArray, int tokenPattern) {
        for (int i = 0; i < patternArray.length; ++i) {
            if (patternArray[i] != tokenPattern) continue;
            return true;
        }
        return false;
    }

    public static boolean isPatternMatched(int[] pattern, int[] tokenPattern) {
        if (pattern.length != tokenPattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == 0) continue;
            if (pattern[i] < 0) {
                int positiveValue = pattern[i];
                if ((positiveValue *= -1) != tokenPattern[i]) continue;
                return false;
            }
            if (pattern[i] == tokenPattern[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBadPatternMatched(int[] pattern, int[] tokenPattern) {
        boolean negativeFound = false;
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == 0) continue;
            if (pattern[i] < 0) {
                negativeFound = true;
                int positiveValue = pattern[i];
                if ((positiveValue *= -1) == tokenPattern[i]) continue;
                return false;
            }
            if (pattern[i] == tokenPattern[i]) continue;
            return false;
        }
        return negativeFound;
    }

    public static String generateOutput(ArrayList tokenList, FormatOptions fo) {
        String output = "";
        Token currToken = null;
        String currStr = "";
        int widthSize = fo.getWidthSize();
        boolean isWrapOn = fo.isWrapOn();
        StringBuffer outputBuffer = new StringBuffer();
        for (int i = 0; i < tokenList.size(); ++i) {
            currToken = (Token)tokenList.get(i);
            currStr = currToken.getText();
            TokenUtil.addToOutput(currStr, outputBuffer, widthSize, isWrapOn);
        }
        output = outputBuffer.toString();
        outputBuffer = null;
        return output;
    }

    private static void addToOutput(String currStr, StringBuffer outputBuffer, int widthSize, boolean wrapOn) {
        String smallTab = "";
        String currTab = "";
        StringBuffer temp = new StringBuffer(outputBuffer.toString() + currStr);
        int lastIndexOfLineSeperator = temp.lastIndexOf("\n");
        int tempoutputSize = temp.length();
        int numOfCharOnLastLine = tempoutputSize - lastIndexOfLineSeperator;
        if (wrapOn && numOfCharOnLastLine > widthSize) {
            boolean isBreakPractical = TokenUtil.isbreakPractical(currStr, outputBuffer);
            if (isBreakPractical) {
                currTab = TokenUtil.getLastIndent(outputBuffer);
                outputBuffer.append("\n" + currTab + smallTab + TokenUtil.ltrim(currStr));
            } else {
                outputBuffer.append(currStr);
            }
        } else {
            outputBuffer.append(currStr);
        }
    }

    private static boolean isbreakPractical(String currStr, StringBuffer outputBuffer) {
        return Character.isWhitespace(currStr.charAt(0)) || Character.isWhitespace(outputBuffer.charAt(outputBuffer.length()));
    }

    private static String getLastIndent(StringBuffer outputBuffer) {
        int start = outputBuffer.lastIndexOf("\n");
        String indent = "";
        for (int i = start + 1; i < outputBuffer.length() && Character.isWhitespace(outputBuffer.charAt(i)); ++i) {
            indent = indent + outputBuffer.charAt(i);
        }
        return indent;
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static int getTokenID(Token t1) {
        int t1ID = t1 == null ? 0 : t1.getType();
        return t1ID;
    }

    public static String getIndent(String indentType, int indentSize, int numberOfIndents) {
        String indentStr = "";
        for (int i = 1; i <= numberOfIndents; ++i) {
            indentStr = indentStr + TokenUtil.getOneIndent(indentType, indentSize);
        }
        return indentStr;
    }

    public static String getOneIndent(String indentType, int indentSize) {
        String indentStr = "";
        String spacer = "";
        spacer = indentType.equalsIgnoreCase("space") ? " " : (indentType.equalsIgnoreCase("tab") ? "\t" : " ");
        for (int i = 1; i <= indentSize; ++i) {
            indentStr = indentStr + spacer;
        }
        return indentStr;
    }

    public static boolean isGap(Token currToken, boolean prevTokenSLComment) {
        String str = currToken.getText();
        if (str == null) {
            return false;
        }
        int firstOccurance = str.indexOf("\n");
        if (str.length() < firstOccurance + 1) {
            return false;
        }
        int secondOccurance = str.indexOf("\n", firstOccurance + 1);
        if (firstOccurance != -1 && secondOccurance != -1) {
            return true;
        }
        return firstOccurance != -1 && prevTokenSLComment;
    }
}

