/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlformatter;

import oracle.dbtools.formatter.FormatOptions;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.util.Copyable;

public final class ConfigData
extends ChangeEventSource
implements Copyable {
    public static final String KEY = "IdeSettings4SQLFormatter0.4";
    private String tabType = "Spaces Only";
    private String tabSize = "2";
    private String keywordCase = "Upper Case";
    private String identifierCase = "Lower Case";
    private boolean keepNewLines = true;
    private boolean listItems = true;
    private String widthSize = "80";
    private boolean wrapOn = false;

    public Object copyTo(Object target) {
        ConfigData copy = target != null ? (ConfigData)((Object)target) : new ConfigData();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(ConfigData copy) {
        copy.setIdentifierCase(this.getIdentifierCase());
        copy.setKeywordCase(this.getKeywordCase());
        copy.setKeepNewLines(this.isKeepNewLines());
        copy.setTabSize(this.getTabSize());
        copy.setTabType(this.getTabType());
        copy.setListItems(this.getListItems());
        copy.setWidthSize(this.getWidthSize());
        copy.setWrapOn(this.isWrapOn());
        copy.fireChangeEvent();
    }

    public boolean isWrapOn() {
        return this.wrapOn;
    }

    public void setWrapOn(boolean wrapOn) {
        this.wrapOn = wrapOn;
    }

    public String getWidthSize() {
        return this.widthSize;
    }

    public void setWidthSize(String size) {
        this.widthSize = size;
    }

    public boolean getListItems() {
        return this.listItems;
    }

    public void setListItems(boolean listItems) {
        this.listItems = listItems;
    }

    public String getTabType() {
        return this.tabType;
    }

    public void setTabType(String tabType) {
        this.tabType = tabType;
    }

    public String getTabSize() {
        if (this.tabSize.trim().length() == 0) {
            this.tabSize = "2";
        }
        return this.tabSize;
    }

    public void setTabSize(String tabSize) {
        this.tabSize = tabSize;
    }

    public String getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(String keywordCase) {
        this.keywordCase = keywordCase;
    }

    public String getIdentifierCase() {
        return this.identifierCase;
    }

    public void setIdentifierCase(String identifierCase) {
        this.identifierCase = identifierCase;
    }

    public boolean isKeepNewLines() {
        return this.keepNewLines;
    }

    public void setKeepNewLines(boolean keepNewLines) {
        this.keepNewLines = keepNewLines;
    }

    public FormatOptions getFormatOptions() {
        FormatOptions fo = new FormatOptions();
        if (this.getIdentifierCase().equals("Upper Case")) {
            fo.setIdentifierCase("upper");
        } else if (this.getIdentifierCase().equals("Lower Case")) {
            fo.setIdentifierCase("lower");
        } else if (this.getIdentifierCase().equals("Original Case")) {
            fo.setIdentifierCase("orig");
        }
        if (this.getKeywordCase().equals("Upper Case")) {
            fo.setKeywordCase("upper");
        } else if (this.getKeywordCase().equals("Lower Case")) {
            fo.setKeywordCase("lower");
        } else if (this.getKeywordCase().equals("Original Case")) {
            fo.setKeywordCase("orig");
        }
        int tabSizeInt = 2;
        int widthSizeInt = 80;
        try {
            tabSizeInt = Integer.parseInt(this.getTabSize().trim());
            widthSizeInt = Integer.parseInt(this.getWidthSize().trim());
        }
        catch (Exception e) {
            tabSizeInt = 2;
            widthSizeInt = 80;
        }
        fo.setTabSize(tabSizeInt);
        fo.setWidthSize(widthSizeInt);
        if (this.getTabType().equals("Spaces Only")) {
            fo.setTabType("space");
        } else if (this.getTabType().equals("Tabs Only")) {
            fo.setTabType("tab");
        }
        fo.setKeepNewLines(this.isKeepNewLines());
        fo.setListNewLines(this.listItems);
        fo.setWrapOn(this.isWrapOn());
        return fo;
    }
}

