/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlformatter;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import oracle.dbtools.sqlformatter.ConfigData;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public final class ConfigPanelData
extends DefaultTraversablePanel {
    public static final String TITLE = "SQL Formatter";
    private JLabel tabSizeLabel;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ButtonGroup group = new ButtonGroup();
    private JLabel tabPolicyLabel = new JLabel();
    private JComboBox tabPolicyValue = new JComboBox();
    private JComboBox keywordCaseValue = new JComboBox();
    private JLabel keywordCase = new JLabel();
    private JLabel identifierCaseLabel = new JLabel();
    private JComboBox identifierCaseValue = new JComboBox();
    private JLabel preserveEmptyLinesLabel = new JLabel();
    private JCheckBox preserveEmptyLinesValue = new JCheckBox();
    private JFormattedTextField tabSizeValue = new JFormattedTextField();
    private JSeparator jSeparator1 = new JSeparator();
    private JSeparator jSeparator2 = new JSeparator();
    private JSeparator jSeparator3 = new JSeparator();
    private JSeparator jSeparator4 = new JSeparator();
    private JSeparator jSeparator5 = new JSeparator();
    private JSeparator jSeparator6 = new JSeparator();
    private JSeparator jSeparator7 = new JSeparator();
    private JLabel listLabel = new JLabel();
    private JLabel widthLabel = new JLabel();
    private JCheckBox listItemsValue = new JCheckBox();
    private JFormattedTextField widthSizeValue = new JFormattedTextField();
    private JCheckBox wrapOnOff = new JCheckBox();

    public ConfigPanelData() {
        this.setHelpID("f1_idedidesetsqlformat_html");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.tabSizeLabel = new JLabel();
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(232, 120));
        this.tabSizeLabel.setText("Tab Size:");
        this.tabSizeLabel.setAlignmentY(0.0f);
        this.tabSizeLabel.setToolTipText("null");
        this.tabSizeLabel.setHorizontalAlignment(2);
        this.tabSizeLabel.setHorizontalTextPosition(2);
        this.tabSizeLabel.setAlignmentX(0.5f);
        this.tabPolicyLabel.setText("Tab Policy:");
        this.tabPolicyLabel.setAlignmentY(0.0f);
        this.tabPolicyLabel.setToolTipText("null");
        this.tabPolicyLabel.setHorizontalAlignment(2);
        this.tabPolicyLabel.setHorizontalTextPosition(2);
        this.tabPolicyLabel.setAlignmentX(0.5f);
        this.tabPolicyValue.setPreferredSize(new Dimension(100, 20));
        this.tabPolicyValue.addItem("Spaces Only");
        this.tabPolicyValue.addItem("Tabs Only");
        this.keywordCaseValue.setPreferredSize(new Dimension(100, 20));
        this.keywordCaseValue.addItem("Upper Case");
        this.keywordCaseValue.addItem("Lower Case");
        this.keywordCaseValue.addItem("Original Case");
        this.keywordCase.setText("Keyword Case:");
        this.keywordCase.setAlignmentY(0.0f);
        this.keywordCase.setToolTipText("null");
        this.keywordCase.setHorizontalAlignment(2);
        this.keywordCase.setHorizontalTextPosition(2);
        this.keywordCase.setAlignmentX(0.5f);
        this.identifierCaseLabel.setText("Identifier Case:");
        this.identifierCaseLabel.setAlignmentY(0.0f);
        this.identifierCaseLabel.setToolTipText("null");
        this.identifierCaseLabel.setHorizontalAlignment(2);
        this.identifierCaseLabel.setHorizontalTextPosition(2);
        this.identifierCaseLabel.setAlignmentX(0.5f);
        this.identifierCaseValue.setPreferredSize(new Dimension(100, 20));
        this.identifierCaseValue.addItem("Lower Case");
        this.identifierCaseValue.addItem("Upper Case");
        this.identifierCaseValue.addItem("Original Case");
        this.preserveEmptyLinesLabel.setText("Preserve Empty Lines:");
        this.preserveEmptyLinesLabel.setAlignmentX(0.0f);
        this.preserveEmptyLinesValue.setAlignmentX(0.5f);
        this.preserveEmptyLinesValue.setSelected(true);
        this.listLabel.setText("List items separately:");
        this.listLabel.setAlignmentX(0.0f);
        this.widthLabel.setText("Maximum Line Width:");
        this.widthLabel.setAlignmentX(0.0f);
        this.listItemsValue.setAlignmentX(0.5f);
        this.listItemsValue.setSelected(true);
        this.widthSizeValue.setSize(new Dimension(20, 20));
        this.widthSizeValue.setMinimumSize(new Dimension(7, 200));
        this.widthSizeValue.setPreferredSize(new Dimension(100, 20));
        this.wrapOnOff.setText("Wrap On");
        this.tabSizeValue.setSize(new Dimension(20, 20));
        this.tabSizeValue.setMinimumSize(new Dimension(7, 200));
        this.tabSizeValue.setPreferredSize(new Dimension(100, 20));
        this.add(this.tabSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tabSizeValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add(this.jSeparator1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tabPolicyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tabPolicyValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jSeparator2, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.keywordCase, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.keywordCaseValue, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jSeparator3, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.identifierCaseLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.identifierCaseValue, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jSeparator4, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.widthLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.widthSizeValue, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add(this.jSeparator5, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.preserveEmptyLinesLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.preserveEmptyLinesValue, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jSeparator6, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.listLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.listItemsValue, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jSeparator7, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.wrapOnOff, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        ConfigData options = (ConfigData)((Object)tc.find("IdeSettings4SQLFormatter0.4"));
        this.load(options);
    }

    public void onExit(TraversableContext tc) {
        ConfigData options = (ConfigData)((Object)tc.find("IdeSettings4SQLFormatter0.4"));
        this.commit(options);
    }

    private void load(ConfigData options) {
        this.tabSizeValue.setText(options.getTabSize());
        this.tabPolicyValue.setSelectedItem(options.getTabType());
        this.keywordCaseValue.setSelectedItem(options.getKeywordCase());
        this.identifierCaseValue.setSelectedItem(options.getIdentifierCase());
        this.preserveEmptyLinesValue.setSelected(options.isKeepNewLines());
        this.listItemsValue.setSelected(options.getListItems());
        this.widthSizeValue.setText(options.getWidthSize());
        this.wrapOnOff.setSelected(options.isWrapOn());
    }

    private void commit(ConfigData options) {
        options.setTabSize(this.tabSizeValue.getText());
        options.setIdentifierCase((String)this.identifierCaseValue.getSelectedItem());
        options.setKeywordCase((String)this.keywordCaseValue.getSelectedItem());
        options.setTabType((String)this.tabPolicyValue.getSelectedItem());
        options.setKeepNewLines(this.preserveEmptyLinesValue.isSelected());
        options.setListItems(this.listItemsValue.isSelected());
        options.setWidthSize(this.widthSizeValue.getText());
        options.setWrapOn(this.wrapOnOff.isSelected());
    }
}

