/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlformatter;

import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.formatter.FormatOptions;
import oracle.dbtools.formatter.PrettyPLSQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.sqlformatter.ConfigData;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;

public class SQLFormatCommand
extends Command {
    private UndoableEdit _undoableEdit;

    public SQLFormatCommand(Context context) {
        super(-1, 0, "Format SQL Command");
        this.setContext(context);
    }

    public int doit() {
        if (this._undoableEdit == null) {
            TextBuffer textBuffer = null;
            TextNode textNode = null;
            Node node = this.context.getNode();
            View view = this.context.getView();
            if (node.getClass().getName().endsWith("sqlview.SqlEditorNode")) {
                try {
                    List myList = (List)node;
                    String gotText = (String)myList.get(0);
                    if (gotText == null | gotText.trim().equals("")) {
                        return 1;
                    }
                    ConfigData opts = (ConfigData)((Object)Ide.getSettings().getData("IdeSettings4SQLFormatter0.4"));
                    String formattedSource = this.formatScript(gotText);
                    myList.add(formattedSource);
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 1;
                }
            }
            if (view instanceof SqlEditor) {
                try {
                    String source = ((SqlEditor)view).getText();
                    if (source == null || source.trim().equals("")) {
                        return 1;
                    }
                    String formattedSource = this.formatScript(source);
                    ((SqlEditor)view).setText(formattedSource);
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 1;
                }
            }
            try {
                textNode = (TextNode)node;
                textBuffer = textNode.acquireTextBuffer();
                if (textBuffer.getLength() == 0) {
                    return 1;
                }
            }
            catch (Exception e) {
                return 1;
            }
            textBuffer.beginEdit();
            String formattedSource = this.formatSQL(textBuffer);
            textBuffer.removeToEnd(0);
            textBuffer.append(formattedSource.toCharArray());
            this._undoableEdit = textBuffer.endEdit();
            textNode.markDirty(true);
            textNode.releaseTextBuffer();
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    public String formatScript(String input) {
        String formattedOutput = "";
        ScriptParser parser = new ScriptParser(input);
        parser.parse();
        SQLCommand[] cmds = parser.getSqlStatements();
        int currentLine = 0;
        int lastLine = 0;
        for (int i = 0; i < cmds.length; ++i) {
            SQLCommand sqlCmd = cmds[i];
            lastLine = sqlCmd.endLine;
            boolean isSQLPlusCmd = this.isSQLPlus(sqlCmd);
            if (this.isNextCmd(sqlCmd, currentLine)) {
                String cmd = "";
                if (!sqlCmd.getSQLOrig().trim().equals("")) {
                    cmd = this.getSubStr(input, sqlCmd.startLine, sqlCmd.endLine);
                    formattedOutput = formattedOutput + this.processFormatScript(cmd, isSQLPlusCmd);
                }
                currentLine = sqlCmd.endLine + 1;
                continue;
            }
            int nextStart = sqlCmd.startLine;
            String missedCmd = this.getSubStr(input, currentLine, nextStart - 1);
            if (!missedCmd.trim().equals("")) {
                formattedOutput = formattedOutput + this.processFormatScript(missedCmd, false);
            }
            currentLine = nextStart;
            --i;
        }
        if (formattedOutput.equals("") && !input.trim().equals("")) {
            String missedCmd = input;
            formattedOutput = formattedOutput + this.processFormatScript(missedCmd, false);
        }
        if (!PrettyPLSQL.verifyResult(input, formattedOutput)) {
            Ide.getStatusBar().setText("Formatting Failed");
            return input;
        }
        Ide.getStatusBar().setText("Formatting Succeeded");
        return formattedOutput;
    }

    private String getSubStr(String input, int startLine) {
        String result = "";
        int currStartLine = 0;
        for (int i = 0; i < startLine; ++i) {
            currStartLine = input.indexOf("\n", currStartLine + 1);
        }
        if (currStartLine != -1) {
            result = input.substring(currStartLine);
        }
        return result;
    }

    private String getSubStr(String input, int startLine, int endLine) {
        int i;
        int currStartLine = 0;
        int currEndLine = 0;
        for (i = 0; i < startLine; ++i) {
            currStartLine = input.indexOf("\n", currStartLine + 1);
        }
        for (i = 0; i <= endLine; ++i) {
            if ((currEndLine = input.indexOf("\n", currEndLine + 1)) != -1) continue;
            i = endLine + 1;
        }
        String result = "";
        try {
            result = currEndLine != -1 ? input.substring(currStartLine, currEndLine) : input.substring(currStartLine);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private boolean isNextCmd(SQLCommand sqlCmd, int currentLine) {
        return sqlCmd.startLine == currentLine;
    }

    private String processFormatScript(String stmtStr, boolean isSQLPlusCmd) {
        String formattedOutput = "";
        FormatOptions fo = this.getFormatOptions();
        if (stmtStr.trim().length() != 0) {
            if (isSQLPlusCmd) {
                fo.setSQLPlus(true);
                formattedOutput = formattedOutput.endsWith("-") ? formattedOutput + this.formatSubScript(stmtStr, fo) : formattedOutput + this.addGaps(this.formatSubScript(stmtStr, fo));
            } else {
                fo.setSQLPlus(false);
                formattedOutput = formattedOutput + this.addGaps(this.formatSubScript(stmtStr, fo));
            }
        }
        return formattedOutput;
    }

    private String addGaps(String stmt) {
        stmt = stmt.trim() + "\n\n";
        return stmt;
    }

    private boolean isSQLPlus(SQLCommand sqlCmd) {
        String sqlCmdType = sqlCmd.getStmtClass();
        return sqlCmdType.equals("4");
    }

    private SQLCommand addSlashAndSemiColon(SQLCommand sqlCmd) {
        String sqlCmdType = sqlCmd.getStmtClass();
        SQLCommand result = sqlCmd;
        if (sqlCmdType.equals("3")) {
            result.setSQLOrig(sqlCmd.getSQLOrig() + "\n/");
        } else if (sqlCmdType.equals("2") && !result.getSQLOrig().toLowerCase().startsWith("desc")) {
            result.setSQLOrig(sqlCmd.getSQLOrig() + ";");
        }
        return result;
    }

    private String formatSubScript(String input, FormatOptions fo) {
        String formattedSource = "";
        PrettyPLSQL formatter = new PrettyPLSQL();
        if (input == null || input.trim().equals("")) {
            return input;
        }
        try {
            formattedSource = formatter.format(input, fo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedSource;
    }

    public int undo() {
        if (this._undoableEdit != null) {
            this._undoableEdit.undo();
        }
        return 0;
    }

    private String formatSQL(TextBuffer textBuffer) {
        int length = textBuffer.getLength();
        char[] charData = textBuffer.getChars(0, length);
        String source = new String(charData);
        PrettyPLSQL formatter = new PrettyPLSQL();
        FormatOptions fo = this.getFormatOptions();
        fo.setSQLPlus(false);
        if (source == null || source.trim().equals("")) {
            return source;
        }
        String formattedSource = formatter.format(source, fo);
        return formattedSource;
    }

    private FormatOptions getFormatOptions() {
        ConfigData opts = (ConfigData)((Object)Ide.getSettings().getData("IdeSettings4SQLFormatter0.4"));
        FormatOptions fo = new FormatOptions();
        if (opts != null && (fo = opts.getFormatOptions()) == null) {
            fo = new FormatOptions();
        }
        return fo;
    }
}

