/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlformatter;

import java.awt.Component;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import oracle.dbtools.sqlformatter.ConfigData;
import oracle.dbtools.sqlformatter.ConfigPanelData;
import oracle.dbtools.sqlformatter.SQLFormatCommand;
import oracle.dbtools.sqlformatter.SQLFormatterArb;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.panels.Navigable;
import oracle.javatools.util.Copyable;

public class SQLFormatter
implements Addin,
Controller {
    private static JMenuItem contextMenuItem = null;
    public static final int FORMAT_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.sqlformatter.SQLFormatter.FORMAT_ID");
    private static final String FORMAT_STR_ID = "oracle.dbtools.sqlformatter";
    private Icon _icon;
    private final String ACCELERATOR_FILE = "oracle/dbtools/sqlformatter/accelerators.xml";

    public void initialize() {
        JMenuItem mainMenuItem = this.createMenu_FORMAT_ID(SQLFormatterArb.getString(1), SQLFormatterArb.getString(0), -1);
        ctxMenuListener ctxMenuLstnr1 = new ctxMenuListener(mainMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)ctxMenuLstnr1);
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)FORMAT_STR_ID);
        if (clientSetting.getData("IdeSettings4SQLFormatter0.4") == null) {
            clientSetting.putData("IdeSettings4SQLFormatter0.4", (Copyable)new ConfigData());
        }
        Navigable myIdeSettingsPanel = new Navigable("SQL Formatter", ConfigPanelData.class);
        IdeSettings.registerUI((Navigable)myIdeSettingsPanel);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/dbtools/sqlformatter/accelerators.xml");
    }

    public void shutdown() {
    }

    public float version() {
        return 1.0f;
    }

    public boolean canShutdown() {
        return true;
    }

    public String getName() {
        return "SQLFormatter";
    }

    public String getMenuLabel() {
        return null;
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public Icon getIcon() {
        URL url;
        if (this._icon == null && (url = this.getClass().getResource("format.png")) != null) {
            this._icon = new ImageIcon(url);
        }
        return this._icon;
    }

    public boolean invoke(Context context, String[] params) {
        this.executeCommand(context);
        return true;
    }

    private boolean executeCommand(Context context) {
        SQLFormatCommand sfc = new SQLFormatCommand(context);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            if (commandProcessor.invoke((Command)sfc) == 1) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private Icon loadIcon(String iconName) {
        URL url = this.getClass().getResource(iconName);
        ImageIcon icon = null;
        if (url != null) {
            icon = new ImageIcon(url);
        }
        return icon;
    }

    private JMenuItem createMenu_FORMAT_ID(String iconName, String menuLabel, int mnemonic) {
        String cmdClass = null;
        String category = null;
        Object data = null;
        boolean enabled = true;
        IdeAction action = IdeAction.get((int)FORMAT_ID, cmdClass, (String)menuLabel, category, null, (ResourceBundle)SQLFormatterArb.getInstance(), (String)iconName, null, (boolean)true);
        action.addController((Controller)this);
        JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)action);
        return menuItem;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == FORMAT_ID) {
            this.invoke(context, null);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == FORMAT_ID) {
            action.setEnabled(this.is_FORMAT_ID_Available(context));
            return true;
        }
        return false;
    }

    private boolean is_FORMAT_ID_Available(Context context) {
        return true;
    }

    private JMenuItem getContextMenuItem() {
        if (contextMenuItem == null) {
            contextMenuItem = this.createMenu_FORMAT_ID("format.png", "Format SQL...", 73);
        }
        return contextMenuItem;
    }

    public void poppingUp(ContextMenu popup) {
        popup.add((Component)this.getContextMenuItem());
    }

    public void poppingDown(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public static boolean isMenuAvailable(Context context) {
        return true;
    }

    private static final class ctxMenuListener
    implements ContextMenuListener {
        private JMenuItem menuItem;

        ctxMenuListener(JMenuItem ctxMenuItem) {
            this.menuItem = ctxMenuItem;
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu popup) {
            Context context;
            Context context2 = context = popup == null ? null : popup.getContext();
            if (context == null) {
                return;
            }
            if (SQLFormatter.isMenuAvailable(context)) {
                popup.add((Component)this.menuItem);
            }
        }
    }
}

