/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.SAXParserFactory;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.snippet.Resources;
import oracle.dbtools.raptor.snippet.SaxHandler;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetPanel;
import oracle.dbtools.raptor.snippet.SnippetWindow;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import org.xml.sax.helpers.DefaultHandler;

public class SnippetAddin
implements DockableFactory,
Addin,
Controller,
IdeActivationListener,
EditorListener {
    static final String VIEW_TYPE = "SNIPPET_VIEW_TYPE";
    private SnippetWindow _snippetWindow;
    private HashMap<String, HashMap<String, List<Snippet>>> _languages;
    private File _snippetFile;
    private final ArrayList<ChangeListener> _changeListeners = new ArrayList();
    private int _viewSnippetActionId;
    private HashMap<String, Long> _modifed = new HashMap();
    private SAXParserFactory _factory;
    private long _lastFileChanged;
    private boolean _reloadBase = true;
    private boolean _loadingInProgress = false;
    private static ArrayList<URL> _registeredSnippets = new ArrayList();

    public static synchronized void registerSnippet(URL url) {
        _registeredSnippets.add(url);
    }

    public void initialize() {
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory(VIEW_TYPE, (DockableFactory)this);
        }
        catch (Exception e) {
            System.err.print("Snippet Dockable failed");
            e.printStackTrace();
        }
        try {
            Ide.getMainWindow().addIdeActivationListener((IdeActivationListener)this);
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
        }
        catch (Exception e) {
            System.err.print("Snippet Editor Listener failed");
            e.printStackTrace();
        }
        try {
            this.createActions();
        }
        catch (Exception e) {
            System.err.print("Snippet Actions failed");
            e.printStackTrace();
        }
    }

    private void createActions() {
        this._viewSnippetActionId = Ide.findOrCreateCmdID((String)"ViewSnippet");
        String label = Resources.getString(1);
        IdeAction firstAction = IdeAction.get((int)this._viewSnippetActionId, null, (String)StringUtils.stripMnemonic((String)label), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (ArrayResourceBundle)Resources.getInstance(), (int)2, null, (boolean)true);
        firstAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem firstActionMenu = menubar.createMenuItem((ToggleAction)firstAction, MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE + 0.001f);
        menubar.add((Component)firstActionMenu, MenuManager.getJMenu((String)"View"));
    }

    public void install() {
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(1);
        DockStation dockStation = DockStation.getDockStation();
        SnippetWindow snippetWindow = this.getSnippetWindow();
        dockStation.dock((Dockable)snippetWindow, dockingParam);
    }

    public Dockable getDockable(ViewId viewId) {
        return this.getSnippetWindow();
    }

    private SnippetWindow getSnippetWindow() {
        if (this._snippetWindow == null) {
            this._snippetWindow = new SnippetWindow();
        }
        return this._snippetWindow;
    }

    public long lastFileLoad() {
        return this._lastFileChanged;
    }

    public String[] getCategories(String language) {
        this.load();
        HashMap<String, List<Snippet>> hashMap = this._languages.get(language);
        Set<String> categories = hashMap != null ? hashMap.keySet() : Collections.EMPTY_SET;
        return categories.toArray(new String[categories.size()]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(changeListener);
    }

    void load(File snippetFile, boolean force) {
        if (force || this._modifed.get(snippetFile.getAbsolutePath()) == null || snippetFile.lastModified() != this._modifed.get(snippetFile.getAbsolutePath()).longValue()) {
            this._lastFileChanged = System.currentTimeMillis();
            this._modifed.put(snippetFile.getAbsolutePath(), snippetFile.lastModified());
            try {
                this.load(new FileInputStream(snippetFile));
                this._reloadBase = true;
            }
            catch (Exception e) {
                System.err.print("Count not load snippet File:" + snippetFile.getAbsolutePath());
            }
        }
    }

    void load(InputStream in) {
        try {
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
            }
            this._factory.setValidating(false);
            SaxHandler handler = new SaxHandler(this._languages);
            this._factory.newSAXParser().parse(in, (DefaultHandler)handler);
            this._lastFileChanged = System.currentTimeMillis();
        }
        catch (Exception e) {
            System.err.println("Error in loading snippets");
        }
    }

    public void load() {
        this.load(false);
    }

    public void load(boolean force) {
        if (this._languages == null) {
            HashMap languages = new HashMap();
            this._languages = languages;
        }
        if (System.getProperty("raptor.user.snippets") != null) {
            String[] files = System.getProperty("raptor.user.snippets").split("[:;]");
            File f = null;
            for (int i = 0; i < files.length; ++i) {
                f = new File(files[i]);
                if (!f.exists()) continue;
                this.load(f, force);
            }
        }
        if (this._reloadBase || force) {
            try {
                for (URL url : _registeredSnippets) {
                    try {
                        InputStream in = url.openStream();
                        this.load(in);
                        in.close();
                    }
                    catch (Exception e) {
                        System.err.println("Could not load snippet:" + url.toString());
                    }
                }
                this.load(Resource.getResourceAsStream(this.getClass(), (String)"snippets.xml"));
                this._reloadBase = false;
            }
            catch (Exception e) {
                System.err.print("Could not load base snippet file:" + e.getMessage());
            }
            this.fireChangeEvent();
        }
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListeners = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener changeListener = changeListeners[i];
            try {
                changeListener.stateChanged(event);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List getSnippets(String language, String category) {
        HashMap<String, List<Snippet>> categories = this._languages.get(language);
        List<Snippet> snippets = categories.get(category);
        return new ArrayList<Snippet>(snippets);
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() != this._viewSnippetActionId) {
            return false;
        }
        DockStation dockStation = DockStation.getDockStation();
        dockStation.activateDockable((Dockable)this._snippetWindow);
        return true;
    }

    public void activated(IdeActivationEvent e) {
        this.load();
    }

    public void deactivated(IdeActivationEvent e) {
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        CodeEditor codeEditor;
        Context context;
        Node node;
        if (editor instanceof CodeEditor && (node = (context = (codeEditor = (CodeEditor)editor).getContext()).getNode()) instanceof PlSqlBaseNode) {
            SnippetPanel snippetPanel = (SnippetPanel)this._snippetWindow.getGUI();
            snippetPanel.setLanguage("PLSQL");
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
    }
}

