/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.snippet.InsertSnippetCommand;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.raptor.snippet.SnippetRenderer;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;

public class SnippetPanel
extends JPanel
implements DragGestureListener,
DragSourceListener,
ItemListener,
ChangeListener,
MouseListener,
KeyListener {
    private JComboBox _categories;
    private JList _snippets;
    private DefaultListModel _snippetListModel;
    private DragSource _dragSource;
    private DefaultComboBoxModel _categoryModel;
    private String _language = "PLSQL";
    private long _lastFileProcessed = 0L;

    public SnippetPanel() {
        super(new BorderLayout());
        SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
        snippetAddin.addChangeListener(this);
        this._categoryModel = new DefaultComboBoxModel();
        this._categories = new JComboBox(this._categoryModel);
        this._categories.addItemListener(this);
        this._snippetListModel = new DefaultListModel();
        this._snippets = new JList(this._snippetListModel);
        this._snippets.setSelectionMode(0);
        this._snippets.setCellRenderer(new SnippetRenderer());
        this._snippets.addMouseListener(this);
        this._snippets.addKeyListener(this);
        this._dragSource = new DragSource();
        this._dragSource.createDefaultDragGestureRecognizer(this._snippets, 1, this);
        JScrollPane scrollPane = new JScrollPane(this._snippets);
        this.add((Component)this._categories, "North");
        this.add((Component)scrollPane, "Center");
        this.fillCategories();
        if (this._categoryModel.getSize() > 0) {
            this._categories.setSelectedIndex(0);
        }
    }

    public void fillCategories() {
        SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
        Object[] categories = snippetAddin.getCategories(this._language);
        if (this._lastFileProcessed < snippetAddin.lastFileLoad()) {
            this._categoryModel.removeAllElements();
            Arrays.sort(categories);
            for (int i = 0; i < categories.length; ++i) {
                Object category = categories[i];
                this._categoryModel.addElement(category);
            }
            this._lastFileProcessed = snippetAddin.lastFileLoad();
        }
    }

    private static SnippetAddin getSnippetAddin() {
        AddinManager addinManager = AddinManager.getAddinManager();
        SnippetAddin snippetAddin = (SnippetAddin)addinManager.getAddin(SnippetAddin.class);
        return snippetAddin;
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        Snippet snippet = (Snippet)this._snippets.getSelectedValue();
        String code = snippet.getCode();
        StringSelection stringSelection = new StringSelection(code);
        this._dragSource.startDrag(event, DragSource.DefaultCopyDrop, stringSelection, this);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (this._categories.equals(source)) {
            this.whenCategoryChanged();
        }
    }

    private void whenCategoryChanged() {
        this._snippetListModel.removeAllElements();
        String category = (String)this._categories.getSelectedItem();
        if (category != null) {
            SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
            List snippets = snippetAddin.getSnippets(this._language, category);
            for (int i = 0; i < snippets.size(); ++i) {
                Snippet snippet = (Snippet)snippets.get(i);
                this._snippetListModel.addElement(snippet);
            }
        }
    }

    public void setLanguage(String language) {
        this._language = language;
        this.fillCategories();
    }

    private void insertSelectedSnippet() {
        CodeEditor codeEditor;
        Context context;
        Node node;
        EditorManager editorManager;
        Editor currentEditor;
        Snippet selectedValue = (Snippet)this._snippets.getSelectedValue();
        if (selectedValue != null && (currentEditor = (editorManager = EditorManager.getEditorManager()).getCurrentEditor()) instanceof CodeEditor && (node = (context = (codeEditor = (CodeEditor)currentEditor).getContext()).getNode()) instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            int caretPosition = codeEditor.getCaretPosition();
            InsertSnippetCommand command = new InsertSnippetCommand(context, textNode, caretPosition, selectedValue.getCode());
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                commandProcessor.invoke((Command)command);
                editorManager.openEditor(new OpenEditorOptions(context));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        SnippetAddin snippetAddin;
        Object source = e.getSource();
        if (source == (snippetAddin = SnippetPanel.getSnippetAddin())) {
            String selectedItem = String.valueOf(this._categories.getSelectedItem());
            Snippet snippet = (Snippet)this._snippets.getSelectedValue();
            this.fillCategories();
            this._categories.setSelectedItem(selectedItem);
            if (snippet != null) {
                String selectedName = snippet.getName();
                int size = this._snippetListModel.getSize();
                for (int i = 0; i < size; ++i) {
                    Snippet snippet_i = (Snippet)this._snippetListModel.getElementAt(i);
                    if (!selectedName.equals(snippet_i.getName())) continue;
                    this._snippets.setSelectedValue(snippet_i, true);
                    break;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.insertSelectedSnippet();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.insertSelectedSnippet();
        }
    }
}

