/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Hashtable;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageIOConstants;

public final class BufferedImageReader
implements BufferedImageIOConstants {
    private DataInputStream _stream;

    public BufferedImageReader(DataInputStream dataInputStream) {
        this._stream = dataInputStream;
    }

    private void read(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this._stream.readInt();
            ++n;
        }
    }

    private void read(short[] sArray) throws IOException {
        int n = 0;
        while (n < sArray.length) {
            sArray[n] = this._stream.readShort();
            ++n;
        }
    }

    void readCompressed(int[] nArray) throws IOException {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readCompressedNumber();
            if (n3 > 0) {
                this.readIdentical(nArray, n2, n3);
                n2 += n3;
                continue;
            }
            this.readDifferent(nArray, n2, -n3);
            n2 += -n3;
        }
    }

    public int readCompressedNumber() throws IOException {
        byte by = this._stream.readByte();
        boolean bl = (by & 0x40) != 0;
        int n = by & 0x3F;
        int n2 = 6;
        if (bl) {
            byte by2;
            do {
                by2 = this._stream.readByte();
                int n3 = by2 & 0x7F;
                n |= n3 << n2;
                n2 += 7;
            } while ((by2 & 0x80) != 0);
        }
        return (by & 0x80) == 0 ? n : -n;
    }

    private void readIdentical(int[] nArray, int n, int n2) throws IOException {
        int n3 = this._stream.readInt();
        Arrays.fill(nArray, n, n + n2, n3);
    }

    private void readDifferent(int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            nArray[n + n3] = this._stream.readInt();
            ++n3;
        }
    }

    public BufferedImage read() throws IOException {
        ColorModel colorModel = this.readColorModel();
        WritableRaster writableRaster = this.readWritableRaster();
        Hashtable hashtable = this.readProperties();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, hashtable);
        return bufferedImage;
    }

    private ColorModel readColorModel() throws IOException {
        ColorModel colorModel;
        byte by = this._stream.readByte();
        switch (by) {
            case 1: {
                colorModel = this.readIndexColorModel();
                break;
            }
            case 2: {
                colorModel = this.readDirectColorModel();
                break;
            }
            case 3: {
                colorModel = this.readComponentColorModel();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported color model: " + by);
            }
        }
        return colorModel;
    }

    private IndexColorModel readIndexColorModel() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        this._stream.readFully(byArray);
        this._stream.readFully(byArray2);
        this._stream.readFully(byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(n2, n, byArray, byArray2, byArray3);
        return indexColorModel;
    }

    private DirectColorModel readDirectColorModel() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        int n3 = this._stream.readInt();
        int n4 = this._stream.readInt();
        DirectColorModel directColorModel = new DirectColorModel(n, n2, n3, n4);
        return directColorModel;
    }

    private ComponentColorModel readComponentColorModel() throws IOException {
        ComponentColorModel componentColorModel = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this._stream);
            ColorSpace colorSpace = (ColorSpace)objectInputStream.readObject();
            int n = this._stream.readInt();
            int[] nArray = new int[n];
            this.read(nArray);
            boolean bl = this._stream.readBoolean();
            boolean bl2 = this._stream.readBoolean();
            int n2 = this._stream.readInt();
            int n3 = this._stream.readInt();
            componentColorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n2, n3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return componentColorModel;
    }

    private WritableRaster readWritableRaster() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        DataBuffer dataBuffer = this.readDataBuffer();
        SampleModel sampleModel = this.readSampleModel(dataBuffer.getDataType(), n, n2);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        return writableRaster;
    }

    private DataBuffer readDataBuffer() throws IOException {
        DataBuffer dataBuffer;
        byte by = this._stream.readByte();
        switch (by) {
            case 0: {
                dataBuffer = this.readDataBufferByte();
                break;
            }
            case 2: {
                dataBuffer = this.readDataBufferShort();
                break;
            }
            case 1: {
                dataBuffer = this.readDataBufferUShort();
                break;
            }
            case 3: {
                dataBuffer = this.readDataBufferInt();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported databuffer type: " + by);
            }
        }
        return dataBuffer;
    }

    private DataBufferByte readDataBufferByte() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        byte[][] byArrayArray = new byte[n][];
        int n3 = 0;
        while (n3 < n) {
            byte[] byArray = new byte[n2];
            byArrayArray[n3] = byArray;
            this._stream.readFully(byArray);
            ++n3;
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArrayArray, n2);
        return dataBufferByte;
    }

    private DataBufferInt readDataBufferInt() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        int[][] nArrayArray = new int[n][];
        int n3 = 0;
        while (n3 < n) {
            int[] nArray = new int[n2];
            nArrayArray[n3] = nArray;
            this.readCompressed(nArray);
            ++n3;
        }
        DataBufferInt dataBufferInt = new DataBufferInt(nArrayArray, n2);
        return dataBufferInt;
    }

    private DataBufferShort readDataBufferShort() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        short[][] sArrayArray = new short[n][];
        int n3 = 0;
        while (n3 < n) {
            short[] sArray = new short[n2];
            sArrayArray[n3] = sArray;
            this.read(sArray);
            ++n3;
        }
        DataBufferShort dataBufferShort = new DataBufferShort(sArrayArray, n2);
        return dataBufferShort;
    }

    private DataBufferUShort readDataBufferUShort() throws IOException {
        int n = this._stream.readInt();
        int n2 = this._stream.readInt();
        short[][] sArrayArray = new short[n][];
        int n3 = 0;
        while (n3 < n) {
            short[] sArray = new short[n2];
            sArrayArray[n3] = sArray;
            this.read(sArray);
            ++n3;
        }
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArrayArray, n2);
        return dataBufferUShort;
    }

    private SampleModel readSampleModel(int n, int n2, int n3) throws IOException {
        SampleModel sampleModel;
        byte by = this._stream.readByte();
        switch (by) {
            case 1: {
                sampleModel = this.readPixelInterleavedSampleModel(n, n2, n3);
                break;
            }
            case 2: {
                sampleModel = this.readSinglePixelPackedSampleModel(n, n2, n3);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported sample model: " + by);
            }
        }
        return sampleModel;
    }

    private PixelInterleavedSampleModel readPixelInterleavedSampleModel(int n, int n2, int n3) throws IOException {
        int n4 = this._stream.readInt();
        int n5 = this._stream.readInt();
        int n6 = this._stream.readInt();
        int[] nArray = new int[n6];
        this.read(nArray);
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(n, n2, n3, n5, n4, nArray);
        return pixelInterleavedSampleModel;
    }

    private SinglePixelPackedSampleModel readSinglePixelPackedSampleModel(int n, int n2, int n3) throws IOException {
        int n4 = this._stream.readInt();
        int n5 = this._stream.readInt();
        int[] nArray = new int[n5];
        this.read(nArray);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n, n2, n3, n4, nArray);
        return singlePixelPackedSampleModel;
    }

    private Hashtable readProperties() throws IOException {
        Hashtable hashtable;
        int n = this._stream.readInt();
        if (n != 0) {
            hashtable = new Hashtable();
            int n2 = 0;
            while (n2 < n) {
                String string = this._stream.readUTF();
                byte by = this._stream.readByte();
                switch (by) {
                    case 1: {
                        Object object = this._stream.readUTF();
                        break;
                    }
                    case 2: {
                        Object object = new Integer(this._stream.readInt());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported property type: " + string + " = " + by);
                    }
                }
                ++n2;
            }
        } else {
            hashtable = null;
        }
        return hashtable;
    }
}

