/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageIOConstants;

public final class BufferedImageWriter
implements BufferedImageIOConstants {
    private static final boolean DEBUG_STATS = false;
    private DataOutputStream _stream;

    public BufferedImageWriter(DataOutputStream dataOutputStream) {
        this._stream = dataOutputStream;
    }

    public void write(BufferedImage bufferedImage) throws IOException {
        this.writeColorModel(bufferedImage.getColorModel());
        this.writeRaster(bufferedImage.getRaster());
        this.writeProperties(bufferedImage);
    }

    private void writeColorModel(ColorModel colorModel) throws IOException {
        if (colorModel instanceof IndexColorModel) {
            this.write((IndexColorModel)colorModel);
        } else if (colorModel instanceof DirectColorModel) {
            this.write((DirectColorModel)colorModel);
        } else if (colorModel instanceof ComponentColorModel) {
            this.write((ComponentColorModel)colorModel);
        } else {
            throw new UnsupportedOperationException("Unsupported color model: " + colorModel.getClass().getName());
        }
    }

    private void writeRaster(Raster raster) throws IOException {
        this._stream.writeInt(raster.getWidth());
        this._stream.writeInt(raster.getHeight());
        this.writeDataBuffer(raster.getDataBuffer());
        this.writeSampleModel(raster.getSampleModel());
    }

    private void writeDataBuffer(DataBuffer dataBuffer) throws IOException {
        if (dataBuffer instanceof DataBufferByte) {
            this.write((DataBufferByte)dataBuffer);
        } else if (dataBuffer instanceof DataBufferInt) {
            this.write((DataBufferInt)dataBuffer);
        } else if (dataBuffer instanceof DataBufferShort) {
            this.write((DataBufferShort)dataBuffer);
        } else if (dataBuffer instanceof DataBufferUShort) {
            this.write((DataBufferUShort)dataBuffer);
        } else {
            throw new UnsupportedOperationException("Unsupported data buffer: " + dataBuffer.getClass().getName());
        }
    }

    private void writeSampleModel(SampleModel sampleModel) throws IOException {
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            this.write((PixelInterleavedSampleModel)sampleModel);
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            this.write((SinglePixelPackedSampleModel)sampleModel);
        } else {
            throw new UnsupportedOperationException("Unsupported sample model: " + sampleModel.getClass().getName());
        }
    }

    private void write(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            this._stream.writeInt(nArray[n]);
            ++n;
        }
    }

    private void writeCompressed(int[] nArray) throws IOException {
        long l = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getIdentical(nArray, n2);
            if (n3 != 0) {
                this.writeIdentical(nArray, n2, n3);
                n2 += n3;
            }
            if ((n3 = this.getDifferent(nArray, n2)) == 0) continue;
            this.writeDifferent(nArray, n2, n3);
            n2 += n3;
        }
    }

    private int getIdentical(int[] nArray, int n) throws IOException {
        int n2 = n + 1;
        while (n2 < nArray.length) {
            if (nArray[n] != nArray[n2]) {
                int n3 = n2 - n;
                if (n3 > 1) {
                    return n3;
                }
                return 0;
            }
            ++n2;
        }
        return nArray.length - n;
    }

    private int getDifferent(int[] nArray, int n) throws IOException {
        int n2 = n + 1;
        while (n2 < nArray.length) {
            if (nArray[n2] == nArray[n2 - 1]) {
                int n3 = n2 - n - 1;
                return n3;
            }
            ++n2;
        }
        return nArray.length - n;
    }

    static String toBinaryString(byte by) {
        String string = (by & 0x80) == 0 ? "" : "1";
        String string2 = Integer.toBinaryString(by & 0x7F);
        return string + string2;
    }

    private void writeCompressedNumber(int n) throws IOException {
        int n2;
        if (n < 0) {
            n = -n;
            n2 = 128;
        } else {
            n2 = 0;
        }
        int n3 = n & 0x3F | n2;
        int n4 = n >> 6;
        byte by = (byte)(n3 | (n4 == 0 ? 0 : 64));
        n = n4;
        this._stream.writeByte(by);
        while (n != 0) {
            int n5 = n & 0x7F;
            int n6 = n >> 7;
            byte by2 = (byte)(n5 | (n6 == 0 ? 0 : 128));
            n = n6;
            this._stream.writeByte(by2);
        }
    }

    private void writeIdentical(int[] nArray, int n, int n2) throws IOException {
        this.writeCompressedNumber(n2);
        this._stream.writeInt(nArray[n]);
    }

    private void writeDifferent(int[] nArray, int n, int n2) throws IOException {
        this.writeCompressedNumber(-n2);
        int n3 = 0;
        while (n3 < n2) {
            this._stream.writeInt(nArray[n + n3]);
            ++n3;
        }
    }

    static void printArray(String string, int[] nArray, int n, int n2) {
        System.out.print(string + " " + n2 + ":");
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(" " + nArray[n + n3]);
            ++n3;
        }
        System.out.println("");
    }

    private void write(short[] sArray) throws IOException {
        int n = 0;
        while (n < sArray.length) {
            this._stream.writeShort(sArray[n]);
            ++n;
        }
    }

    private void write(IndexColorModel indexColorModel) throws IOException {
        int n = indexColorModel.getMapSize();
        int n2 = indexColorModel.getPixelSize();
        byte[] byArray = new byte[n];
        this._stream.write(1);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        indexColorModel.getReds(byArray);
        this._stream.write(byArray);
        indexColorModel.getGreens(byArray);
        this._stream.write(byArray);
        indexColorModel.getBlues(byArray);
        this._stream.write(byArray);
    }

    private void write(DirectColorModel directColorModel) throws IOException {
        int n = directColorModel.getPixelSize();
        int n2 = directColorModel.getRedMask();
        int n3 = directColorModel.getGreenMask();
        int n4 = directColorModel.getBlueMask();
        this._stream.write(2);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        this._stream.writeInt(n3);
        this._stream.writeInt(n4);
    }

    private void write(ComponentColorModel componentColorModel) throws IOException {
        ColorSpace colorSpace = componentColorModel.getColorSpace();
        int[] nArray = componentColorModel.getComponentSize();
        int n = nArray.length;
        boolean bl = componentColorModel.hasAlpha();
        boolean bl2 = componentColorModel.isAlphaPremultiplied();
        int n2 = componentColorModel.getTransparency();
        int n3 = componentColorModel.getTransferType();
        this._stream.write(3);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this._stream);
        objectOutputStream.writeObject(colorSpace);
        objectOutputStream.flush();
        this._stream.writeInt(n);
        this.write(nArray);
        this._stream.writeBoolean(bl);
        this._stream.writeBoolean(bl2);
        this._stream.writeInt(n2);
        this._stream.writeInt(n3);
    }

    private void write(PixelInterleavedSampleModel pixelInterleavedSampleModel) throws IOException {
        int n = pixelInterleavedSampleModel.getScanlineStride();
        int n2 = pixelInterleavedSampleModel.getPixelStride();
        int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
        this._stream.write(1);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        this._stream.writeInt(nArray.length);
        this.write(nArray);
    }

    private void write(SinglePixelPackedSampleModel singlePixelPackedSampleModel) throws IOException {
        int n = singlePixelPackedSampleModel.getScanlineStride();
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        this._stream.write(2);
        this._stream.writeInt(n);
        this._stream.writeInt(nArray.length);
        this.write(nArray);
    }

    private void write(DataBufferByte dataBufferByte) throws IOException {
        int n = dataBufferByte.getNumBanks();
        int n2 = dataBufferByte.getSize();
        byte[][] byArray = dataBufferByte.getBankData();
        this._stream.write(0);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        int n3 = 0;
        while (n3 < n) {
            this._stream.write(byArray[n3]);
            ++n3;
        }
    }

    private void write(DataBufferInt dataBufferInt) throws IOException {
        int n = dataBufferInt.getNumBanks();
        int n2 = dataBufferInt.getSize();
        int[][] nArray = dataBufferInt.getBankData();
        this._stream.write(3);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        int n3 = 0;
        while (n3 < n) {
            this.writeCompressed(nArray[n3]);
            ++n3;
        }
    }

    private void write(DataBufferShort dataBufferShort) throws IOException {
        int n = dataBufferShort.getNumBanks();
        int n2 = dataBufferShort.getSize();
        short[][] sArray = dataBufferShort.getBankData();
        this._stream.write(2);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        int n3 = 0;
        while (n3 < n) {
            this.write(sArray[n3]);
            ++n3;
        }
    }

    private void write(DataBufferUShort dataBufferUShort) throws IOException {
        int n = dataBufferUShort.getNumBanks();
        int n2 = dataBufferUShort.getSize();
        short[][] sArray = dataBufferUShort.getBankData();
        this._stream.write(1);
        this._stream.writeInt(n);
        this._stream.writeInt(n2);
        int n3 = 0;
        while (n3 < n) {
            this.write(sArray[n3]);
            ++n3;
        }
    }

    private void writeProperties(BufferedImage bufferedImage) throws IOException {
        String[] stringArray = bufferedImage.getPropertyNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this._stream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                Object object = bufferedImage.getProperty(string);
                if (object instanceof String) {
                    String string2 = (String)object;
                    this._stream.write(1);
                    this._stream.writeUTF(string2);
                } else if (object instanceof Integer) {
                    Integer n3 = (Integer)object;
                    this._stream.write(2);
                    this._stream.writeInt(n3);
                } else {
                    throw new UnsupportedOperationException("Invalid property type: " + string + " = " + object.getClass().getName());
                }
                ++n2;
            }
        } else {
            this._stream.writeInt(0);
        }
    }
}

