/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.comm.DebugStreamFactory;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;
import oracle.jdevimpl.runner.uidebug.debuggee.Roots;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqAddListener;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqFindEventTypes;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqFindObjectListeners;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqHighlight;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqPeriodicUpdate;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqRemoveListener;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqVisible;

public class Debuggee
extends Thread {
    private static final String OPT_PORT = "-uidport,";
    private static final String OPT_JAR = "-jar";
    private static final String OPT_SILENT = "-silent";
    private static Debuggee INSTANCE;
    private DebugStream _stream;
    private Roots _roots;

    private Debuggee() {
        super("UI-Debuggee");
        this.setDaemon(true);
    }

    public static void main(String[] stringArray) {
        int n = 4030;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (string3.startsWith(OPT_PORT)) {
                String string4 = string3.substring(OPT_PORT.length());
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid port number: + " + string4);
                    Debuggee.usage();
                    System.exit(1);
                }
            } else {
                if (string3.startsWith(OPT_JAR)) {
                    if (++n2 >= stringArray.length) {
                        Debuggee.usage();
                        System.exit(1);
                    }
                    string2 = stringArray[n2];
                    ++n2;
                    break;
                }
                if (string3.startsWith(OPT_SILENT)) {
                    bl = true;
                } else {
                    ++n2;
                    string = string3;
                    break;
                }
            }
            ++n2;
        }
        Method method = null;
        Object[] objectArray = new Object[]{};
        try {
            Class<?> clazz = null;
            if (string != null) {
                clazz = Class.forName(string);
            } else if (string2 != null) {
                File file = new File(string2);
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String string5 = attributes.getValue("Main-Class");
                URL uRL = file.toURL();
                URL[] uRLArray = new URL[]{uRL};
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                clazz = uRLClassLoader.loadClass(string5);
            }
            if (clazz == null) {
                Debuggee.usage();
                System.exit(1);
            }
            Debuggee debuggee = Debuggee.getInstance();
            debuggee.startUp(n, bl);
            int n3 = stringArray.length - n2;
            String[] stringArray2 = new String[n3];
            System.arraycopy(stringArray, n2, stringArray2, 0, n3);
            Class[] classArray = new Class[]{stringArray2.getClass()};
            method = clazz.getMethod("main", classArray);
            objectArray = new Object[]{stringArray2};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debuggee.usage();
            System.exit(1);
        }
        try {
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void usage() {
        String string = "Usage: java {0} [-uidport,<port>] <MainClass>";
        String string2 = MessageFormat.format("Usage: java {0} [-uidport,<port>] <MainClass>", Debuggee.class.getName());
        System.err.println(string2);
    }

    public boolean startUp(int n) {
        return this.startUp(n, true);
    }

    public boolean startUp(int n, boolean bl) {
        if (!bl) {
            String string = MessageFormat.format("*** UI Debugger port is {0} ***", new Integer(n));
            String string2 = "*** Waiting for UI Debugger connection ***";
            System.out.println(string);
            System.out.println("*** Waiting for UI Debugger connection ***");
        }
        this._stream = DebugStreamFactory.createServerSocket(n);
        if (this._stream != null) {
            if (!bl) {
                String string = "*** UI Debugger connected ***";
                System.out.println("*** UI Debugger connected ***");
            }
            this._roots = new Roots();
            this.start();
            return true;
        }
        return false;
    }

    public static Debuggee getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Debuggee();
        }
        return INSTANCE;
    }

    public DebugStream getStream() {
        return this._stream;
    }

    public void run() {
        try {
            while (true) {
                int n = this._stream.readInt();
                int n2 = this._stream.readInt();
                Request request = this.getRequest(n2, n);
                if (request == null) continue;
                request.readParam(this._stream);
                SwingUtilities.invokeLater(new 2(this, request));
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Request getRequest(int n, int n2) {
        Request request;
        switch (n) {
            case 1: {
                request = new ReqFullTree(n2);
                break;
            }
            case 2: {
                request = new ReqVisible(n2);
                break;
            }
            case 3: {
                request = new ReqAddListener(n2);
                break;
            }
            case 4: {
                request = new ReqRemoveListener(n2);
                break;
            }
            case 5: {
                request = new ReqPeriodicUpdate(n2);
                break;
            }
            case 6: {
                request = new ReqHighlight(n2);
                break;
            }
            case 8: {
                request = new ReqFindEventTypes(n2);
                break;
            }
            case 9: {
                request = new ReqFindObjectListeners(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid request ID: " + n);
            }
        }
        return request;
    }

    public Roots getRoots() {
        return this._roots;
    }

    public void sendFullTree() {
        SwingUtilities.invokeLater(new 1());
    }

    public void _sendFullTree() {
        ReqFullTree reqFullTree = new ReqFullTree(0);
        reqFullTree.doIt();
        this._stream.beginWriteTransaction();
        try {
            try {
                reqFullTree.writeReply(this._stream);
                this._stream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            this._stream.endWriteTransaction();
        }
    }

    static DebugStream ra$_stream(Debuggee debuggee) {
        return debuggee._stream;
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ Request v$req;
        final /* synthetic */ Debuggee this$0;

        public void run() {
            this.v$req.doIt();
            Debuggee.ra$_stream(this.this$0).beginWriteTransaction();
            try {
                try {
                    this.v$req.writeReply(Debuggee.ra$_stream(this.this$0));
                    Debuggee.ra$_stream(this.this$0).flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            finally {
                Debuggee.ra$_stream(this.this$0).endWriteTransaction();
            }
        }

        public 2(Debuggee debuggee, Request request) {
            this.v$req = request;
            this.this$0 = debuggee;
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            Debuggee.this._sendFullTree();
        }
    }
}

