/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.dynalistener;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;

public class ListenerFinder {
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String LISTENER = "Listener";

    public static ArrayList findEventTypes(Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class<?> clazz2 = classLoader.loadClass("java.util.EventListener");
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                String string;
                Class<?> clazz3;
                Class<?>[] classArray;
                Class<?> clazz4;
                Method method = methodArray[n];
                String string2 = method.getName();
                if (string2.startsWith(ADD) && string2.endsWith(LISTENER) && (clazz4 = method.getReturnType()) == Void.TYPE && (classArray = method.getParameterTypes()).length == 1 && (clazz3 = classArray[0]).isInterface() && (string = clazz3.getName()).endsWith(LISTENER) && clazz2.isAssignableFrom(clazz3)) {
                    String string3 = ListenerFinder.getBaseName(clazz3);
                    if ((ADD + string3 + LISTENER).equals(string2)) {
                        Class[] classArray2 = new Class[]{clazz3};
                        try {
                            Method method2 = clazz.getMethod(REMOVE + string3 + LISTENER, classArray2);
                            if (method2.getReturnType() == Void.TYPE) {
                                arrayList.add(string);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find java.util.EventListener");
            classNotFoundException.printStackTrace();
        }
        return arrayList;
    }

    public static ArrayList findObjectListeners(Object object) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[]{Class.class};
        Object[] objectArray = new Object[1];
        try {
            Method method = clazz.getMethod("getListeners", classArray);
            ArrayList arrayList2 = ListenerFinder.findEventTypes(clazz);
            int n = 0;
            while (n < arrayList2.size()) {
                String string = (String)arrayList2.get(n);
                try {
                    Class<?> clazz2;
                    objectArray[0] = clazz2 = classLoader.loadClass(string);
                    try {
                        EventListener[] eventListenerArray = (EventListener[])method.invoke(object, objectArray);
                        if (eventListenerArray != null) {
                            int n2 = 0;
                            while (n2 < eventListenerArray.length) {
                                EventListener eventListener = eventListenerArray[n2];
                                Class<?> clazz3 = eventListener.getClass();
                                String string2 = clazz3.getName();
                                arrayList.add(new Object[]{string, string2});
                                ++n2;
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("Failed to get listeners: " + string);
                        illegalAccessException.printStackTrace();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Failed to get listeners: " + string);
                        illegalArgumentException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.err.println("Failed to get listeners: " + string);
                        invocationTargetException.printStackTrace();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Failed to get listeners: " + string);
                    classNotFoundException.printStackTrace();
                }
                ++n;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return arrayList;
    }

    private static String getBaseName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    private static String getBaseName(Class clazz) {
        String string;
        Package package_ = clazz.getPackage();
        String string2 = clazz.getName();
        int n = 0;
        if (package_ != null && (string = package_.getName()).length() != 0) {
            n = string.length() + 1;
        }
        String string3 = string2.substring(n, string2.length() - LISTENER.length());
        return string3;
    }

    static Method getListenerMethod(Component component, String string, String string2) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = component.getClass();
        String string3 = ListenerFinder.getBaseName(string2);
        String string4 = string + string3;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz2 = classLoader.loadClass(string2);
        Class[] classArray = new Class[]{clazz2};
        Method method = clazz.getMethod(string4, classArray);
        return method;
    }
}

