/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.dynalistener;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.Debuggee;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.dynalistener.ListenerFinder;

public final class ProxyListener
implements InvocationHandler,
ContainerListener {
    private int _referenceID;
    private ArrayList _listened;
    private String _listenerTypeName;
    private ProxyListener _root;
    private Component _component;
    private boolean _includeChildren;
    private static final String[] BEAN_PREFIXES = new String[]{"get", "is", "has"};
    private static final Object[] NOARGS = new Object[0];
    private Object _listener;

    void $init$() {
        this._referenceID = -1;
    }

    public ProxyListener(Component component, String string, boolean bl) {
        this.$init$();
        this.init(this, component, string, bl);
    }

    private ProxyListener(ProxyListener proxyListener, Component component, String string, boolean bl) {
        this.$init$();
        this.init(proxyListener, component, string, bl);
    }

    private void init(ProxyListener proxyListener, Component component, String string, boolean bl) {
        this._root = proxyListener;
        this._component = component;
        this._listenerTypeName = string;
        this._includeChildren = bl;
        try {
            Class clazz = ProxyListener.getListenerClass(this._listenerTypeName);
            Constructor constructor = clazz.getConstructor(InvocationHandler.class);
            this._listener = constructor.newInstance(this);
            this.addListener(this._component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getReferenceID() {
        if (this._referenceID == -1) {
            this._referenceID = References.getInstance().getReference(this);
        }
        return this._referenceID;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        Object object2 = objectArray[0];
        ArrayList arrayList = ProxyListener.buildProperties(object2);
        Component component = this._component;
        Debuggee debuggee = Debuggee.getInstance();
        int n = References.getInstance().getReference(this._root._component);
        int n2 = References.getInstance().getReference(component);
        DebugStream debugStream = debuggee.getStream();
        debugStream.beginWriteTransaction();
        try {
            debugStream.writeInt(-1);
            debugStream.writeInt(100);
            debugStream.writeInt(n);
            debugStream.writeInt(this.getReferenceID());
            debugStream.writeInt(n2);
            debugStream.writeUTF(string);
            int n3 = arrayList.size();
            debugStream.writeInt(n3);
            int n4 = 0;
            while (n4 < n3) {
                Object[] objectArray2 = (Object[])arrayList.get(n4);
                debugStream.writeUTF((String)objectArray2[0]);
                debugStream.writeUTF((String)objectArray2[1]);
                ++n4;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        debugStream.endWriteTransaction();
        return null;
    }

    private void addListener(Component component) {
        try {
            Object[] objectArray = new Object[]{this._listener};
            Method method = ListenerFinder.getListenerMethod(component, "add", this._listenerTypeName);
            method.invoke((Object)component, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._includeChildren && component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = container.getComponentCount();
            this._listened = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                ProxyListener proxyListener = new ProxyListener(this._root, component2, this._listenerTypeName, true);
                this._listened.add(proxyListener);
                ++n2;
            }
        }
    }

    public void removeRootListener() {
        this._root.removeListener();
    }

    private void removeListener() {
        try {
            Method method = ListenerFinder.getListenerMethod(this._component, "remove", this._listenerTypeName);
            Object[] objectArray = new Object[]{this._listener};
            method.invoke((Object)this._component, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._listened != null) {
            int n = this._listened.size() - 1;
            while (n >= 0) {
                ProxyListener proxyListener = (ProxyListener)this._listened.get(n);
                proxyListener.removeListener();
                --n;
            }
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        try {
            this.addListener(component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (this._listened != null) {
            Component component = containerEvent.getChild();
            int n = 0;
            while (n < this._listened.size()) {
                ProxyListener proxyListener = (ProxyListener)this._listened.get(n);
                if (proxyListener.isListenerFor(component)) {
                    proxyListener.removeRootListener();
                }
                ++n;
            }
        }
    }

    private boolean isListenerFor(Component component) {
        return component == this._component;
    }

    private static String getBeanPropertyName(String string) {
        int n = 0;
        while (n < BEAN_PREFIXES.length) {
            char c;
            int n2;
            String string2 = BEAN_PREFIXES[n];
            if (string.startsWith(string2) && (n2 = string2.length()) < string.length() && Character.isUpperCase(c = string.charAt(n2))) {
                return string.substring(n2);
            }
            ++n;
        }
        return null;
    }

    private static ArrayList buildProperties(Object object) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Class<?> clazz = object.getClass();
        while (clazz != null && (clazz.getModifiers() & 1) == 0) {
            clazz = clazz.getSuperclass();
        }
        if (clazz != null) {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Class<?>[] classArray;
                Method method = methodArray[n];
                String string = method.getName();
                String string2 = ProxyListener.getBeanPropertyName(string);
                if (!(string2 == null || "Class".equals(string2) || (classArray = method.getParameterTypes()) != null && classArray.length != 0)) {
                    try {
                        String string3;
                        Object object2 = method.invoke(object, NOARGS);
                        if (object2 instanceof String) {
                            string3 = (String)object2;
                        } else if (object2 instanceof Integer) {
                            Integer n2 = (Integer)object2;
                            string3 = n2.toString();
                        } else if (object2 instanceof Component) {
                            int n3 = References.getInstance().getReference(object2);
                            string3 = object2.getClass().getName() + "(" + n3 + ")";
                        } else {
                            string3 = "[" + String.valueOf(object2) + "]";
                        }
                        Object[] objectArray = new Object[]{string2, string3};
                        arrayList.add(objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    private static Class getListenerClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = ListenerFinder.class.getClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        Class<?> clazz2 = Proxy.getProxyClass(classLoader, clazz);
        return clazz2;
    }
}

