/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.Debuggee;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;

public class ReqFullTree
extends Request {
    private static final int TX_IMAGE_TYPE = 1;
    public static final int REQUEST_TYPE = 1;
    private boolean _includeImage;

    public ReqFullTree(int n) {
        super(n, 1);
    }

    public void readParam(DebugStream debugStream) throws IOException {
        this._includeImage = debugStream.readBoolean();
    }

    public void doIt() {
    }

    public void writeReply(DebugStream debugStream) throws IOException {
        References.getInstance().pack();
        debugStream.writeInt(this.getRequestType());
        debugStream.writeInt(1);
        Window[] windowArray = Debuggee.getInstance().getRoots().getRoots();
        debugStream.writeInt(windowArray.length);
        int n = 0;
        while (n < windowArray.length) {
            Window window = windowArray[n];
            boolean bl = this._includeImage && window.isVisible();
            debugStream.writeBoolean(bl);
            if (bl) {
                BufferedImage bufferedImage = ReqFullTree.getImage(window);
                debugStream.writeImage(bufferedImage);
            }
            this.writeComponent(debugStream, windowArray[n]);
            ++n;
        }
    }

    private static BufferedImage getImage(Component component) {
        BufferedImage bufferedImage;
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                component.paintAll(graphics2D);
            }
            catch (Exception exception) {}
        } else {
            bufferedImage = new BufferedImage(1, 1, 1);
        }
        return bufferedImage;
    }

    private void writeComponent(DebugStream debugStream, Component component) throws IOException {
        int n = References.getInstance().getReference(component);
        Class<?> clazz = component.getClass();
        boolean bl = component.isVisible();
        Rectangle rectangle = component.getBounds();
        debugStream.writeInt(n);
        debugStream.writeClass(clazz.getName());
        debugStream.writeBoolean(bl);
        debugStream.writeInt(rectangle.x);
        debugStream.writeInt(rectangle.y);
        debugStream.writeInt(rectangle.width);
        debugStream.writeInt(rectangle.height);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n2 = container.getComponentCount();
            debugStream.writeInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                Component component2 = container.getComponent(n3);
                this.writeComponent(debugStream, component2);
                ++n3;
            }
        } else {
            debugStream.writeInt(0);
        }
    }
}

