/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BrokenBarrierException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CyclicBarrier {
    private final ReentrantLock lock;
    private final Condition trip;
    private final int parties;
    private final Runnable barrierCommand;
    private long generation;
    private boolean broken;
    private int count;

    private final void nextGeneration() {
        this.count = this.parties;
        ++this.generation;
        this.trip.signalAll();
    }

    private final void breakBarrier() {
        this.broken = true;
        this.trip.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int dowait(boolean timed, long nanos) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            long deadline;
            int index = --this.count;
            long g = this.generation;
            if (this.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if (index == 0) {
                int n;
                this.nextGeneration();
                boolean ranAction = false;
                try {
                    Runnable command = this.barrierCommand;
                    if (command != null) {
                        command.run();
                    }
                    ranAction = true;
                    n = 0;
                    Object var13_11 = null;
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    if (ranAction) throw throwable;
                    this.breakBarrier();
                    throw throwable;
                }
                Object var6_14 = null;
                lock.unlock();
                return n;
            }
            do {
                deadline = Utils.nanoTime() + nanos;
                try {
                    if (!timed) {
                        this.trip.await();
                    } else {
                        this.trip.await(nanos, TimeUnit.NANOSECONDS);
                    }
                }
                catch (InterruptedException ie) {
                    this.breakBarrier();
                    throw ie;
                }
                if (this.broken) throw new BrokenBarrierException();
                if (g > this.generation) {
                    throw new BrokenBarrierException();
                }
                if (g >= this.generation) continue;
                int n = index;
                Object var6_15 = null;
                lock.unlock();
                return n;
            } while (!timed || (nanos = deadline - Utils.nanoTime()) > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.broken;
            Object var3_3 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.generation -= (long)4;
            this.broken = false;
            this.trip.signalAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            lock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.parties - this.count;
            Object var3_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new ReentrantLock();
        this.trip = this.lock.newCondition();
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        this.this();
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }
}

