/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import java.io.Serializable;

public abstract class TimeUnit
implements Serializable {
    public static final TimeUnit NANOSECONDS = new TimeUnit(0, "NANOSECONDS"){

        public final long toNanos(long d) {
            return d;
        }

        public final long toMicros(long d) {
            return d / 1000L;
        }

        public final long toMillis(long d) {
            return d / 1000000L;
        }

        public final long toSeconds(long d) {
            return d / 1000000000L;
        }

        public final long toMinutes(long d) {
            return d / 60000000000L;
        }

        public final long toHours(long d) {
            return d / 3600000000000L;
        }

        public final long toDays(long d) {
            return d / 86400000000000L;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toNanos(d);
        }

        final int excessNanos(long d, long m) {
            return (int)(d - m * 1000000L);
        }
    };
    public static final TimeUnit MICROSECONDS = new TimeUnit(1, "MICROSECONDS"){

        public final long toNanos(long d) {
            return 2.x(d, 1000L, 9223372036854775L);
        }

        public final long toMicros(long d) {
            return d;
        }

        public final long toMillis(long d) {
            return d / 1000L;
        }

        public final long toSeconds(long d) {
            return d / 1000000L;
        }

        public final long toMinutes(long d) {
            return d / 60000000L;
        }

        public final long toHours(long d) {
            return d / 3600000000L;
        }

        public final long toDays(long d) {
            return d / 86400000000L;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toMicros(d);
        }

        final int excessNanos(long d, long m) {
            return (int)(d * 1000L - m * 1000000L);
        }
    };
    public static final TimeUnit MILLISECONDS = new TimeUnit(2, "MILLISECONDS"){

        public final long toNanos(long d) {
            return 3.x(d, 1000000L, 9223372036854L);
        }

        public final long toMicros(long d) {
            return 3.x(d, 1000L, 9223372036854775L);
        }

        public final long toMillis(long d) {
            return d;
        }

        public final long toSeconds(long d) {
            return d / 1000L;
        }

        public final long toMinutes(long d) {
            return d / 60000L;
        }

        public final long toHours(long d) {
            return d / 3600000L;
        }

        public final long toDays(long d) {
            return d / 86400000L;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toMillis(d);
        }

        final int excessNanos(long d, long m) {
            return 0;
        }
    };
    public static final TimeUnit SECONDS = new TimeUnit(3, "SECONDS"){

        public final long toNanos(long d) {
            return 4.x(d, 1000000000L, 9223372036L);
        }

        public final long toMicros(long d) {
            return 4.x(d, 1000000L, 9223372036854L);
        }

        public final long toMillis(long d) {
            return 4.x(d, 1000L, 9223372036854775L);
        }

        public final long toSeconds(long d) {
            return d;
        }

        public final long toMinutes(long d) {
            return d / 60L;
        }

        public final long toHours(long d) {
            return d / 3600L;
        }

        public final long toDays(long d) {
            return d / 86400L;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toSeconds(d);
        }

        final int excessNanos(long d, long m) {
            return 0;
        }
    };
    public static final TimeUnit MINUTES = new TimeUnit(4, "MINUTES"){

        public final long toNanos(long d) {
            return 5.x(d, 60000000000L, 153722867L);
        }

        public final long toMicros(long d) {
            return 5.x(d, 60000000L, 153722867280L);
        }

        public final long toMillis(long d) {
            return 5.x(d, 60000L, 153722867280912L);
        }

        public final long toSeconds(long d) {
            return 5.x(d, 60L, 0x222222222222222L);
        }

        public final long toMinutes(long d) {
            return d;
        }

        public final long toHours(long d) {
            return d / 60L;
        }

        public final long toDays(long d) {
            return d / 1440L;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toMinutes(d);
        }

        final int excessNanos(long d, long m) {
            return 0;
        }
    };
    public static final TimeUnit HOURS = new TimeUnit(5, "HOURS"){

        public final long toNanos(long d) {
            return 6.x(d, 3600000000000L, 2562047L);
        }

        public final long toMicros(long d) {
            return 6.x(d, 3600000000L, 2562047788L);
        }

        public final long toMillis(long d) {
            return 6.x(d, 3600000L, 2562047788015L);
        }

        public final long toSeconds(long d) {
            return 6.x(d, 3600L, 2562047788015215L);
        }

        public final long toMinutes(long d) {
            return 6.x(d, 60L, 0x222222222222222L);
        }

        public final long toHours(long d) {
            return d;
        }

        public final long toDays(long d) {
            return d / 24L;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toHours(d);
        }

        final int excessNanos(long d, long m) {
            return 0;
        }
    };
    public static final TimeUnit DAYS = new TimeUnit(6, "DAYS"){

        public final long toNanos(long d) {
            return 7.x(d, 86400000000000L, 106751L);
        }

        public final long toMicros(long d) {
            return 7.x(d, 86400000000L, 106751991L);
        }

        public final long toMillis(long d) {
            return 7.x(d, 86400000L, 106751991167L);
        }

        public final long toSeconds(long d) {
            return 7.x(d, 86400L, 106751991167300L);
        }

        public final long toMinutes(long d) {
            return 7.x(d, 1440L, 0x16C16C16C16C16L);
        }

        public final long toHours(long d) {
            return 7.x(d, 24L, 0x555555555555555L);
        }

        public final long toDays(long d) {
            return d;
        }

        public final long convert(long d, TimeUnit u) {
            return u.toDays(d);
        }

        final int excessNanos(long d, long m) {
            return 0;
        }
    };
    private static final TimeUnit[] values = new TimeUnit[]{NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS};
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;
    static final long MAX = Long.MAX_VALUE;
    private final int index;
    private final String name;

    public static TimeUnit[] values() {
        return (TimeUnit[])values.clone();
    }

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public abstract long convert(long var1, TimeUnit var3);

    public abstract long toNanos(long var1);

    public abstract long toMicros(long var1);

    public abstract long toMillis(long var1);

    public abstract long toSeconds(long var1);

    public abstract long toMinutes(long var1);

    public abstract long toHours(long var1);

    public abstract long toDays(long var1);

    abstract int excessNanos(long var1, long var3);

    public void timedWait(Object obj, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            obj.wait(ms, ns);
        }
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            thread.join(ms, ns);
        }
    }

    public void sleep(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            Thread.sleep(ms, ns);
        }
    }

    public String toString() {
        return this.name;
    }

    TimeUnit(int index, String name) {
        this.index = index;
        this.name = name;
    }
}

