/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.util.ResourceBundle;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class CMUtils {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.jdeveloper.cm.ConnectionRtBundle");
    private static final String ORACLE_URL_PREFIX = "jdbc:oracle:";
    private static final String OLITE_URL_PREFIX = "jdbc:polite:";
    private static final String ODBC_URL_PREFIX = "jdbc:odbc:";

    public static String getUrl(String string, ConnectionDescriptor connectionDescriptor) throws CMException {
        if (string.equals("IIOP")) {
            return CMUtils._getIiopUrl(connectionDescriptor);
        }
        if (string.equals("JDBC")) {
            return CMUtils._getJdbcUrl(connectionDescriptor);
        }
        throw new CMException("getUrl() for connection type " + string + " is not supported.");
    }

    private static String _getIiopUrl(ConnectionDescriptor connectionDescriptor) {
        String string = "sess_iiop://" + connectionDescriptor.getHostname() + ":" + connectionDescriptor.getIiopPort() + ":" + connectionDescriptor.getSid();
        return string;
    }

    private static String _getJdbcUrl(ConnectionDescriptor connectionDescriptor) throws CMException {
        String string = connectionDescriptor.getURL();
        if (null == string || string.length() < 1) {
            if (connectionDescriptor.getProperty("ConnectionType").equals("JDBC_ODBC")) {
                String string2 = connectionDescriptor.getProperty("DSN");
                if (null == string2) {
                    throw new CMException(bundle.getString("ERROR_NULL_DATASOURCE"));
                }
                return ODBC_URL_PREFIX + string2;
            }
            if (connectionDescriptor.getProperty("ConnectionType").equals("ORACLE_LITE")) {
                String string3 = connectionDescriptor.getProperty("DSN");
                if (null == string3) {
                    throw new CMException(bundle.getString("ERROR_NULL_DATASOURCE"));
                }
                return OLITE_URL_PREFIX + string3;
            }
            if (connectionDescriptor.getProperty("ConnectionType").equals("JDBC") || connectionDescriptor.getProperty("ConnectionType").equals("ORACLE_JSERVER")) {
                String string4 = connectionDescriptor.getProperty("ORACLE_JDBC_TYPE");
                String string5 = connectionDescriptor.getProperty("HOSTNAME");
                String string6 = connectionDescriptor.getProperty("JDBC_PORT");
                String string7 = connectionDescriptor.getProperty("SID");
                String string8 = connectionDescriptor.getProperty("ServiceName");
                if (null == string5) {
                    throw new CMException(bundle.getString("ERROR_NULL_HOSTNAME"));
                }
                if (null == string6) {
                    throw new CMException(bundle.getString("ERROR_NULL_PORT"));
                }
                if (null == string4) {
                    throw new CMException(bundle.getString("ERROR_NULL_DRIVER"));
                }
                if (null == string7 && null == string8) {
                    throw new CMException(bundle.getString("ERROR_NULL_SID"));
                }
                String string9 = null;
                string9 = string4.equals("thin") ? (string7 != null ? ORACLE_URL_PREFIX + string4 + ":@" + string5 + ":" + string6 + ":" + string7 : ORACLE_URL_PREFIX + string4 + ":@//" + string5 + ":" + string6 + "/" + string8) : ORACLE_URL_PREFIX + string4 + ":@" + CMUtils._namedHostToConnString(string5, string6, string7);
                return string9;
            }
        }
        return string;
    }

    public static String namedHostToConnString(String string) {
        try {
            int n = string.indexOf(58);
            int n2 = string.indexOf(58, n + 1);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 1);
            return CMUtils._namedHostToConnString(string2, string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String _namedHostToConnString(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        return "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + string + ")(PORT=" + string2 + ")))(CONNECT_DATA=(SID=" + string3 + ")))";
    }
}

