/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class ConnectInformationDialog
implements ConnectInfoPrompter,
ActionListener {
    protected ConnectionDescriptor _descriptor;
    protected Panel _contentPane;
    boolean _cancelled = false;
    protected Dialog dialog;
    private static final int DEFAULT_FIELD_SIZE = 25;

    public void promptUser(ConnectionDescriptor connectionDescriptor) throws CMException {
        this._descriptor = connectionDescriptor;
        try {
            this.run();
        }
        catch (Exception exception) {
            throw new CMException("Caught exception while displaying Connect dialog.");
        }
        if (this._cancelled) {
            throw new CMException("User canceled Connect dialog.");
        }
    }

    protected void addComponent(Panel panel, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        if (null != string) {
            component.setName(string);
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component);
    }

    protected String getFieldValue(String string) {
        Component[] componentArray = null;
        try {
            componentArray = this._contentPane.getComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < componentArray.length; ++i) {
            String string2 = componentArray[i].getName();
            if (null == string2 || !string2.equals(string)) continue;
            return ((TextField)componentArray[i]).getText();
        }
        return null;
    }

    protected void run() {
        this._contentPane = new Panel();
        TextField textField = null;
        String string = null;
        Panel panel = null;
        Button button = null;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._contentPane.setLayout(gridBagLayout);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.addComponent(this._contentPane, new Label("Username:"), gridBagLayout, gridBagConstraints, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        string = this._descriptor.getUsername();
        string = null == string ? "" : string;
        textField = new TextField(string, 25);
        textField.addActionListener(this);
        this.addComponent(this._contentPane, textField, gridBagLayout, gridBagConstraints, "username");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.addComponent(this._contentPane, new Label("Password:"), gridBagLayout, gridBagConstraints, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        textField = new TextField(25);
        textField.setEchoChar('*');
        textField.addActionListener(this);
        this.addComponent(this._contentPane, textField, gridBagLayout, gridBagConstraints, "password");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.addComponent(this._contentPane, new Label("Role:"), gridBagLayout, gridBagConstraints, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        string = this._descriptor.getRole();
        string = null == string ? "" : string;
        textField = new TextField(string, 25);
        textField.addActionListener(this);
        this.addComponent(this._contentPane, textField, gridBagLayout, gridBagConstraints, "role");
        this.dialog = new Dialog(new Frame(), this._descriptor.getConnectionName(), true);
        this.dialog.setResizable(false);
        this.dialog.add((Component)this._contentPane, "Center");
        panel = new Panel();
        button = new Button("OK");
        button.setActionCommand("OK");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.setActionCommand("Cancel");
        button.addActionListener(this);
        panel.add(button);
        this.dialog.add((Component)panel, "South");
        this.dialog.pack();
        try {
            this._centerDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialog.setVisible(true);
        if (!this._cancelled) {
            this._descriptor.put("user", this.getFieldValue("username"));
            this._descriptor.put("password", this.getFieldValue("password"));
            this._descriptor.put("Role", this.getFieldValue("role"));
        }
        this.dialog.dispose();
    }

    private void _centerDialog() throws Exception {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.dialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.dialog.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            this._cancelled = true;
            this.dialog.setVisible(false);
        } else if (string.equals("OK")) {
            this._cancelled = false;
            this.dialog.setVisible(false);
        } else {
            try {
                String string2 = ((Component)actionEvent.getSource()).getName();
                if (null != string2 && (string2.equals("username") || string2.equals("password") || string2.equals("role"))) {
                    this._cancelled = false;
                    this.dialog.setVisible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

