/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionFactory;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.InSenHashtable;
import oracle.jdeveloper.cm.WritableConnectionStore;

public final class ConnectionManager {
    private static final Object __LOCK__ = new Object();
    private static ConnectionManager _singleton;
    private Map _connectionDescriptors = new InSenHashtable();
    private Map _connectionFactories = Collections.synchronizedMap(new HashMap());
    private Map _connectionTypes = new HashMap();
    private List _connectionTypeNames = new ArrayList();
    private boolean _loadedConnectionTypes;
    private boolean _loadedConnectionDescriptors = false;
    private List _connectionListeners = new ArrayList();
    private ConnectInfoPrompter _defaultPrompter;
    private ConnectionStore _cStore = new DefaultConnectionStore();
    private boolean _defaultPrompterSet = false;

    public String[] getConnectionTypeNames() {
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        return this._connectionTypeNames.toArray(new String[this._connectionTypeNames.size()]);
    }

    public ConnectionType getConnectionType(String string) {
        if (string == null) {
            return null;
        }
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        return (ConnectionType)this._connectionTypes.get(string);
    }

    public Iterator getConnectionTypes() {
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this._connectionTypeNames.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this._connectionTypes.get(iterator.next()));
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnectionDescriptor(String string, ConnectionDescriptor connectionDescriptor) throws IOException {
        ConnectionDescriptor connectionDescriptor2;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            connectionDescriptor2 = this.getConnectionDescriptorImpl(string);
            connectionDescriptor = (ConnectionDescriptor)connectionDescriptor.clone();
            connectionDescriptor.put("ConnectionName", string);
            if (null != connectionDescriptor2 && connectionDescriptor2.equals(connectionDescriptor)) {
                return;
            }
            this._connectionDescriptors.put(string, connectionDescriptor);
        }
        if (null == connectionDescriptor2) {
            this.fireConnectionEvent(0, connectionDescriptor);
        } else {
            this.fireConnectionEvent(1, connectionDescriptor2, connectionDescriptor);
        }
    }

    public void deployToFile(String string) throws CMException {
        this.deployToFile(string, false);
    }

    public void deployToFile(String string, boolean bl) throws CMException {
        ArrayList arrayList;
        if (!this._loadedConnectionDescriptors) {
            try {
                this.loadConnectionDescriptors();
            }
            catch (IOException iOException) {
                throw new CMException(iOException);
            }
        }
        WritableConnectionStore writableConnectionStore = null;
        if (this._cStore instanceof WritableConnectionStore) {
            writableConnectionStore = (WritableConnectionStore)this._cStore;
            arrayList = new ArrayList();
            Iterator iterator = this._connectionDescriptors.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        } else {
            throw new CMException(new IllegalArgumentException("ConnectionStore is not a WritableConnectionStore"));
        }
        writableConnectionStore.write(string, arrayList, bl);
        arrayList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (null == _singleton) {
                ConnectionManager connectionManager;
                _singleton = connectionManager = new ConnectionManager();
                return connectionManager;
            }
        }
        return _singleton;
    }

    public static ConnectionManager getPrivateInstance() {
        return new ConnectionManager();
    }

    public ConnectionWrapper getConnection(String string) throws IOException, CMException {
        return this.getConnection(string, this.getDefaultPrompter());
    }

    public ConnectionWrapper getConnection(String string, ConnectInfoPrompter connectInfoPrompter) throws IOException, CMException {
        return this.createNewConnection(string, connectInfoPrompter);
    }

    public ConnectionWrapper getConnection(String string, Properties properties) throws CMException, IOException {
        return this.getConnection(string, properties, this.getDefaultPrompter());
    }

    public ConnectionWrapper getConnection(String string, Properties properties, ConnectInfoPrompter connectInfoPrompter) throws CMException, IOException {
        ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptor(string);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            connectionDescriptor.put(obj, properties.get(obj));
        }
        return this.createNewConnectionImpl(connectionDescriptor, connectInfoPrompter);
    }

    public ConnectionWrapper getConnection(ConnectionDescriptor connectionDescriptor) throws CMException {
        return this.getConnection(connectionDescriptor, this.getDefaultPrompter());
    }

    public ConnectionWrapper getConnection(ConnectionDescriptor connectionDescriptor, ConnectInfoPrompter connectInfoPrompter) throws CMException {
        return this.createNewConnectionImpl(connectionDescriptor, connectInfoPrompter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionDescriptor getUniqueConnectionDescriptor(String string) throws IOException {
        if (null == string) {
            string = "Connection";
        }
        int n = 1;
        ConnectionDescriptor connectionDescriptor = null;
        String string2 = string + n;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            while ((connectionDescriptor = this.getConnectionDescriptorImpl(string2)) != null) {
                string2 = string + ++n;
            }
        }
        connectionDescriptor = new ConnectionDescriptor();
        connectionDescriptor.put("ConnectionName", string2);
        return connectionDescriptor;
    }

    public ConnectionDescriptor getConnectionDescriptor(String string) throws IOException {
        ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptorImpl(string);
        return connectionDescriptor != null ? (ConnectionDescriptor)connectionDescriptor.clone() : null;
    }

    public boolean connectionDescriptorExists(String string) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        return this._connectionDescriptors.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionNames() throws IOException {
        Object object;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            Object object2;
            if (!this._loadedConnectionDescriptors) {
                this.loadConnectionDescriptors();
            }
            object = new String[this._connectionDescriptors.size()];
            Iterator iterator = this._connectionDescriptors.values().iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object[n] = ((ConnectionDescriptor)object2).getProperty("ConnectionName");
                if (object[n] == null) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            if (n2 > 0) {
                object2 = new String[((String[])object).length - n2];
                try {
                    System.arraycopy(object, 0, object2, 0, ((V)object2).length);
                    object = object2;
                }
                catch (Exception exception) {
                    throw new IOException();
                }
            }
        }
        return object;
    }

    public String[] getConnectionNames(String string) throws IOException {
        return this.getConnectionNames(string, false);
    }

    public String[] getConnectionNames(String string, boolean bl) throws IOException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put("ConnectionType", string);
        }
        if (bl && (string == null || string.equals("JDBC") || string.equals("JDBC") || string.equals("ORACLE_JSERVER"))) {
            ArrayList<String> arrayList = new ArrayList<String>();
            properties.put("JdbcDriver", "oracle.jdbc.driver.OracleDriver");
            arrayList.addAll(Arrays.asList(this.getConnectionNames(properties)));
            properties.put("JdbcDriver", "oracle.jdbc.OracleDriver");
            arrayList.addAll(Arrays.asList(this.getConnectionNames(properties)));
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.getConnectionNames(properties);
    }

    public String[] getConnectionNames(Properties properties) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this._connectionDescriptors.values().iterator();
        while (iterator.hasNext()) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)iterator.next();
            boolean bl = true;
            Enumeration<Object> enumeration = properties.keys();
            while (bl && enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                String string = (String)properties.get(object);
                String string2 = (String)connectionDescriptor.get(object);
                if (!(null == string2 && null != string || null == string && null != string2) && (null == string || string.equals(string2))) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(connectionDescriptor.getConnectionName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getConnectionNamesForClass(String string) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this._connectionDescriptors.values().iterator();
        while (iterator.hasNext()) {
            String string2;
            ConnectionType connectionType;
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)iterator.next();
            String string3 = connectionDescriptor.getConnectionType();
            if (string3 == null || (connectionType = this.getConnectionType(string3)) == null || !(string2 = connectionType.getConnectionClassName()).equals(string)) continue;
            arrayList.add(connectionDescriptor.getConnectionName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getConnectionTypeNamesForClass(String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getConnectionTypes();
        while (iterator.hasNext()) {
            ConnectionType connectionType = (ConnectionType)iterator.next();
            String string2 = connectionType.getConnectionClassName();
            if (!string2.equals(string)) continue;
            arrayList.add(connectionType.getTypeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ConnectInfoPrompter getDefaultPrompter() {
        if (null == this._defaultPrompter && !this._defaultPrompterSet) {
            try {
                this._defaultPrompter = (ConnectInfoPrompter)Class.forName("oracle.jdeveloper.cm.ConnectInformationDialog").newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this._defaultPrompter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionDescriptor removeConnectionDescriptor(String string) throws IOException {
        ConnectionDescriptor connectionDescriptor;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            connectionDescriptor = this.getConnectionDescriptorImpl(string);
            this._connectionDescriptors.remove(string);
        }
        if (null != connectionDescriptor) {
            this.fireConnectionEvent(4, connectionDescriptor);
        }
        return connectionDescriptor;
    }

    public void setPrompter(ConnectInfoPrompter connectInfoPrompter) {
        this.setDefaultPrompter(connectInfoPrompter);
    }

    public void setDefaultPrompter(ConnectInfoPrompter connectInfoPrompter) {
        this._defaultPrompterSet = true;
        this._defaultPrompter = connectInfoPrompter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.add(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.remove(connectionListener);
        }
    }

    void fireConnectionEvent(int n, Object object) {
        this.fireConnectionEvent(n, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireConnectionEvent(int n, Object object, Object object2) {
        ArrayList arrayList = new ArrayList();
        Object object3 = this._connectionListeners;
        synchronized (object3) {
            if (this._connectionListeners.size() == 0) {
                return;
            }
            arrayList.addAll(this._connectionListeners);
        }
        object3 = new ConnectionEvent(n, object, object2);
        Iterator iterator = arrayList.iterator();
        switch (n) {
            case 1: {
                this.fireConnectionModified(iterator, (ConnectionEvent)object3);
                break;
            }
            case 0: {
                this.fireConnectionAdded(iterator, (ConnectionEvent)object3);
                break;
            }
            case 4: {
                this.fireConnectionRemoved(iterator, (ConnectionEvent)object3);
                break;
            }
            case 2: {
                this.fireConnectionOpened(iterator, (ConnectionEvent)object3);
                break;
            }
            case 3: {
                this.fireConnectionClosed(iterator, (ConnectionEvent)object3);
            }
        }
    }

    private void fireConnectionModified(Iterator iterator, ConnectionEvent connectionEvent) {
        while (iterator.hasNext()) {
            ((ConnectionListener)iterator.next()).connectionModified(connectionEvent);
        }
    }

    private void fireConnectionAdded(Iterator iterator, ConnectionEvent connectionEvent) {
        while (iterator.hasNext()) {
            ((ConnectionListener)iterator.next()).connectionAdded(connectionEvent);
        }
    }

    private void fireConnectionRemoved(Iterator iterator, ConnectionEvent connectionEvent) {
        while (iterator.hasNext()) {
            ((ConnectionListener)iterator.next()).connectionRemoved(connectionEvent);
        }
    }

    private void fireConnectionOpened(Iterator iterator, ConnectionEvent connectionEvent) {
        while (iterator.hasNext()) {
            ((ConnectionListener)iterator.next()).connectionOpened(connectionEvent);
        }
    }

    private void fireConnectionClosed(Iterator iterator, ConnectionEvent connectionEvent) {
        while (iterator.hasNext()) {
            ((ConnectionListener)iterator.next()).connectionClosed(connectionEvent);
        }
    }

    private ConnectionDescriptor getConnectionDescriptorImpl(String string) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        return (ConnectionDescriptor)this._connectionDescriptors.get(string);
    }

    private void loadConnectionDescriptors() throws IOException {
        if (!this._loadedConnectionDescriptors) {
            List list = this._cStore.read();
            if (null == list) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)iterator.next();
                this._connectionDescriptors.put(connectionDescriptor.getProperty("ConnectionName"), connectionDescriptor);
            }
            this._loadedConnectionDescriptors = true;
        }
    }

    public void setConnectionStore(ConnectionStore connectionStore) {
        this._loadedConnectionDescriptors = false;
        this._cStore = connectionStore;
    }

    public ConnectionStore getConnectionStore() {
        return this._cStore;
    }

    void registerConnectionType(ConnectionType connectionType) {
        try {
            String string = connectionType.getTypeName();
            if (this._connectionTypes.put(string, connectionType) == null) {
                this._connectionTypeNames.add(string);
            }
            this.registerFactory(string, connectionType.getFactoryClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConnectionManager() {
    }

    /*
     * Unable to fully structure code
     */
    private void registerConnectionTypes() {
        var1_1 = new Properties();
        var2_2 = 0;
        try {
            var3_3 = ConnectionManager.getInputStream(this.getClass(), "ConnectionTypes.properties");
            var1_1.load((InputStream)var3_3);
            var2_2 = Integer.parseInt((String)var1_1.get("nc"));
        }
        catch (Exception var3_4) {
            // empty catch block
        }
        if (var2_2 == 0) {
            try {
                var3_3 = Class.forName("oracle.jdeveloper.cm.OracleJdbcConnectionType");
                this.registerConnectionType((ConnectionType)var3_3.newInstance());
            }
            catch (Throwable var3_5) {
                if (!(var3_5 instanceof ThreadDeath)) ** GOTO lbl32
                throw (ThreadDeath)var3_5;
            }
        } else {
            for (var3_6 = 1; var3_6 <= var2_2; ++var3_6) {
                block9: {
                    var4_7 = null;
                    var5_8 = (String)var1_1.get("c" + var3_6);
                    try {
                        var4_7 = (ConnectionType)Class.forName(var5_8).newInstance();
                    }
                    catch (Throwable var6_9) {
                        System.err.println("Unable to create instance of ConnectionType");
                        System.err.println("Type=[ " + var5_8 + "]");
                        if (!(var6_9 instanceof ThreadDeath)) break block9;
                        throw (ThreadDeath)var6_9;
                    }
                }
                this.registerConnectionType(var4_7);
            }
        }
lbl32:
        // 3 sources

        this._loadedConnectionTypes = true;
    }

    private void registerFactory(String string, String string2) {
        try {
            this._connectionFactories.put(string, Class.forName(string2).newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConnectionWrapper createNewConnection(String string, ConnectInfoPrompter connectInfoPrompter) throws IOException, CMException {
        ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptorImpl(string);
        if (null == connectionDescriptor) {
            return null;
        }
        return this.createNewConnectionImpl(connectionDescriptor, connectInfoPrompter);
    }

    private ConnectionWrapper createNewConnectionImpl(ConnectionDescriptor connectionDescriptor, ConnectInfoPrompter connectInfoPrompter) throws CMException {
        ConnectionFactory connectionFactory;
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        if (null == (connectionFactory = (ConnectionFactory)this._connectionFactories.get(connectionDescriptor.getConnectionType()))) {
            throw new CMException("Unable to instantiate connection factory (" + connectionDescriptor.getConnectionType() + ")");
        }
        ConnectionWrapper connectionWrapper = connectionFactory.createConnection(connectionDescriptor, connectInfoPrompter, this);
        this.fireConnectionEvent(2, connectionWrapper);
        return connectionWrapper;
    }

    static InputStream getInputStream(Class clazz, String string) {
        InputStream inputStream;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : null;
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(string);
        }
        return inputStream;
    }
}

