/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.PropertiesConnectionStore;
import oracle.jdeveloper.cm.WritableConnectionStore;
import oracle.security.misc.Checksum;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class DefaultConnectionStore
extends DefaultHandler
implements WritableConnectionStore,
LexicalHandler {
    public static final String DEFAULT_FILE = "connections.xml";
    public static final String CONNECTION_TAG = "connection";
    public static final String ROOT_TAG = "connections";
    private static final String PWD_PROP = "PWD";
    private static final String ORMI_PWD_PROP = "ORMI-PWD";
    private final String fName;
    private final boolean isAbsolutePath;
    private List _list = null;
    private ConnectionDescriptor _curDesc = null;
    private String _curKey;
    private StringBuffer _curValue;
    private String _cdata;

    public DefaultConnectionStore() {
        this("/connections.xml", false);
    }

    public DefaultConnectionStore(String string, boolean bl) {
        this.fName = string;
        this.isAbsolutePath = bl;
    }

    public final void write(String string, List list, boolean bl) throws CMException {
        try {
            Object object;
            XMLDocument xMLDocument = new XMLDocument();
            xMLDocument.setVersion("1.0");
            xMLDocument.setDoctype(ROOT_TAG, null, null);
            Element element = xMLDocument.createElement(ROOT_TAG);
            File file = new File(string);
            if (file != null && (object = file.getParentFile()) != null) {
                ((File)object).mkdirs();
            }
            object = new FileOutputStream(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Element element2 = xMLDocument.createElement(CONNECTION_TAG);
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)((ConnectionDescriptor)iterator.next()).clone();
                if (bl && !connectionDescriptor.isDeployPassword()) {
                    connectionDescriptor.remove("password");
                }
                Enumeration<Object> enumeration = connectionDescriptor.keys();
                while (enumeration.hasMoreElements()) {
                    Object object2;
                    Object object3 = enumeration.nextElement();
                    Object object4 = connectionDescriptor.get(object3);
                    Text text = null;
                    if (object3 == null) continue;
                    if ("password".equals(object3) || "ormi-password".equals(object3)) {
                        Object object5 = object3 = "password".equals(object3) ? PWD_PROP : ORMI_PWD_PROP;
                        if (object4 != null) {
                            try {
                                object2 = object4.toString().getBytes();
                                byte[] byArray = Checksum.MD5((byte[])object2, null);
                                text = xMLDocument.createCDATASection(RepConversion.bArray2String(byArray));
                            }
                            catch (Exception exception) {}
                        }
                    } else if (object4 != null) {
                        text = xMLDocument.createTextNode(object4.toString());
                    }
                    object2 = xMLDocument.createElement(object3.toString());
                    if (text != null) {
                        object2.appendChild(text);
                    }
                    element2.appendChild((Node)object2);
                }
                element.appendChild(element2);
            }
            xMLDocument.appendChild((Node)element);
            xMLDocument.print((OutputStream)object);
            ((FileOutputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CMException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CMException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List read() {
        SAXParser sAXParser = null;
        try {
            this._list = null;
            InputStream inputStream = null;
            try {
                inputStream = this.isAbsolutePath ? new FileInputStream(this.fName) : ConnectionManager.getInputStream(this.getClass(), this.fName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (null != inputStream) {
                try {
                    sAXParser = new SAXParser();
                    sAXParser.setContentHandler((ContentHandler)this);
                    sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                    sAXParser.parse(inputStream);
                }
                catch (SAXException sAXException) {
                }
                finally {
                    if (sAXParser != null) {
                        sAXParser.reset();
                        sAXParser = null;
                    }
                }
            }
            if (this._list == null || this._list.size() == 0) {
                this._list = this._readPCS();
            } else {
                Iterator iterator;
                List list = this._readPCS();
                Iterator iterator2 = iterator = list != null ? list.iterator() : Collections.EMPTY_LIST.iterator();
                while (iterator.hasNext()) {
                    ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)iterator.next();
                    if (this._listContains(connectionDescriptor.getConnectionName())) continue;
                    this._list.add(connectionDescriptor);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._list;
    }

    private final List _readPCS() {
        List list = null;
        PropertiesConnectionStore propertiesConnectionStore = new PropertiesConnectionStore(this.fName, this.isAbsolutePath);
        list = propertiesConnectionStore.read();
        if (!(list != null && list.size() != 0 || this.isAbsolutePath)) {
            propertiesConnectionStore = new PropertiesConnectionStore();
            list = propertiesConnectionStore.read();
        }
        return list;
    }

    private final boolean _listContains(String string) {
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)iterator.next();
            if (!connectionDescriptor.getConnectionName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void startDocument() {
        if (this._list == null) {
            this._list = new ArrayList(10);
        } else {
            this._list.clear();
        }
    }

    public void endDocument() {
        this._curKey = null;
        this._curValue = null;
        this._curDesc = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals(CONNECTION_TAG)) {
            this._curDesc = new ConnectionDescriptor();
            this._curKey = null;
            this._curValue = null;
            this._cdata = null;
        } else if (this._curDesc != null) {
            this._curKey = string2;
            this._curValue = new StringBuffer();
            this._cdata = null;
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string2.equals(CONNECTION_TAG)) {
            if (this._curDesc != null && this._curDesc.getConnectionName() != null) {
                this._list.add(this._curDesc);
            }
            this._curDesc = null;
        } else if (this._curDesc != null && this._curKey != null) {
            String string4 = this._curValue.toString();
            if ("ConnectionType".equals(this._curKey) && "IAS".equals(this._curValue.toString())) {
                string4 = "OC4J";
            } else if ("IAS_HOME".equals(this._curKey)) {
                this._curKey = "OC4J_HOME";
            } else if ("password".equals(this._curKey)) {
                if (this._curDesc.getPassword() != null) {
                    this._curKey = null;
                }
            } else if (PWD_PROP.equals(this._curKey) || ORMI_PWD_PROP.equals(this._curKey)) {
                string4 = null;
                String string5 = this._curKey = PWD_PROP.equals(this._curKey) ? "password" : "ormi-password";
                if (this._cdata != null) {
                    try {
                        byte[] byArray = RepConversion.convertHexStringToByte(this._cdata);
                        byte[] byArray2 = Checksum.SHA((byte[])byArray, null);
                        string4 = new String(byArray2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this._curKey != null) {
                this._curDesc.put(this._curKey, string4);
            }
        }
        this._curKey = null;
        this._curValue = null;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this._curKey != null) {
            this._curValue.append(cArray, n, n2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this._cdata = this._curValue.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this._curValue.setLength(0);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    private static class RepConversion {
        private RepConversion() {
        }

        public static byte nibbleToHex(byte by) {
            return (byte)((by = (byte)(by & 0xF)) < 10 ? by + 48 : by - 10 + 65);
        }

        public static String bArray2String(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append((char)RepConversion.nibbleToHex((byte)((byArray[i] & 0xF0) >> 4)));
                stringBuffer.append((char)RepConversion.nibbleToHex((byte)(byArray[i] & 0xF)));
            }
            return stringBuffer.toString();
        }

        static int convertCharToInt(char c) {
            switch (c) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        public static byte[] convertHexStringToByte(String string) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                int n = RepConversion.convertCharToInt(string.charAt(i));
                Integer n2 = new Integer(0xF0 & n << 4);
                byArray[i / 2] = n2.byteValue();
                n = RepConversion.convertCharToInt(string.charAt(i + 1));
                n2 = new Integer(0xF & n);
                int n3 = i / 2;
                byArray[n3] = (byte)(byArray[n3] | n2.byteValue());
            }
            return byArray;
        }
    }
}

