/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.jdeveloper.cm.AbstractConnectionWrapper;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;

public class JndiConnectionWrapper
extends AbstractConnectionWrapper {
    private Context _ic = null;
    private static final String OC4J_INITIAL_FACTORY = "com.evermind.server.rmi.RMIInitialContextFactory";

    JndiConnectionWrapper(ConnectionDescriptor connectionDescriptor, ConnectInfoPrompter connectInfoPrompter, ConnectionManager connectionManager) throws CMException {
        super(connectionDescriptor, connectInfoPrompter, connectionManager);
        this._connTypes = new ArrayList(1);
        this._connTypes.add("JNDI");
    }

    void createConnection(ConnectionDescriptor connectionDescriptor) throws CMException {
        if (null != this._prompter) {
            this._prompter.promptUser(connectionDescriptor);
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string = connectionDescriptor.getProperty("JNDI_INITIAL_CONTEXT_FACTORY");
            hashtable.put("java.naming.factory.initial", string != null ? string : OC4J_INITIAL_FACTORY);
            string = connectionDescriptor.getUsername();
            hashtable.put("java.naming.security.principal", string != null ? string : "");
            string = connectionDescriptor.getPassword();
            hashtable.put("java.naming.security.credentials", string != null ? string : "");
            string = connectionDescriptor.getURL();
            hashtable.put("java.naming.provider.url", string != null ? string : "");
            hashtable.put("dedicated.connection", "true");
            this._ic = new InitialContext(hashtable);
        }
        catch (Exception exception) {
            throw new CMException(exception);
        }
    }

    public Object getPresentation(String string) throws CMException {
        try {
            if (string.equals("JNDI")) {
                if (this._ic == null) {
                    this.createConnection(this._descriptor);
                }
                return this._ic;
            }
        }
        catch (CMException cMException) {
            throw cMException;
        }
        catch (NullPointerException nullPointerException) {
            throw new CMException(nullPointerException);
        }
        throw new CMException("Cannot find presentation for " + string + " in this ConnectionWrapper instance");
    }

    public Context getContext() {
        return this._ic;
    }

    public boolean containsPresentation(String string) {
        return string.equals("JNDI");
    }

    public void closeConnection() {
        try {
            this._ic.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void testPresentation(String string) throws CMException {
        this.getPresentation(string);
        if (this._ic == null) {
            throw new CMException("NULL InitialContext");
        }
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = this._ic.list("");
            namingEnumeration.close();
        }
        catch (Exception exception) {
            throw new CMException(exception);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new CMException(throwable.toString());
        }
    }
}

